/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.core;

import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mapeditor.core.Tile;

public class Sprite {
    private List<KeyFrame> keys;
    private int borderWidth = 0;
    private int fpl = 0;
    private int totalKeys = -1;
    private float currentFrame = 0.0f;
    private Rectangle frameSize;
    private boolean bPlaying = true;
    private KeyFrame currentKey = null;

    public Sprite() {
        this.frameSize = new Rectangle();
        this.keys = new ArrayList<KeyFrame>();
    }

    public Sprite(Tile[] frames) {
        this.setFrames(frames);
    }

    public Sprite(Image image, int fpl, int border, int totalFrames) {
        Tile[] frames = null;
        this.fpl = fpl;
        this.borderWidth = border;
        this.frameSize.width = image.getWidth(null) / (fpl + this.borderWidth * fpl);
        this.frameSize.height = (int)((double)image.getHeight(null) / (Math.ceil(totalFrames / fpl) + Math.ceil(totalFrames / fpl) * (double)this.borderWidth));
        this.createKey("", frames, 1);
    }

    public final void setFrames(Tile[] frames) {
        this.frameSize = new Rectangle(0, 0, frames[0].getWidth(), frames[0].getHeight());
        this.createKey("", frames, 1);
    }

    public void setFrameSize(int w, int h) {
        this.frameSize.width = w;
        this.frameSize.height = h;
    }

    public void setBorderWidth(int b) {
        this.borderWidth = b;
    }

    public void setFpl(int f) {
        this.fpl = f;
    }

    public void setCurrentFrame(float c) {
        if (c < 0.0f) {
            switch (this.currentKey.flags & 0xF) {
                case 1: {
                    this.currentFrame = this.currentKey.getLastFrame();
                    break;
                }
                case 4: {
                    this.currentKey = this.getPreviousKey();
                    this.currentFrame = this.currentKey.getLastFrame();
                    break;
                }
                case 8: {
                    this.currentKey.setFrameRate(-this.currentKey.getFrameRate());
                    this.currentFrame = 0.0f;
                    break;
                }
                case 2: {
                    this.bPlaying = false;
                    this.currentFrame = 0.0f;
                }
            }
        } else if (c > (float)this.currentKey.getLastFrame()) {
            switch (this.currentKey.flags & 0xF) {
                case 1: {
                    this.currentFrame = 0.0f;
                    break;
                }
                case 4: {
                    this.currentFrame = 0.0f;
                    this.currentKey = this.getNextKey();
                    break;
                }
                case 8: {
                    this.currentKey.setFrameRate(-this.currentKey.getFrameRate());
                    this.currentFrame = this.currentKey.getLastFrame();
                    break;
                }
                case 2: {
                    this.bPlaying = false;
                    this.currentFrame = this.currentKey.getLastFrame();
                }
            }
        } else {
            this.currentFrame = c;
        }
    }

    public void setTotalKeys(int t) {
        this.totalKeys = t;
    }

    public Rectangle getFrameSize() {
        return this.frameSize;
    }

    public int getTotalFrames() {
        return this.keys.stream().map(key -> key.getTotalFrames()).reduce(0, Integer::sum);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Tile getCurrentFrame() {
        return this.currentKey.getFrame((int)this.currentFrame);
    }

    public KeyFrame getNextKey() {
        Iterator<KeyFrame> itr = this.keys.iterator();
        while (itr.hasNext()) {
            KeyFrame k = itr.next();
            if (k != this.currentKey || !itr.hasNext()) continue;
            return itr.next();
        }
        return this.keys.get(0);
    }

    public KeyFrame getPreviousKey() {
        return null;
    }

    public KeyFrame getCurrentKey() {
        return this.currentKey;
    }

    public int getFPL() {
        return this.fpl;
    }

    public int getTotalKeys() {
        return this.keys.size();
    }

    public void setKeyFrameTo(String name) {
        for (KeyFrame k : this.keys) {
            if (!k.equalsIgnoreCase(name)) continue;
            this.currentKey = k;
            break;
        }
    }

    public void addKey(KeyFrame k) {
        this.keys.add(k);
    }

    public void removeKey(String name) {
        this.keys.remove(this.getKey(name));
    }

    public final void createKey(String name, Tile[] frames, int flags) {
        KeyFrame kf = new KeyFrame(name, frames);
        kf.setName(name);
        kf.setFlags(flags);
        this.addKey(kf);
    }

    public void iterateFrame() {
        if (this.currentKey != null && this.bPlaying) {
            this.setCurrentFrame(this.currentFrame + this.currentKey.getFrameRate());
        }
    }

    public void keySetFrame(int c) {
        this.setCurrentFrame(c);
    }

    public void play() {
        this.bPlaying = true;
    }

    public void stop() {
        this.bPlaying = false;
    }

    public void keyStepBack(int amt) {
        this.setCurrentFrame(this.currentFrame - (float)amt);
    }

    public void keyStepForward(int amt) {
        this.setCurrentFrame(this.currentFrame + (float)amt);
    }

    public KeyFrame getKey(String keyName) {
        for (KeyFrame k : this.keys) {
            if (k == null || !k.equalsIgnoreCase(keyName)) continue;
            return k;
        }
        return null;
    }

    public KeyFrame getKey(int i) {
        return this.keys.get(i);
    }

    public Iterator<KeyFrame> getKeys() throws Exception {
        return this.keys.iterator();
    }

    public Rectangle getCurrentFrameRect() {
        int x = 0;
        int y = 0;
        if (this.frameSize.height > 0 && this.frameSize.width > 0) {
            y = (int)this.currentFrame / this.fpl * (this.frameSize.height + this.borderWidth);
            x = (int)this.currentFrame % this.fpl * (this.frameSize.width + this.borderWidth);
        }
        return new Rectangle(x, y, this.frameSize.width, this.frameSize.height);
    }

    public String toString() {
        return "Frame: (" + this.frameSize.width + "x" + this.frameSize.height + ")\nBorder: " + this.borderWidth + "\nFPL: " + this.fpl + "\nTotal Frames: " + this.getTotalFrames() + "\nTotal keys: " + this.totalKeys;
    }

    public class KeyFrame {
        public static final int MASK_ANIMATION = 15;
        public static final int KEY_LOOP = 1;
        public static final int KEY_STOP = 2;
        public static final int KEY_AUTO = 4;
        public static final int KEY_REVERSE = 8;
        public static final int KEY_NAME_LENGTH_MAX = 32;
        private String name = null;
        private int id = -1;
        private int flags = 1;
        private float frameRate = 1.0f;
        private Tile[] frames;

        public KeyFrame() {
        }

        public KeyFrame(String name) {
            this();
            this.name = name;
        }

        public KeyFrame(String name, Tile[] tile) {
            this(name);
            this.frames = tile;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setFrameRate(float r) {
            this.frameRate = r;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public int getLastFrame() {
            return this.frames.length - 1;
        }

        public boolean isFrameLast(int frame) {
            return this.frames.length - 1 == frame;
        }

        public void setFlags(int f) {
            this.flags = f;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getName() {
            return this.name;
        }

        public Tile getFrame(int f) {
            if (f > 0 && f < this.frames.length) {
                return this.frames[f];
            }
            return null;
        }

        public float getFrameRate() {
            return this.frameRate;
        }

        public int getTotalFrames() {
            return this.frames.length;
        }

        public boolean equalsIgnoreCase(String n) {
            return this.name != null && this.name.equalsIgnoreCase(n);
        }

        public String toString() {
            return "(" + this.name + ")" + this.id + ": @ " + this.frameRate;
        }
    }
}

