/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.core;

import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.mapeditor.core.Properties;
import org.mapeditor.core.TileData;
import org.mapeditor.core.TileSet;

@XmlAccessorType(value=XmlAccessType.NONE)
public class Tile
extends TileData {
    private BufferedImage image;
    private String source;
    private TileSet tileset;

    public Tile() {
        this.id = -1;
    }

    public Tile(TileSet set) {
        this();
        this.tileset = set;
    }

    public Tile(Tile t) {
        this.tileset = t.tileset;
        Properties tileProperties = t.properties;
        if (tileProperties != null) {
            try {
                this.properties = tileProperties.clone();
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(Tile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void setId(Integer value) {
        if (value >= 0) {
            this.id = value;
        }
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public void setTileSet(TileSet set) {
        this.tileset = set;
    }

    public TileSet getTileSet() {
        return this.tileset;
    }

    public int getWidth() {
        if (this.image != null) {
            return this.image.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.image != null) {
            return this.image.getHeight();
        }
        return 0;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return super.getProperties();
    }

    public String toString() {
        return "Tile " + this.id + " (" + this.getWidth() + "x" + this.getHeight() + ")";
    }
}

