/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.core;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.mapeditor.core.Tile;
import org.mapeditor.core.TileSetData;
import org.mapeditor.util.BasicTileCutter;
import org.mapeditor.util.TileCutter;
import org.mapeditor.util.TransparentImageFilter;

@XmlRootElement(name="tileset")
@XmlAccessorType(value=XmlAccessType.NONE)
public class TileSet
extends TileSetData
implements Iterable<Tile> {
    private long tilebmpFileLastModified;
    private TileCutter tileCutter;
    private File tilebmpFile;
    private Color transparentColor;
    private Image tileSetImage;
    private TreeMap<Integer, Tile> tiles;

    public TileSet() {
        this.internalTiles = new ArrayList();
        this.tiles = new TreeMap();
    }

    public void importTileBitmap(String imgFilename, TileCutter cutter) throws IOException {
        this.setTilesetImageFilename(imgFilename);
        Image image = ImageIO.read(new File(imgFilename));
        if (image == null) {
            throw new IOException("Failed to load " + this.tilebmpFile);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this.transparentColor != null) {
            int rgb = this.transparentColor.getRGB();
            image = tk.createImage(new FilteredImageSource(((Image)image).getSource(), new TransparentImageFilter(rgb)));
        }
        BufferedImage buffered = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
        buffered.getGraphics().drawImage(image, 0, 0, null);
        this.importTileBitmap(buffered, cutter);
    }

    private void importTileBitmap(BufferedImage tileBitmap, TileCutter cutter) {
        assert (tileBitmap != null);
        assert (cutter != null);
        this.tileCutter = cutter;
        this.tileSetImage = tileBitmap;
        cutter.setImage(tileBitmap);
        this.tileWidth = cutter.getTileWidth();
        this.tileHeight = cutter.getTileHeight();
        if (cutter instanceof BasicTileCutter) {
            BasicTileCutter basicTileCutter = (BasicTileCutter)cutter;
            this.tileSpacing = basicTileCutter.getTileSpacing();
            this.tileMargin = basicTileCutter.getTileMargin();
            this.columns = basicTileCutter.getColumns();
        }
        BufferedImage tileImage = cutter.getNextTile();
        while (tileImage != null) {
            Tile tile = new Tile();
            tile.setImage(tileImage);
            this.addNewTile(tile);
            tileImage = cutter.getNextTile();
        }
    }

    private void refreshImportedTileBitmap() throws IOException {
        String imgFilename = this.tilebmpFile.getPath();
        Image image = ImageIO.read(new File(imgFilename));
        if (image == null) {
            throw new IOException("Failed to load " + this.tilebmpFile);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this.transparentColor != null) {
            int rgb = this.transparentColor.getRGB();
            image = tk.createImage(new FilteredImageSource(((Image)image).getSource(), new TransparentImageFilter(rgb)));
        }
        BufferedImage buffered = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
        buffered.getGraphics().drawImage(image, 0, 0, null);
        this.refreshImportedTileBitmap(buffered);
    }

    private void refreshImportedTileBitmap(BufferedImage tileBitmap) {
        assert (tileBitmap != null);
        this.tileCutter.reset();
        this.tileCutter.setImage(tileBitmap);
        this.tileSetImage = tileBitmap;
        this.tileWidth = this.tileCutter.getTileWidth();
        this.tileHeight = this.tileCutter.getTileHeight();
        int id = 0;
        BufferedImage tileImage = this.tileCutter.getNextTile();
        while (tileImage != null) {
            Tile tile = this.getTile(id);
            tile.setImage(tileImage);
            tileImage = this.tileCutter.getNextTile();
            ++id;
        }
    }

    public void checkUpdate() throws IOException {
        if (this.tilebmpFile != null && this.tilebmpFile.lastModified() > this.tilebmpFileLastModified) {
            this.refreshImportedTileBitmap();
            this.tilebmpFileLastModified = this.tilebmpFile.lastModified();
        }
    }

    public void setTilesetImageFilename(String name) {
        if (name != null) {
            this.tilebmpFile = new File(name);
            this.tilebmpFileLastModified = this.tilebmpFile.lastModified();
        } else {
            this.tilebmpFile = null;
        }
    }

    public void setTransparentColor(Color color) {
        this.transparentColor = color;
    }

    public int addTile(Tile t) {
        if (t.getId() < 0) {
            t.setId(this.getMaxTileId() + 1);
        }
        if (this.tileWidth < t.getWidth()) {
            this.tileWidth = t.getWidth();
        }
        if (this.tileHeight < t.getHeight()) {
            this.tileHeight = t.getHeight();
        }
        this.tiles.put(t.getId(), t);
        t.setTileSet(this);
        return t.getId();
    }

    public void addNewTile(Tile t) {
        t.setId(-1);
        this.addTile(t);
    }

    public void removeTile(int i) {
        this.tiles.remove(i);
    }

    public int size() {
        return this.tiles.size();
    }

    public int getMaxTileId() {
        try {
            return this.tiles.lastKey();
        }
        catch (NoSuchElementException e) {
            return -1;
        }
    }

    @Override
    public Iterator<Tile> iterator() {
        return this.tiles.values().iterator();
    }

    public Tile getTile(int i) {
        try {
            return this.tiles.get(i);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Tile getFirstTile() {
        Tile ret = null;
        for (int i = 0; ret == null && i <= this.getMaxTileId(); ++i) {
            ret = this.getTile(i);
        }
        return ret;
    }

    public String getTilebmpFile() {
        if (this.tilebmpFile != null) {
            try {
                return this.tilebmpFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public void beforeMarshal(Marshaller marshaller) {
        this.internalTiles = new ArrayList();
        this.tiles.entrySet().forEach(entry -> this.internalTiles.add(entry.getValue()));
    }

    public void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        this.tiles = new TreeMap();
        this.getInternalTiles().forEach(tile -> this.tiles.put(tile.getId(), (Tile)tile));
    }

    public String toString() {
        return this.getName() + " [" + this.size() + "]";
    }

    public boolean isSetFromImage() {
        return this.tileSetImage != null;
    }
}

