/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.mapeditor.core.Map;
import org.mapeditor.core.TileSet;

public class MapReader {
    public Map readMap(InputStream in, String xmlPath) throws IOException {
        Map unmarshalledMap = this.unmarshal(in, Map.class);
        return this.buildMap(unmarshalledMap, xmlPath);
    }

    public Map readMap(String filename) throws IOException {
        int fileSeparatorIndex = filename.lastIndexOf(File.separatorChar) + 1;
        String xmlPath = this.makeUrl(filename.substring(0, fileSeparatorIndex));
        String xmlFile = this.makeUrl(filename);
        URL url = new URL(xmlFile);
        InputStream is = url.openStream();
        if (filename.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return this.readMap(is, xmlPath);
    }

    public TileSet readTileset(InputStream in) {
        return this.unmarshal(in, TileSet.class);
    }

    public TileSet readTileset(String filename) throws IOException {
        String xmlFile = this.makeUrl(filename);
        URL url = new URL(xmlFile);
        return this.readTileset(url.openStream());
    }

    private Map buildMap(Map map, String xmlPath) throws IOException {
        List<TileSet> tilesets = map.getTileSets();
        for (int i = 0; i < tilesets.size(); ++i) {
            TileSet tileset = tilesets.get(i);
            String tileSetSource = tileset.getSource();
            if (tileSetSource == null) continue;
            int firstGid = tileset.getFirstgid();
            tileset = this.readTileset(xmlPath + tileSetSource);
            tileset.setFirstgid(firstGid);
            tileset.setSource(tileSetSource);
            tilesets.set(i, tileset);
        }
        return map;
    }

    private String makeUrl(String filename) {
        String url = filename.indexOf("://") > 0 || filename.startsWith("file:") ? filename : new File(filename).toURI().toString();
        return url;
    }

    private <T> T unmarshal(InputStream in, Class<T> type) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(in);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal(reader, type);
            return (T)element.getValue();
        }
        catch (JAXBException | XMLStreamException ex) {
            Logger.getLogger(MapReader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

