/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.io.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.mapeditor.io.xml.XMLWriterException;

@Deprecated
public class XMLWriter {
    private boolean bIndent = true;
    private String indentString = " ";
    private String newLine = "\n";
    private final Writer w;
    private final Stack<String> openElements = new Stack();
    private boolean bStartTagOpen;
    private boolean bDocumentOpen;

    public XMLWriter(Writer writer) {
        this.w = writer;
    }

    public void setIndent(boolean bIndent) {
        this.bIndent = bIndent;
        this.newLine = bIndent ? "\n" : "";
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public void startDocument() throws IOException {
        this.startDocument("1.0");
    }

    public void startDocument(String version) throws IOException {
        this.w.write("<?xml version=\"" + version + "\" encoding=\"UTF-8\"?>" + this.newLine);
        this.bDocumentOpen = true;
    }

    public void writeDocType(String name, String pubId, String sysId) throws IOException, XMLWriterException {
        if (!this.bDocumentOpen) {
            throw new XMLWriterException("Can't write DocType, no open document.");
        }
        if (!this.openElements.isEmpty()) {
            throw new XMLWriterException("Can't write DocType, open elements exist.");
        }
        this.w.write("<!DOCTYPE " + name + " ");
        if (pubId != null) {
            this.w.write("PUBLIC \"" + pubId + "\"");
            if (sysId != null) {
                this.w.write(" \"" + sysId + "\"");
            }
        } else if (sysId != null) {
            this.w.write("SYSTEM \"" + sysId + "\"");
        }
        this.w.write(">" + this.newLine);
    }

    public void startElement(String name) throws IOException, XMLWriterException {
        if (!this.bDocumentOpen) {
            throw new XMLWriterException("Can't start new element, no open document.");
        }
        if (this.bStartTagOpen) {
            this.w.write(">" + this.newLine);
        }
        this.writeIndent();
        this.w.write("<" + name);
        this.openElements.push(name);
        this.bStartTagOpen = true;
    }

    public void endDocument() throws IOException {
        while (!this.openElements.isEmpty()) {
            this.endElement();
        }
        this.w.flush();
    }

    public void endElement() throws IOException {
        String name = this.openElements.pop();
        if (this.bStartTagOpen) {
            this.w.write("/>" + this.newLine);
            this.bStartTagOpen = false;
        } else {
            this.writeIndent();
            this.w.write("</" + name + ">" + this.newLine);
        }
        if (this.openElements.isEmpty()) {
            this.bDocumentOpen = false;
        }
    }

    public void writeAttribute(String name, String content) throws IOException, XMLWriterException {
        if (!this.bStartTagOpen) {
            throw new XMLWriterException("Can't write attribute without open start tag.");
        }
        String escapedContent = content != null ? content.replaceAll("\"", "&quot;") : "";
        this.w.write(" " + name + "=\"" + escapedContent + "\"");
    }

    public void writeAttribute(String name, int content) throws IOException, XMLWriterException {
        this.writeAttribute(name, String.valueOf(content));
    }

    public void writeAttribute(String name, float content) throws IOException, XMLWriterException {
        this.writeAttribute(name, String.valueOf(content));
    }

    public void writeAttribute(String name, double content) throws IOException, XMLWriterException {
        this.writeAttribute(name, String.valueOf(content));
    }

    public void writeCDATA(String content) throws IOException {
        if (this.bStartTagOpen) {
            this.w.write(">" + this.newLine);
            this.bStartTagOpen = false;
        }
        this.writeIndent();
        this.w.write(content + this.newLine);
    }

    public void writeComment(String content) throws IOException {
        if (this.bStartTagOpen) {
            this.w.write(">" + this.newLine);
            this.bStartTagOpen = false;
        }
        this.writeIndent();
        this.w.write("<!-- " + content + " -->" + this.newLine);
    }

    public void writeElement(String name, String content) throws IOException, XMLWriterException {
        this.startElement(name);
        this.writeCDATA(content);
        this.endElement();
    }

    private void writeIndent() throws IOException {
        if (this.bIndent) {
            for (String openElement : this.openElements) {
                this.w.write(this.indentString);
            }
        }
    }
}

