/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.core;

import java.awt.Rectangle;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.mapeditor.core.MapData;
import org.mapeditor.core.MapLayer;
import org.mapeditor.core.Orientation;
import org.mapeditor.core.Properties;
import org.mapeditor.core.Tile;
import org.mapeditor.core.TileLayer;
import org.mapeditor.core.TileSet;

@XmlRootElement(name="map")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Map
extends MapData
implements Iterable<MapLayer> {
    private String filename;

    public Map() {
        this.orientation = Orientation.ORTHOGONAL;
    }

    public Map(int width, int height) {
        this();
        this.width = width;
        this.height = height;
    }

    public int getLayerCount() {
        return this.getLayers().size();
    }

    public void fitBoundsToLayers() {
        int width = 0;
        int height = 0;
        Rectangle layerBounds = new Rectangle();
        for (int i = 0; i < this.getLayers().size(); ++i) {
            this.getLayer(i).getBounds(layerBounds);
            if (width < layerBounds.width) {
                width = layerBounds.width;
            }
            if (height >= layerBounds.height) continue;
            height = layerBounds.height;
        }
        this.width = width;
        this.height = height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    public MapLayer addLayer(MapLayer layer) {
        layer.setMap(this);
        this.getLayers().add(layer);
        return layer;
    }

    public void setLayer(int index, TileLayer layer) {
        layer.setMap(this);
        this.getLayers().set(index, layer);
    }

    public void insertLayer(int index, TileLayer layer) {
        layer.setMap(this);
        this.getLayers().add(index, layer);
    }

    public MapLayer removeLayer(int index) {
        return this.getLayers().remove(index);
    }

    public void removeAllLayers() {
        this.getLayers().clear();
    }

    public MapLayer getLayer(int i) {
        try {
            return this.getLayers().get(i);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void resize(int width, int height, int dx, int dy) {
        for (MapLayer layer : this) {
            Rectangle layerBounds = layer.getBounds();
            if (layerBounds.equals(this.getBounds())) {
                layer.resize(width, height, dx, dy);
                continue;
            }
            layer.setOffset(layerBounds.x + dx, layerBounds.y + dy);
        }
        this.width = width;
        this.height = height;
    }

    public boolean inBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public void addTileset(TileSet tileset) {
        int tilesetIndex = this.getTileSets().indexOf(tileset);
        if (tileset == null || tilesetIndex > -1) {
            return;
        }
        Tile t = tileset.getTile(0);
        if (t != null) {
            int tw = t.getWidth();
            int th = t.getHeight();
            if (tw != this.tileWidth && this.tileWidth == 0) {
                this.tileWidth = tw;
                this.tileHeight = th;
            }
        }
        this.tileSets.add(tileset);
    }

    public void removeTileset(TileSet tileset) {
        int tilesetIndex = this.getTileSets().indexOf(tileset);
        if (tilesetIndex == -1) {
            return;
        }
        for (Tile tile : tileset) {
            for (MapLayer ml : this) {
                if (!(ml instanceof TileLayer)) continue;
                TileLayer tl = (TileLayer)ml;
                tl.removeTile(tile);
            }
        }
        this.tileSets.remove(tileset);
    }

    public boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public int getTileHeightMax() {
        int maxHeight = this.tileHeight;
        for (TileSet tileset : this.tileSets) {
            int height = tileset.getTileHeight();
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        return maxHeight;
    }

    public void swapTileSets(int index0, int index1) {
        if (index0 == index1 || this.tileSets == null) {
            return;
        }
        TileSet set = (TileSet)this.tileSets.get(index0);
        this.tileSets.set(index0, this.tileSets.get(index1));
        this.tileSets.set(index1, set);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return super.getProperties();
    }

    @Override
    public Iterator<MapLayer> iterator() {
        return this.getLayers().iterator();
    }

    public String toString() {
        return "Map[" + this.width + "x" + this.height + "x" + this.getLayerCount() + "][" + this.tileWidth + "x" + this.tileHeight + "]";
    }
}

