/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.core;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.mapeditor.core.MapObjectData;
import org.mapeditor.core.ObjectGroup;
import org.mapeditor.core.Properties;
import org.mapeditor.core.Tile;

@XmlAccessorType(value=XmlAccessType.NONE)
public class MapObject
extends MapObjectData
implements Cloneable {
    private ObjectGroup objectGroup;
    private Shape shape = new Rectangle();
    private String imageSource;
    private Image image;
    private Image scaledImage;
    private Tile tile;
    private boolean flipHorizontal;
    private boolean flipVertical;
    private boolean flipDiagonal;

    public MapObject() {
        this.properties = new Properties();
        this.name = "";
        this.type = "";
        this.imageSource = "";
        this.flipHorizontal = false;
        this.flipVertical = false;
    }

    public MapObject(double x, double y, double width, double height, double rotation) {
        this();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.rotation = rotation;
    }

    public Object clone() throws CloneNotSupportedException {
        MapObject clone = (MapObject)super.clone();
        clone.properties = this.properties.clone();
        return clone;
    }

    public ObjectGroup getObjectGroup() {
        return this.objectGroup;
    }

    public void setObjectGroup(ObjectGroup objectGroup) {
        this.objectGroup = objectGroup;
    }

    public Rectangle2D.Double getBounds() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle2D.Double bounds) {
        this.x = bounds.getX();
        this.y = bounds.getY();
        this.width = bounds.getWidth();
        this.height = bounds.getHeight();
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public String getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(String source) {
        if (this.imageSource.equals(source)) {
            return;
        }
        this.imageSource = source;
        if (this.imageSource.length() > 0) {
            try {
                this.image = ImageIO.read(new File(this.imageSource));
            }
            catch (IOException e) {
                this.image = null;
            }
        } else {
            this.image = null;
        }
        this.scaledImage = null;
    }

    public Tile getTile() {
        return this.tile;
    }

    public void setTile(Tile tile) {
        this.tile = tile;
    }

    public boolean getFlipHorizontal() {
        return this.flipHorizontal;
    }

    public void setFlipHorizontal(boolean flip) {
        this.flipHorizontal = flip;
    }

    public boolean getFlipVertical() {
        return this.flipVertical;
    }

    public void setFlipVertical(boolean flip) {
        this.flipVertical = flip;
    }

    public boolean getFlipDiagonal() {
        return this.flipDiagonal;
    }

    public void setFlipDiagonal(boolean flip) {
        this.flipDiagonal = flip;
    }

    public Image getImage(double zoom) {
        if (this.image == null) {
            return null;
        }
        int zoomedWidth = (int)(this.getWidth() * zoom);
        int zoomedHeight = (int)(this.getHeight() * zoom);
        if (this.scaledImage == null || this.scaledImage.getWidth(null) != zoomedWidth || this.scaledImage.getHeight(null) != zoomedHeight) {
            this.scaledImage = this.image.getScaledInstance(zoomedWidth, zoomedHeight, 4);
        }
        return this.scaledImage;
    }

    public void translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public String toString() {
        return this.type + " (" + this.getX() + "," + this.getY() + ")";
    }
}

