/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.core;

import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.mapeditor.core.Map;
import org.mapeditor.core.MapObject;
import org.mapeditor.core.ObjectGroupData;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ObjectGroup
extends ObjectGroupData
implements Cloneable,
Iterable<MapObject> {
    public ObjectGroup() {
    }

    public ObjectGroup(Map map) {
        this();
        this.map = map;
    }

    public ObjectGroup(Map map, int x, int y) {
        this(map);
        this.x = x;
        this.y = y;
    }

    public ObjectGroup(Rectangle area) {
        this.x = (int)area.getX();
        this.y = (int)area.getY();
        this.width = (int)area.getWidth();
        this.height = (int)area.getHeight();
    }

    public boolean isEmpty() {
        return this.getObjects().isEmpty();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ObjectGroup clone = (ObjectGroup)super.clone();
        clone.objects = new LinkedList();
        for (MapObject object : this.getObjects()) {
            MapObject objectClone = (MapObject)object.clone();
            clone.objects.add(objectClone);
            objectClone.setObjectGroup(clone);
        }
        return clone;
    }

    public void addObject(MapObject o) {
        this.getObjects().add(o);
        o.setObjectGroup(this);
    }

    public void removeObject(MapObject o) {
        this.getObjects().remove(o);
        o.setObjectGroup(null);
    }

    @Override
    public Iterator<MapObject> iterator() {
        return this.getObjects().iterator();
    }

    public MapObject getObjectAt(double x, double y) {
        for (MapObject obj : this.getObjects()) {
            if (obj.getWidth() == 0.0 && obj.getX() + (double)this.x.intValue() == x) {
                return obj;
            }
            if (obj.getHeight() == 0.0 && obj.getY() + (double)this.y.intValue() == y) {
                return obj;
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(obj.getX() + (double)(this.x * this.map.getTileWidth()), obj.getY() + (double)(this.y * this.map.getTileHeight()), obj.getWidth(), obj.getHeight());
            if (!rect.contains(x, y)) continue;
            return obj;
        }
        return null;
    }

    public MapObject getObjectNear(int x, int y, double zoom) {
        Rectangle2D.Double mouse = new Rectangle2D.Double((double)x - zoom - 1.0, (double)y - zoom - 1.0, 2.0 * zoom + 1.0, 2.0 * zoom + 1.0);
        for (MapObject obj : this.getObjects()) {
            RectangularShape shape = obj.getWidth() == 0.0 && obj.getHeight() == 0.0 ? new Ellipse2D.Double(obj.getX() * zoom, obj.getY() * zoom, 10.0 * zoom, 10.0 * zoom) : new Rectangle2D.Double(obj.getX() + (double)(this.x * this.map.getTileWidth()), obj.getY() + (double)(this.y * this.map.getTileHeight()), obj.getWidth() > 0.0 ? obj.getWidth() : zoom, obj.getHeight() > 0.0 ? obj.getHeight() : zoom);
            if (!shape.intersects(mouse)) continue;
            return obj;
        }
        return null;
    }
}

