/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.core;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.mapeditor.core.Map;
import org.mapeditor.core.Properties;
import org.mapeditor.core.Tile;
import org.mapeditor.core.TileLayerData;

@XmlAccessorType(value=XmlAccessType.NONE)
public class TileLayer
extends TileLayerData {
    private Tile[][] tileMap;
    private int[][] flags;
    private HashMap<Object, Properties> tileInstanceProperties = new HashMap();

    public Properties getTileInstancePropertiesAt(int x, int y) {
        if (!this.getBounds().contains(x, y)) {
            return null;
        }
        Point key = new Point(x, y);
        return this.tileInstanceProperties.get(key);
    }

    public void setTileInstancePropertiesAt(int x, int y, Properties tip) {
        if (this.getBounds().contains(x, y)) {
            Point key = new Point(x, y);
            this.tileInstanceProperties.put(key, tip);
        }
    }

    public TileLayer() {
        this.setMap(null);
    }

    public TileLayer(int w, int h) {
        this(new Rectangle(0, 0, w, h));
    }

    public TileLayer(Rectangle r) {
        this();
        this.setBounds(r);
    }

    public TileLayer(Map map) {
        this();
        this.setMap(map);
    }

    public TileLayer(Map map, int w, int h) {
        this(w, h);
        this.setMap(map);
    }

    public void rotate(int angle) {
        int[][] transFlags;
        Tile[][] trans;
        int xtrans = 0;
        int ytrans = 0;
        switch (angle) {
            case 90: {
                trans = new Tile[this.width][this.height];
                transFlags = new int[this.width][this.height];
                xtrans = this.height - 1;
                break;
            }
            case 180: {
                trans = new Tile[this.height][this.width];
                transFlags = new int[this.height][this.width];
                xtrans = this.width - 1;
                ytrans = this.height - 1;
                break;
            }
            case 270: {
                trans = new Tile[this.width][this.height];
                transFlags = new int[this.width][this.height];
                ytrans = this.width - 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rotation (" + angle + ")");
            }
        }
        double ra = Math.toRadians(angle);
        int cosAngle = (int)Math.round(Math.cos(ra));
        int sinAngle = (int)Math.round(Math.sin(ra));
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int xrot = x * cosAngle - y * sinAngle;
                int yrot = x * sinAngle + y * cosAngle;
                trans[yrot + ytrans][xrot + xtrans] = this.getTileAt(x + this.x, y + this.y);
                transFlags[yrot + ytrans][xrot + xtrans] = this.getFlagsAt(x + this.x, y + this.y);
            }
        }
        this.width = trans[0].length;
        this.height = trans.length;
        this.tileMap = trans;
        this.flags = transFlags;
    }

    public void mirror(int dir) {
        Tile[][] mirror = new Tile[this.height][this.width];
        int[][] mirrorFlags = new int[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (dir == 2) {
                    mirror[y][x] = this.tileMap[this.height - 1 - y][x];
                    mirrorFlags[y][x] = this.flags[this.height - 1 - y][x];
                    continue;
                }
                mirror[y][x] = this.tileMap[y][this.width - 1 - x];
                mirrorFlags[y][x] = this.flags[y][this.width - 1 - x];
            }
        }
        this.tileMap = mirror;
        this.flags = mirrorFlags;
    }

    public boolean isUsed(Tile t) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.tileMap[y][x] != t) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        for (int p = 0; p < 2; ++p) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = p; x < this.width; x += 2) {
                    if (this.tileMap[y][x] == null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.tileMap = new Tile[this.height][this.width];
        this.flags = new int[this.height][this.width];
        if (this.tileInstanceProperties != null) {
            this.tileInstanceProperties.clear();
        }
    }

    public TileLayer createDiff(TileLayer ml) {
        if (ml == null) {
            return null;
        }
        Rectangle r = null;
        for (int y = this.y.intValue(); y < this.height + this.y; ++y) {
            for (int x = this.x.intValue(); x < this.width + this.x; ++x) {
                if (ml.getTileAt(x, y) == this.getTileAt(x, y)) continue;
                if (r != null) {
                    r.add(x, y);
                    continue;
                }
                r = new Rectangle(new Point(x, y));
            }
        }
        if (r != null) {
            TileLayer diff = new TileLayer(new Rectangle(r.x, r.y, r.width + 1, r.height + 1));
            diff.copyFrom(ml);
            return diff;
        }
        return new TileLayer();
    }

    public void removeTile(Tile tile) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.tileMap[y][x] != tile) continue;
                this.setTileAt(x + this.x, y + this.y, null);
            }
        }
    }

    public void setTileAt(int tx, int ty, Tile ti) {
        if (this.getBounds().contains(tx, ty)) {
            this.tileMap[ty - this.y.intValue()][tx - this.x.intValue()] = ti;
        }
    }

    public Tile getTileAt(int tx, int ty) {
        return this.getBounds().contains(tx, ty) ? this.tileMap[ty - this.y][tx - this.x] : null;
    }

    public void setFlagsAt(int tx, int ty, int flags) {
        if (this.getBounds().contains(tx, ty)) {
            this.flags[ty - this.y.intValue()][tx - this.x.intValue()] = flags;
        }
    }

    public int getFlagsAt(int tx, int ty) {
        return this.getBounds().contains(tx, ty) ? this.flags[ty - this.y][tx - this.x] : 0;
    }

    public Point locationOf(Tile t) {
        for (int y = this.y.intValue(); y < this.height + this.y; ++y) {
            for (int x = this.x.intValue(); x < this.width + this.x; ++x) {
                if (this.getTileAt(x, y) != t) continue;
                return new Point(x, y);
            }
        }
        return null;
    }

    public void replaceTile(Tile find, Tile replace) {
        for (int y = this.y.intValue(); y < this.y + this.height; ++y) {
            for (int x = this.x.intValue(); x < this.x + this.width; ++x) {
                if (this.getTileAt(x, y) != find) continue;
                this.setTileAt(x, y, replace);
            }
        }
    }

    public void mergeOnto(TileLayer other) {
        for (int y = this.y.intValue(); y < this.y + this.height; ++y) {
            for (int x = this.x.intValue(); x < this.x + this.width; ++x) {
                Tile tile = this.getTileAt(x, y);
                if (tile == null) continue;
                other.setTileAt(x, y, tile);
                other.setFlagsAt(x, y, this.getFlagsAt(x, y));
            }
        }
    }

    public void maskedMergeOnto(TileLayer other, Area mask) {
        Rectangle boundBox = mask.getBounds();
        for (int y = boundBox.y; y < boundBox.y + boundBox.height; ++y) {
            for (int x = boundBox.x; x < boundBox.x + boundBox.width; ++x) {
                Tile tile = other.getTileAt(x, y);
                if (!mask.contains(x, y) || tile == null) continue;
                this.setTileAt(x, y, tile);
                this.setFlagsAt(x, y, other.getFlagsAt(x, y));
            }
        }
    }

    public void copyFrom(TileLayer other) {
        for (int y = this.y.intValue(); y < this.y + this.height; ++y) {
            for (int x = this.x.intValue(); x < this.x + this.width; ++x) {
                this.setTileAt(x, y, other.getTileAt(x, y));
                this.setFlagsAt(x, y, other.getFlagsAt(x, y));
            }
        }
    }

    public void maskedCopyFrom(TileLayer other, Area mask) {
        Rectangle boundBox = mask.getBounds();
        for (int y = boundBox.y; y < boundBox.y + boundBox.height; ++y) {
            for (int x = boundBox.x; x < boundBox.x + boundBox.width; ++x) {
                if (!mask.contains(x, y)) continue;
                this.setTileAt(x, y, other.getTileAt(x, y));
                this.setFlagsAt(x, y, other.getFlagsAt(x, y));
            }
        }
    }

    public void copyTo(TileLayer other) {
        for (int y = this.y.intValue(); y < this.y + this.height; ++y) {
            for (int x = this.x.intValue(); x < this.x + this.width; ++x) {
                other.setTileAt(x, y, this.getTileAt(x, y));
                other.setFlagsAt(x, y, this.getFlagsAt(x, y));
            }
        }
    }

    @Override
    public void resize(int width, int height, int dx, int dy) {
        Tile[][] newMap = new Tile[height][width];
        int[][] newFlags = new int[height][width];
        HashMap<Point, Properties> newTileInstanceProperties = new HashMap<Point, Properties>();
        int maxX = Math.min(width, this.width + dx);
        int maxY = Math.min(height, this.height + dy);
        for (int x = Math.max(0, dx); x < maxX; ++x) {
            for (int y = Math.max(0, dy); y < maxY; ++y) {
                newMap[y][x] = this.getTileAt(x - dx, y - dy);
                newFlags[y][x] = this.getFlagsAt(x - dx, y - dy);
                Properties tip = this.getTileInstancePropertiesAt(x - dx, y - dy);
                if (tip == null) continue;
                newTileInstanceProperties.put(new Point(x, y), tip);
            }
        }
        this.tileMap = newMap;
        this.flags = newFlags;
        this.tileInstanceProperties = newTileInstanceProperties;
        this.width = width;
        this.height = height;
    }

    public boolean isFlippedHorizontally(int x, int y) {
        return this.getBounds().contains(x, y) && (this.flags[y][x] & Integer.MIN_VALUE) != 0;
    }

    public boolean isFlippedVertically(int x, int y) {
        return this.getBounds().contains(x, y) && (this.flags[y][x] & 0x40000000) != 0;
    }

    public boolean isFlippedDiagonally(int x, int y) {
        return this.getBounds().contains(x, y) && (this.flags[y][x] & 0x20000000) != 0;
    }
}

