/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.io;

import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mapeditor.core.AnimatedTile;
import org.mapeditor.core.Group;
import org.mapeditor.core.ImageLayer;
import org.mapeditor.core.Map;
import org.mapeditor.core.MapLayer;
import org.mapeditor.core.MapObject;
import org.mapeditor.core.ObjectGroup;
import org.mapeditor.core.Point;
import org.mapeditor.core.Properties;
import org.mapeditor.core.Tile;
import org.mapeditor.core.TileLayer;
import org.mapeditor.core.TileOffset;
import org.mapeditor.core.TileSet;
import org.mapeditor.util.BasicTileCutter;
import org.mapeditor.util.ImageHelper;
import org.mapeditor.util.TileCutter;
import org.mapeditor.util.URLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TMXMapReader {
    public static final long FLIPPED_HORIZONTALLY_FLAG = 0x80000000L;
    public static final long FLIPPED_VERTICALLY_FLAG = 0x40000000L;
    public static final long FLIPPED_DIAGONALLY_FLAG = 0x20000000L;
    public static final long ALL_FLAGS = 0xE0000000L;
    public final TMXMapReaderSettings settings = new TMXMapReaderSettings();
    private Map map;
    private URL xmlPath;
    private String error;
    private final EntityResolver entityResolver = new MapEntityResolver();
    private TreeMap<Integer, TileSet> tilesetPerFirstGid;
    private java.util.Map<String, TileSet> cachedTilesets;
    private final Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Map.class, TileSet.class, Tile.class, AnimatedTile.class, ObjectGroup.class, ImageLayer.class}).createUnmarshaller();

    String getError() {
        return this.error;
    }

    private static URL makeUrl(String filename) throws MalformedURLException {
        if (filename.indexOf("://") > 0 || filename.startsWith("file:")) {
            return new URL(filename);
        }
        return new File(filename).toURI().toURL();
    }

    private static String getAttributeValue(Node node, String attribname) {
        Node attribute;
        NamedNodeMap attributes = node.getAttributes();
        String value = null;
        if (attributes != null && (attribute = attributes.getNamedItem(attribname)) != null) {
            value = attribute.getNodeValue();
        }
        return value;
    }

    private static int getAttribute(Node node, String attribname, int def) {
        String attr = TMXMapReader.getAttributeValue(node, attribname);
        if (attr != null) {
            return Integer.parseInt(attr);
        }
        return def;
    }

    private static float getFloatAttribute(Node node, String attribname, float def) {
        String attr = TMXMapReader.getAttributeValue(node, attribname);
        if (attr != null) {
            return Float.parseFloat(attr);
        }
        return def;
    }

    private static double getDoubleAttribute(Node node, String attribname, double def) {
        String attr = TMXMapReader.getAttributeValue(node, attribname);
        if (attr != null) {
            return Double.parseDouble(attr);
        }
        return def;
    }

    private <T> T unmarshalClass(Node node, Class<T> type) throws JAXBException {
        return (T)this.unmarshaller.unmarshal(node, type).getValue();
    }

    private BufferedImage unmarshalImage(Node t, URL baseDir) throws IOException {
        BufferedImage img = null;
        String source = TMXMapReader.getAttributeValue(t, "source");
        if (source != null) {
            URL url;
            if (TMXMapReader.checkRoot(source)) {
                url = TMXMapReader.makeUrl(source);
            } else {
                try {
                    url = URLHelper.resolve(baseDir, source);
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
            img = ImageIO.read(url);
        } else {
            NodeList nl = t.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!"data".equals(node.getNodeName())) continue;
                Node cdata = node.getFirstChild();
                if (cdata == null) break;
                String sdata = cdata.getNodeValue();
                String enc = sdata.trim();
                byte[] dec = DatatypeConverter.parseBase64Binary((String)enc);
                img = ImageHelper.bytesToImage(dec);
                break;
            }
        }
        return img;
    }

    private TileSet unmarshalTilesetFile(InputStream in, URL file) throws Exception {
        TileSet set = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            NodeList tsNodeList;
            Node tsNode;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document tsDoc = builder.parse(in, ".");
            URL xmlPathSave = this.xmlPath;
            if (file.getPath().contains("/")) {
                this.xmlPath = URLHelper.getParent(file);
            }
            if ((tsNode = (tsNodeList = tsDoc.getElementsByTagName("tileset")).item(0)) != null) {
                set = this.unmarshalTileset(tsNode, true);
                set.setSource(file.toString());
            }
            this.xmlPath = xmlPathSave;
        }
        catch (SAXException e) {
            this.error = "Failed while loading " + file + ": " + e.getLocalizedMessage();
        }
        return set;
    }

    private TileSet unmarshalTileset(Node t) throws Exception {
        return this.unmarshalTileset(t, false);
    }

    private TileSet unmarshalTileset(Node t, boolean isExternalTileset) throws Exception {
        TileSet set = this.unmarshalClass(t, TileSet.class);
        String source = set.getSource();
        if (source != null && isExternalTileset) {
            source = null;
            set.setSource(null);
            System.out.printf("Warning: recursive external tilesets are not supported - ignoring source option for tileset %s%n", set.getName());
        }
        if (source != null) {
            URL url = URLHelper.resolve(this.xmlPath, source = this.replacePathSeparator(source));
            InputStream in = url.openStream();
            TileSet ext = this.unmarshalTilesetFile(in, url);
            if (ext == null) {
                this.error = "Tileset " + source + " was not loaded correctly!";
                return set;
            }
            return ext;
        }
        int tileWidth = TMXMapReader.getAttribute(t, "tilewidth", this.map != null ? this.map.getTileWidth() : 0);
        int tileHeight = TMXMapReader.getAttribute(t, "tileheight", this.map != null ? this.map.getTileHeight() : 0);
        int tileSpacing = TMXMapReader.getAttribute(t, "spacing", 0);
        int tileMargin = TMXMapReader.getAttribute(t, "margin", 0);
        String name = TMXMapReader.getAttributeValue(t, "name");
        if (this.settings.reuseCachedTilesets) {
            if (this.cachedTilesets == null) {
                this.cachedTilesets = new HashMap<String, TileSet>();
            }
            if ((set = this.cachedTilesets.get(name)) != null) {
                return set;
            }
            set = new TileSet();
            this.cachedTilesets.put(name, set);
        } else {
            set = new TileSet();
        }
        set.setName(name);
        boolean hasTilesetImage = false;
        NodeList children = t.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equalsIgnoreCase("image")) {
                URL sourcePath;
                if (hasTilesetImage) {
                    System.out.println("Ignoring illegal image element after tileset image.");
                    continue;
                }
                String imgSource = TMXMapReader.getAttributeValue(child, "source");
                String transStr = TMXMapReader.getAttributeValue(child, "trans");
                if (imgSource == null) continue;
                hasTilesetImage = true;
                if (!new File(imgSource).isAbsolute()) {
                    imgSource = this.replacePathSeparator(imgSource);
                    sourcePath = URLHelper.resolve(this.xmlPath, imgSource);
                } else {
                    sourcePath = TMXMapReader.makeUrl(imgSource);
                }
                if (transStr != null) {
                    if (transStr.startsWith("#")) {
                        transStr = transStr.substring(1);
                    }
                    int colorInt = Integer.parseInt(transStr, 16);
                    Color color = new Color(colorInt);
                    set.setTransparentColor(color);
                }
                set.importTileBitmap(sourcePath, (TileCutter)new BasicTileCutter(tileWidth, tileHeight, tileSpacing, tileMargin));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("tile")) {
                Tile tile = this.unmarshalTile(set, child, this.xmlPath);
                if (!hasTilesetImage || tile.getId() > set.getMaxTileId()) {
                    set.addTile(tile);
                    continue;
                }
                Tile myTile = set.getTile(tile.getId());
                myTile.setProperties(tile.getProperties());
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("tileoffset")) continue;
            TileOffset tileoffset = new TileOffset();
            tileoffset.setX(Integer.valueOf(TMXMapReader.getAttributeValue(child, "x")));
            tileoffset.setY(Integer.valueOf(TMXMapReader.getAttributeValue(child, "y")));
            set.setTileoffset(tileoffset);
        }
        return set;
    }

    private MapObject readMapObject(Node t) throws Exception {
        int id = TMXMapReader.getAttribute(t, "id", 0);
        String name = TMXMapReader.getAttributeValue(t, "name");
        String type = TMXMapReader.getAttributeValue(t, "type");
        String gid = TMXMapReader.getAttributeValue(t, "gid");
        double x = TMXMapReader.getDoubleAttribute(t, "x", 0.0);
        double y = TMXMapReader.getDoubleAttribute(t, "y", 0.0);
        double width = TMXMapReader.getDoubleAttribute(t, "width", 0.0);
        double height = TMXMapReader.getDoubleAttribute(t, "height", 0.0);
        double rotation = TMXMapReader.getDoubleAttribute(t, "rotation", 0.0);
        MapObject obj = new MapObject(x, y, width, height, rotation);
        obj.setShape(obj.getBounds());
        if (id != 0) {
            obj.setId(id);
        }
        if (name != null) {
            obj.setName(name);
        }
        if (type != null) {
            obj.setType(type);
        }
        if (gid != null) {
            long tileId = Long.parseLong(gid);
            if ((tileId & 0xE0000000L) != 0L) {
                long flippedHorizontally = tileId & 0x80000000L;
                long flippedVertically = tileId & 0x40000000L;
                long flippedDiagonally = tileId & 0x20000000L;
                obj.setFlipHorizontal(flippedHorizontally != 0L);
                obj.setFlipVertical(flippedVertically != 0L);
                obj.setFlipDiagonal(flippedDiagonally != 0L);
                tileId &= 0xFFFFFFFF1FFFFFFFL;
            }
            Tile tile = this.getTileForTileGID((int)tileId);
            obj.setTile(tile);
        }
        NodeList children = t.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("image".equalsIgnoreCase(child.getNodeName())) {
                String source = TMXMapReader.getAttributeValue(child, "source");
                if (source == null) break;
                if (!new File(source).isAbsolute()) {
                    source = URLHelper.resolve(this.xmlPath, source).toString();
                }
                obj.setImageSource(source);
                break;
            }
            if ("ellipse".equalsIgnoreCase(child.getNodeName())) {
                obj.setShape(new Ellipse2D.Double(x, y, width, height));
                continue;
            }
            if ("polygon".equalsIgnoreCase(child.getNodeName()) || "polyline".equalsIgnoreCase(child.getNodeName())) {
                Path2D.Double shape = new Path2D.Double();
                String pointsAttribute = TMXMapReader.getAttributeValue(child, "points");
                StringTokenizer st = new StringTokenizer(pointsAttribute, ", ");
                boolean firstPoint = true;
                while (st.hasMoreElements()) {
                    double pointX = Double.parseDouble(st.nextToken());
                    double pointY = Double.parseDouble(st.nextToken());
                    if (firstPoint) {
                        shape.moveTo(x + pointX, y + pointY);
                        firstPoint = false;
                        continue;
                    }
                    shape.lineTo(x + pointX, y + pointY);
                }
                shape.closePath();
                obj.setShape(shape);
                obj.setBounds((Rectangle2D.Double)shape.getBounds2D());
                continue;
            }
            if (!"point".equalsIgnoreCase(child.getNodeName())) continue;
            obj.setPoint(new Point());
        }
        Properties props = new Properties();
        TMXMapReader.readProperties(children, props);
        obj.setProperties(props);
        return obj;
    }

    private static void readProperties(NodeList children, Properties props) {
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("property".equalsIgnoreCase(child.getNodeName())) {
                Node grandChild;
                String key = TMXMapReader.getAttributeValue(child, "name");
                String value = TMXMapReader.getAttributeValue(child, "value");
                if (value == null && (grandChild = child.getFirstChild()) != null && (value = grandChild.getNodeValue()) != null) {
                    value = value.trim();
                }
                if (value == null) continue;
                props.setProperty(key, value);
                continue;
            }
            if (!"properties".equals(child.getNodeName())) continue;
            TMXMapReader.readProperties(child.getChildNodes(), props);
        }
    }

    private Tile unmarshalTile(TileSet set, Node t, URL baseDir) throws Exception {
        Node child;
        int i;
        Tile tile = null;
        NodeList children = t.getChildNodes();
        boolean isAnimated = false;
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!"animation".equalsIgnoreCase(child.getNodeName())) continue;
            isAnimated = true;
            break;
        }
        try {
            tile = isAnimated ? (Tile)this.unmarshalClass(t, AnimatedTile.class) : this.unmarshalClass(t, Tile.class);
        }
        catch (JAXBException e) {
            this.error = "Failed creating tile: " + e.getLocalizedMessage();
            return tile;
        }
        tile.setTileSet(set);
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if ("image".equalsIgnoreCase(child.getNodeName())) {
                BufferedImage img = this.unmarshalImage(child, baseDir);
                tile.setImage(img);
                continue;
            }
            if (!"animation".equalsIgnoreCase(child.getNodeName())) continue;
        }
        return tile;
    }

    private Group unmarshalGroup(Node t) throws Exception {
        int locked;
        Group g = null;
        try {
            g = this.unmarshalClass(t, Group.class);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return g;
        }
        int offsetX = TMXMapReader.getAttribute(t, "x", 0);
        int offsetY = TMXMapReader.getAttribute(t, "y", 0);
        g.setOffset(offsetX, offsetY);
        String opacity = TMXMapReader.getAttributeValue(t, "opacity");
        if (opacity != null) {
            g.setOpacity(Float.valueOf(Float.parseFloat(opacity)));
        }
        if ((locked = TMXMapReader.getAttribute(t, "locked", 0)) != 0) {
            g.setLocked(1);
        }
        g.getLayers().clear();
        for (Node sibs = t.getFirstChild(); sibs != null; sibs = sibs.getNextSibling()) {
            ImageLayer imageLayer;
            MapLayer group;
            if ("group".equals(sibs.getNodeName())) {
                group = this.unmarshalGroup(sibs);
                if (group == null) continue;
                g.getLayers().add(group);
                continue;
            }
            if ("layer".equals(sibs.getNodeName())) {
                TileLayer layer = this.readLayer(sibs);
                if (layer == null) continue;
                g.getLayers().add(layer);
                continue;
            }
            if ("objectgroup".equals(sibs.getNodeName())) {
                group = this.unmarshalObjectGroup(sibs);
                if (group == null) continue;
                g.getLayers().add(group);
                continue;
            }
            if (!"imagelayer".equals(sibs.getNodeName()) || (imageLayer = this.unmarshalImageLayer(sibs)) == null) continue;
            g.getLayers().add(imageLayer);
        }
        return g;
    }

    private ObjectGroup unmarshalObjectGroup(Node t) throws Exception {
        ObjectGroup og = null;
        try {
            og = this.unmarshalClass(t, ObjectGroup.class);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return og;
        }
        int offsetX = TMXMapReader.getAttribute(t, "x", 0);
        int offsetY = TMXMapReader.getAttribute(t, "y", 0);
        og.setOffset(offsetX, offsetY);
        int locked = TMXMapReader.getAttribute(t, "locked", 0);
        if (locked != 0) {
            og.setLocked(1);
        }
        og.getObjects().clear();
        NodeList children = t.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"object".equalsIgnoreCase(child.getNodeName())) continue;
            og.addObject(this.readMapObject(child));
        }
        return og;
    }

    private ImageLayer unmarshalImageLayer(Node t) throws Exception {
        ImageLayer il = null;
        try {
            il = this.unmarshalClass(t, ImageLayer.class);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return il;
        }
        return il;
    }

    private TileLayer readLayer(Node t) throws Exception {
        int layerId = TMXMapReader.getAttribute(t, "id", 0);
        int layerWidth = TMXMapReader.getAttribute(t, "width", this.map.getWidth());
        int layerHeight = TMXMapReader.getAttribute(t, "height", this.map.getHeight());
        TileLayer ml = new TileLayer(layerWidth, layerHeight);
        ml.setId(layerId);
        int offsetX = TMXMapReader.getAttribute(t, "x", 0);
        int offsetY = TMXMapReader.getAttribute(t, "y", 0);
        int visible = TMXMapReader.getAttribute(t, "visible", 1);
        String opacity = TMXMapReader.getAttributeValue(t, "opacity");
        ml.setName(TMXMapReader.getAttributeValue(t, "name"));
        if (opacity != null) {
            ml.setOpacity(Float.valueOf(Float.parseFloat(opacity)));
        }
        TMXMapReader.readProperties(t.getChildNodes(), ml.getProperties());
        block0: for (Node child = t.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName = child.getNodeName();
            if ("data".equalsIgnoreCase(nodeName)) {
                String encoding = TMXMapReader.getAttributeValue(child, "encoding");
                String comp = TMXMapReader.getAttributeValue(child, "compression");
                if ("base64".equalsIgnoreCase(encoding)) {
                    InputStream is;
                    Node cdata = child.getFirstChild();
                    if (cdata == null) continue;
                    String enc = cdata.getNodeValue().trim();
                    byte[] dec = DatatypeConverter.parseBase64Binary((String)enc);
                    ByteArrayInputStream bais = new ByteArrayInputStream(dec);
                    if ("gzip".equalsIgnoreCase(comp)) {
                        int len = layerWidth * layerHeight * 4;
                        is = new GZIPInputStream((InputStream)bais, len);
                    } else if ("zlib".equalsIgnoreCase(comp)) {
                        is = new InflaterInputStream(bais);
                    } else {
                        if (comp != null && !comp.isEmpty()) {
                            throw new IOException("Unrecognized compression method \"" + comp + "\" for map layer " + ml.getName());
                        }
                        is = bais;
                    }
                    for (int y = 0; y < ml.getHeight(); ++y) {
                        for (int x = 0; x < ml.getWidth(); ++x) {
                            int tileId = 0;
                            tileId |= is.read();
                            tileId |= is.read() << 8;
                            tileId |= is.read() << 16;
                            this.setTileAtFromTileId(ml, y, x, tileId |= is.read() << 24);
                        }
                    }
                    continue;
                }
                if ("csv".equalsIgnoreCase(encoding)) {
                    String csvText = child.getTextContent();
                    if (comp != null && !comp.isEmpty()) {
                        throw new IOException("Unrecognized compression method \"" + comp + "\" for map layer " + ml.getName() + " and encoding " + encoding);
                    }
                    String[] csvTileIds = csvText.trim().split("[\\s]*,[\\s]*");
                    if (csvTileIds.length != ml.getHeight() * ml.getWidth()) {
                        throw new IOException("Number of tiles does not match the layer's width and height");
                    }
                    for (int y = 0; y < ml.getHeight(); ++y) {
                        for (int x = 0; x < ml.getWidth(); ++x) {
                            String gid = csvTileIds[x + y * ml.getWidth()];
                            long tileId = Long.parseLong(gid);
                            this.setTileAtFromTileId(ml, y, x, (int)tileId);
                        }
                    }
                    continue;
                }
                int x = 0;
                int y = 0;
                for (Node dataChild = child.getFirstChild(); dataChild != null; dataChild = dataChild.getNextSibling()) {
                    if (!"tile".equalsIgnoreCase(dataChild.getNodeName())) continue;
                    int tileId = TMXMapReader.getAttribute(dataChild, "gid", -1);
                    this.setTileAtFromTileId(ml, y, x, tileId);
                    if (++x == ml.getWidth()) {
                        x = 0;
                        ++y;
                    }
                    if (y == ml.getHeight()) continue block0;
                }
                continue;
            }
            if (!"tileproperties".equalsIgnoreCase(nodeName)) continue;
            for (Node tpn = child.getFirstChild(); tpn != null; tpn = tpn.getNextSibling()) {
                if (!"tile".equalsIgnoreCase(tpn.getNodeName())) continue;
                int x = TMXMapReader.getAttribute(tpn, "x", -1);
                int y = TMXMapReader.getAttribute(tpn, "y", -1);
                Properties tip = new Properties();
                TMXMapReader.readProperties(tpn.getChildNodes(), tip);
                ml.setTileInstancePropertiesAt(x, y, tip);
            }
        }
        ml.setOffset(offsetX, offsetY);
        ml.setVisible(visible == 1);
        int locked = TMXMapReader.getAttribute(t, "locked", 0);
        if (locked != 0) {
            ml.setLocked(1);
        }
        return ml;
    }

    private void setTileAtFromTileId(TileLayer ml, int y, int x, int tileGid) {
        Tile tile = this.getTileForTileGID(tileGid & 0x1FFFFFFF);
        long flags = (long)tileGid & 0xE0000000L;
        ml.setTileAt(x, y, tile);
        ml.setFlagsAt(x, y, (int)flags);
    }

    private Tile getTileForTileGID(int tileId) {
        Tile tile = null;
        Map.Entry<Integer, TileSet> ts = this.findTileSetForTileGID(tileId);
        if (ts != null) {
            tile = ts.getValue().getTile(tileId - ts.getKey());
        }
        return tile;
    }

    private void buildMap(Document doc) throws Exception {
        Node item;
        Element mapNode = doc.getDocumentElement();
        if (!"map".equals(mapNode.getNodeName())) {
            throw new Exception("Not a valid tmx map file.");
        }
        this.map = this.unmarshalClass(mapNode, Map.class);
        if (this.map == null) {
            throw new Exception("Couldn't load map.");
        }
        this.map.getTileSets().clear();
        this.map.getLayers().clear();
        this.tilesetPerFirstGid = new TreeMap();
        NodeList l = doc.getElementsByTagName("tileset");
        int i = 0;
        while ((item = l.item(i)) != null) {
            int firstGid = TMXMapReader.getAttribute(item, "firstgid", 1);
            TileSet tileset = this.unmarshalTileset(item);
            this.tilesetPerFirstGid.put(firstGid, tileset);
            this.map.addTileset(tileset);
            ++i;
        }
        for (Node sibs = mapNode.getFirstChild(); sibs != null; sibs = sibs.getNextSibling()) {
            ImageLayer imageLayer;
            MapLayer group;
            if ("group".equals(sibs.getNodeName()) && (group = this.unmarshalGroup(sibs)) != null) {
                this.map.addLayer(group);
            }
            if ("layer".equals(sibs.getNodeName())) {
                TileLayer layer = this.readLayer(sibs);
                if (layer == null) continue;
                this.map.addLayer(layer);
                continue;
            }
            if ("objectgroup".equals(sibs.getNodeName())) {
                group = this.unmarshalObjectGroup(sibs);
                if (group == null) continue;
                this.map.addLayer(group);
                continue;
            }
            if (!"imagelayer".equals(sibs.getNodeName()) || (imageLayer = this.unmarshalImageLayer(sibs)) == null) continue;
            this.map.addLayer(imageLayer);
        }
        this.tilesetPerFirstGid = null;
    }

    private Map unmarshal(InputStream in) throws Exception {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this.entityResolver);
            InputSource insrc = new InputSource(in);
            insrc.setSystemId(this.xmlPath.toString());
            insrc.setEncoding("UTF-8");
            doc = builder.parse(insrc);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new Exception("Error while parsing map file: " + e.toString());
        }
        this.buildMap(doc);
        return this.map;
    }

    public Map readMap(URL url) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException("Cannot read map from null URL");
        }
        this.xmlPath = URLHelper.getParent(url);
        InputStream is = url.openStream();
        if (url.toString().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        Map unmarshalledMap = this.unmarshal(is);
        unmarshalledMap.setFilename(url.toString());
        this.map = null;
        return unmarshalledMap;
    }

    public Map readMap(String filename) throws Exception {
        filename = this.replacePathSeparator(filename);
        return this.readMap(TMXMapReader.makeUrl(filename));
    }

    public Map readMap(InputStream in) throws Exception {
        return this.readMap(in, System.getProperty("user.dir"));
    }

    public Map readMap(InputStream in, String searchDirectory) throws Exception {
        this.xmlPath = TMXMapReader.makeUrl(searchDirectory + File.separatorChar);
        return this.unmarshal(in);
    }

    public TileSet readTileset(String filename) throws Exception {
        filename = this.replacePathSeparator(filename);
        URL url = TMXMapReader.makeUrl(filename);
        this.xmlPath = URLHelper.getParent(url);
        return this.unmarshalTilesetFile(url.openStream(), url);
    }

    public TileSet readTileset(InputStream in) throws Exception {
        return this.unmarshalTilesetFile(in, new File(".").toURI().toURL());
    }

    public boolean accept(File pathName) {
        try {
            String path = pathName.getCanonicalPath();
            if (path.endsWith(".tmx") || path.endsWith(".tsx") || path.endsWith(".tmx.gz")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkRoot(String filename) {
        File[] roots;
        for (File root : roots = File.listRoots()) {
            try {
                String canonicalRoot = root.getCanonicalPath().toLowerCase();
                if (!filename.toLowerCase().startsWith(canonicalRoot)) continue;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private Map.Entry<Integer, TileSet> findTileSetForTileGID(int gid) {
        return this.tilesetPerFirstGid.floorEntry(gid);
    }

    private String replacePathSeparator(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null.");
        }
        if (path.isEmpty() || path.lastIndexOf(File.separatorChar) >= 0) {
            return path;
        }
        return path.replace("/", File.separator);
    }

    public void setCachedTilesets(java.util.Map<String, TileSet> cachedTilesets) {
        this.cachedTilesets = cachedTilesets;
    }

    private class MapEntityResolver
    implements EntityResolver {
        private MapEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId.equals("http://mapeditor.org/dtd/1.0/map.dtd")) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("map.dtd"));
            }
            return null;
        }
    }

    public static final class TMXMapReaderSettings {
        public boolean reuseCachedTilesets = false;
    }
}

