/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.io;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.mapeditor.core.AnimatedTile;
import org.mapeditor.core.Group;
import org.mapeditor.core.Map;
import org.mapeditor.core.MapLayer;
import org.mapeditor.core.MapObject;
import org.mapeditor.core.ObjectGroup;
import org.mapeditor.core.Orientation;
import org.mapeditor.core.Properties;
import org.mapeditor.core.Sprite;
import org.mapeditor.core.Tile;
import org.mapeditor.core.TileLayer;
import org.mapeditor.core.TileSet;
import org.mapeditor.io.xml.XMLWriter;

public class TMXMapWriter {
    private static final int LAST_BYTE = 255;
    private static final boolean ENCODE_LAYER_DATA = true;
    private static final boolean COMPRESS_LAYER_DATA = true;
    private HashMap<TileSet, Integer> firstGidPerTileset;
    public Settings settings = new Settings();

    public void writeMap(Map map, String filename) throws IOException {
        OutputStream os = new FileOutputStream(filename);
        if (filename.endsWith(".tmx.gz")) {
            os = new GZIPOutputStream(os);
        }
        OutputStreamWriter writer = new OutputStreamWriter(os, Charset.forName("UTF-8"));
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.startDocument();
        this.writeMap(map, xmlWriter, filename);
        xmlWriter.endDocument();
        ((Writer)writer).flush();
        if (os instanceof GZIPOutputStream) {
            ((GZIPOutputStream)os).finish();
        }
    }

    public void writeTileset(TileSet set, String filename) throws IOException {
        FileOutputStream os = new FileOutputStream(filename);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, Charset.forName("UTF-8"));
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.startDocument();
        this.writeTileset(set, xmlWriter, filename);
        xmlWriter.endDocument();
        ((Writer)writer).flush();
    }

    public void writeMap(Map map, OutputStream out) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.startDocument();
        this.writeMap(map, xmlWriter, "/.");
        xmlWriter.endDocument();
        ((Writer)writer).flush();
    }

    public void writeTileset(TileSet set, OutputStream out) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(out, Charset.forName("UTF-8"));
        XMLWriter xmlWriter = new XMLWriter(writer);
        xmlWriter.startDocument();
        this.writeTileset(set, xmlWriter, "/.");
        xmlWriter.endDocument();
        ((Writer)writer).flush();
    }

    private void writeMap(Map map, XMLWriter w, String wp) throws IOException {
        w.startElement("map");
        w.writeAttribute("version", "1.2");
        if (!map.getTiledversion().isEmpty()) {
            w.writeAttribute("tiledversion", map.getTiledversion());
        }
        Orientation orientation = map.getOrientation();
        w.writeAttribute("orientation", orientation.value());
        w.writeAttribute("renderorder", map.getRenderorder().value());
        w.writeAttribute("width", map.getWidth());
        w.writeAttribute("height", map.getHeight());
        w.writeAttribute("tilewidth", map.getTileWidth());
        w.writeAttribute("tileheight", map.getTileHeight());
        w.writeAttribute("infinite", map.getInfinite());
        w.writeAttribute("nextlayerid", map.getNextlayerid());
        w.writeAttribute("nextobjectid", map.getNextobjectid());
        switch (orientation) {
            case HEXAGONAL: {
                w.writeAttribute("hexsidelength", map.getHexSideLength());
            }
            case STAGGERED: {
                w.writeAttribute("staggeraxis", map.getStaggerAxis().value());
                w.writeAttribute("staggerindex", map.getStaggerIndex().value());
            }
        }
        this.writeProperties(map.getProperties(), w);
        this.firstGidPerTileset = new HashMap();
        int firstgid = 1;
        for (TileSet tileset : map.getTileSets()) {
            this.setFirstGidForTileset(tileset, firstgid);
            this.writeTilesetReference(tileset, w, wp);
            firstgid += tileset.getMaxTileId() + 1;
        }
        for (MapLayer layer : map.getLayers()) {
            if (layer instanceof TileLayer) {
                this.writeMapLayer((TileLayer)layer, w, wp);
                continue;
            }
            if (layer instanceof ObjectGroup) {
                this.writeObjectGroup((ObjectGroup)layer, w, wp);
                continue;
            }
            if (!(layer instanceof Group)) continue;
            this.writeGroup((Group)layer, w, wp);
        }
        this.firstGidPerTileset = null;
        w.endElement();
    }

    private void writeGroup(Group group, XMLWriter w, String wp) throws IOException {
        w.startElement("group");
        this.writeLayerAttributes(group, w);
        this.writeProperties(group.getProperties(), w);
        for (MapLayer layer : group.getLayers()) {
            if (layer instanceof TileLayer) {
                this.writeMapLayer((TileLayer)layer, w, wp);
                continue;
            }
            if (layer instanceof ObjectGroup) {
                this.writeObjectGroup((ObjectGroup)layer, w, wp);
                continue;
            }
            if (!(layer instanceof Group)) continue;
            this.writeGroup((Group)layer, w, wp);
        }
        w.endElement();
    }

    private void writeProperties(Properties props, XMLWriter w) throws IOException {
        if (props != null && !props.isEmpty()) {
            TreeSet<String> propertyKeys = new TreeSet<String>();
            propertyKeys.addAll(props.keySet());
            w.startElement("properties");
            for (Object e : propertyKeys) {
                String key = (String)e;
                String property = props.getProperty(key);
                w.startElement("property");
                w.writeAttribute("name", key);
                if (property.indexOf(10) == -1) {
                    if ("true".equals(property) || "false".equals(property)) {
                        w.writeAttribute("type", "bool");
                    }
                    w.writeAttribute("value", property);
                } else {
                    w.writeCDATA(property);
                }
                w.endElement();
            }
            w.endElement();
        }
    }

    private void writeTilesetReference(TileSet set, XMLWriter w, String wp) throws IOException {
        String source = set.getSource();
        if (source == null) {
            this.writeTileset(set, w, wp);
        } else {
            w.startElement("tileset");
            w.writeAttribute("firstgid", this.getFirstGidForTileset(set));
            w.writeAttribute("source", TMXMapWriter.getRelativePath(wp, source));
            w.endElement();
        }
    }

    private void writeTileset(TileSet set, XMLWriter w, String wp) throws IOException {
        String tileBitmapFile = set.getTilebmpFile();
        String name = set.getName();
        w.startElement("tileset");
        w.writeAttribute("firstgid", this.getFirstGidForTileset(set));
        if (name != null) {
            w.writeAttribute("name", name);
        }
        if (tileBitmapFile != null) {
            w.writeAttribute("tilewidth", set.getTileWidth());
            w.writeAttribute("tileheight", set.getTileHeight());
            int tileSpacing = set.getTileSpacing();
            int tileMargin = set.getTileMargin();
            if (tileSpacing != 0) {
                w.writeAttribute("spacing", tileSpacing);
            }
            if (tileMargin != 0) {
                w.writeAttribute("margin", tileMargin);
            }
        }
        if (tileBitmapFile != null) {
            w.startElement("image");
            w.writeAttribute("source", TMXMapWriter.getRelativePath(wp, tileBitmapFile));
            Color trans = set.getTransparentColor();
            if (trans != null) {
                w.writeAttribute("trans", Integer.toHexString(trans.getRGB()).substring(2));
            }
            w.endElement();
            for (Tile tile : set) {
                if (tile == null || tile.getProperties().isEmpty() && tile.getType().isEmpty()) continue;
                w.startElement("tile");
                w.writeAttribute("id", tile.getId());
                if (!tile.getType().isEmpty()) {
                    w.writeAttribute("type", tile.getType());
                }
                if (!tile.getProperties().isEmpty()) {
                    this.writeProperties(tile.getProperties(), w);
                }
                w.endElement();
            }
        } else {
            boolean needWrite = false;
            for (Tile tile : set) {
                if (tile.getProperties().isEmpty() && tile.getType().isEmpty() && tile.getSource() == null) continue;
                needWrite = true;
                break;
            }
            if (needWrite) {
                w.writeAttribute("tilewidth", set.getTileWidth());
                w.writeAttribute("tileheight", set.getTileHeight());
                w.writeAttribute("tilecount", set.size());
                w.writeAttribute("columns", set.getColumns());
                for (Tile tile : set) {
                    if (tile == null) continue;
                    this.writeTile(tile, w, wp);
                }
            }
        }
        w.endElement();
    }

    private void writeObjectGroup(ObjectGroup o, XMLWriter w, String wp) throws IOException {
        w.startElement("objectgroup");
        if (o.getColor() != null && o.getColor().isEmpty()) {
            w.writeAttribute("color", o.getColor());
        }
        if (o.getDraworder() != null && !o.getDraworder().equalsIgnoreCase("topdown")) {
            w.writeAttribute("draworder", o.getDraworder());
        }
        this.writeLayerAttributes(o, w);
        this.writeProperties(o.getProperties(), w);
        Iterator<MapObject> itr = o.getObjects().iterator();
        while (itr.hasNext()) {
            this.writeMapObject(itr.next(), w, wp);
        }
        w.endElement();
    }

    private void writeLayerAttributes(MapLayer l, XMLWriter w) throws IOException {
        Float opacity;
        Boolean isVisible;
        Rectangle bounds = l.getBounds();
        w.writeAttribute("id", l.getId());
        w.writeAttribute("name", l.getName());
        if (l instanceof TileLayer) {
            if (bounds.width != 0) {
                w.writeAttribute("width", bounds.width);
            }
            if (bounds.height != 0) {
                w.writeAttribute("height", bounds.height);
            }
        }
        if (bounds.x != 0) {
            w.writeAttribute("x", bounds.x);
        }
        if (bounds.y != 0) {
            w.writeAttribute("y", bounds.y);
        }
        if ((isVisible = l.isVisible()) != null && !isVisible.booleanValue()) {
            w.writeAttribute("visible", "0");
        }
        if ((opacity = l.getOpacity()) != null && opacity.floatValue() < 1.0f) {
            w.writeAttribute("opacity", opacity.floatValue());
        }
        if (l.getOffsetX() != null && l.getOffsetX() != 0) {
            w.writeAttribute("offsetx", l.getOffsetX());
        }
        if (l.getOffsetY() != null && l.getOffsetY() != 0) {
            w.writeAttribute("offsety", l.getOffsetY());
        }
        if (l.getLocked() != null && l.getLocked() != 0) {
            w.writeAttribute("locked", l.getLocked());
        }
    }

    private void writeMapLayer(TileLayer l, XMLWriter w, String wp) throws IOException {
        DeflaterOutputStream dos;
        Rectangle bounds = l.getBounds();
        w.startElement("layer");
        this.writeLayerAttributes(l, w);
        this.writeProperties(l.getProperties(), w);
        TileLayer tl = l;
        w.startElement("data");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        w.writeAttribute("encoding", "base64");
        if ("zlib".equalsIgnoreCase(this.settings.layerCompressionMethod)) {
            dos = new DeflaterOutputStream(baos);
        } else if ("gzip".equalsIgnoreCase(this.settings.layerCompressionMethod)) {
            dos = new GZIPOutputStream(baos);
        } else {
            throw new IOException("Unrecognized compression method \"" + this.settings.layerCompressionMethod + "\" for map layer " + l.getName());
        }
        DeflaterOutputStream out = dos;
        w.writeAttribute("compression", this.settings.layerCompressionMethod);
        for (int y = 0; y < l.getHeight(); ++y) {
            for (int x = 0; x < l.getWidth(); ++x) {
                Tile tile = tl.getTileAt(x + bounds.x, y + bounds.y);
                int gid = 0;
                if (tile != null) {
                    gid = this.getGid(tile);
                    gid |= tl.getFlagsAt(x, y);
                }
                ((OutputStream)out).write(gid & 0xFF);
                ((OutputStream)out).write(gid >> 8 & 0xFF);
                ((OutputStream)out).write(gid >> 16 & 0xFF);
                ((OutputStream)out).write(gid >> 24 & 0xFF);
            }
        }
        if (dos != null) {
            dos.finish();
        }
        byte[] dec = baos.toByteArray();
        w.writeCDATA(DatatypeConverter.printBase64Binary((byte[])dec));
        w.endElement();
        boolean tilePropertiesElementStarted = false;
        for (int y = 0; y < l.getHeight(); ++y) {
            for (int x = 0; x < l.getWidth(); ++x) {
                Properties tip = tl.getTileInstancePropertiesAt(x, y);
                if (tip == null || tip.isEmpty()) continue;
                if (!tilePropertiesElementStarted) {
                    w.startElement("tileproperties");
                    tilePropertiesElementStarted = true;
                }
                w.startElement("tile");
                w.writeAttribute("x", x);
                w.writeAttribute("y", y);
                this.writeProperties(tip, w);
                w.endElement();
            }
        }
        if (tilePropertiesElementStarted) {
            w.endElement();
        }
        w.endElement();
    }

    private void writeTile(Tile tile, XMLWriter w, String wp) throws IOException {
        w.startElement("tile");
        w.writeAttribute("id", tile.getId());
        if (!tile.getType().isEmpty()) {
            w.writeAttribute("type", tile.getType());
        }
        if (!tile.getProperties().isEmpty()) {
            this.writeProperties(tile.getProperties(), w);
        }
        if (tile.getSource() != null) {
            this.writeImage(tile, w, wp);
        }
        if (tile instanceof AnimatedTile) {
            this.writeAnimation(((AnimatedTile)tile).getSprite(), w);
        }
        w.endElement();
    }

    private void writeImage(Tile t, XMLWriter w, String wp) throws IOException {
        w.startElement("image");
        w.writeAttribute("width", t.getWidth());
        w.writeAttribute("height", t.getHeight());
        w.writeAttribute("source", TMXMapWriter.getRelativePath(wp, t.getSource()));
        w.endElement();
    }

    private void writeAnimation(Sprite s, XMLWriter w) throws IOException {
        w.startElement("animation");
        for (int k = 0; k < s.getTotalKeys(); ++k) {
            Sprite.KeyFrame key = s.getKey(k);
            w.startElement("keyframe");
            w.writeAttribute("name", key.getName());
            for (int it = 0; it < key.getTotalFrames(); ++it) {
                Tile stile = key.getFrame(it);
                w.startElement("tile");
                w.writeAttribute("gid", this.getGid(stile));
                w.endElement();
            }
            w.endElement();
        }
        w.endElement();
    }

    private void writeMapObject(MapObject mapObject, XMLWriter w, String wp) throws IOException {
        boolean isPoint;
        w.startElement("object");
        w.writeAttribute("id", mapObject.getId());
        long gid = 0L;
        if (mapObject.getTile() != null) {
            Tile t = mapObject.getTile();
            gid = this.firstGidPerTileset.get(t.getTileSet()) + t.getId();
        } else if (mapObject.getGid() != null) {
            gid = mapObject.getGid().intValue();
        }
        if (mapObject.getFlipHorizontal()) {
            gid |= 0x80000000L;
        }
        if (mapObject.getFlipVertical()) {
            gid |= 0x40000000L;
        }
        if (mapObject.getFlipDiagonal()) {
            gid |= 0x20000000L;
        }
        if (gid != 0L) {
            w.writeAttribute("gid", gid);
        }
        if (!mapObject.getName().isEmpty()) {
            w.writeAttribute("name", mapObject.getName());
        }
        if (mapObject.getType().length() != 0) {
            w.writeAttribute("type", mapObject.getType());
        }
        w.writeAttribute("x", mapObject.getX());
        w.writeAttribute("y", mapObject.getY());
        boolean bl = isPoint = mapObject.getPoint() != null;
        if (isPoint) {
            w.startElement("point");
            w.endElement();
        } else {
            if (mapObject.getWidth() != 0.0) {
                w.writeAttribute("width", mapObject.getWidth());
            }
            if (mapObject.getHeight() != 0.0) {
                w.writeAttribute("height", mapObject.getHeight());
            }
        }
        if (mapObject.getRotation() != 0.0) {
            w.writeAttribute("rotation", mapObject.getRotation());
        }
        this.writeProperties(mapObject.getProperties(), w);
        if (mapObject.getImageSource().length() > 0) {
            w.startElement("image");
            w.writeAttribute("source", TMXMapWriter.getRelativePath(wp, mapObject.getImageSource()));
            w.endElement();
        }
        w.endElement();
    }

    public static String getRelativePath(String from, String to) {
        int i;
        String toParent;
        String fromParent;
        if (!new File(to).isAbsolute()) {
            return to;
        }
        try {
            from = new File(from).getCanonicalPath();
            to = new File(to).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File toFile = new File(to);
        ArrayList<String> fromParents = new ArrayList<String>();
        ArrayList<String> toParents = new ArrayList<String>();
        for (File fromFile = new File(from); fromFile != null; fromFile = fromFile.getParentFile()) {
            fromParents.add(0, fromFile.getName());
        }
        while (toFile != null) {
            toParents.add(0, toFile.getName());
            toFile = toFile.getParentFile();
        }
        int shared = 0;
        int maxShared = Math.min(fromParents.size(), toParents.size());
        for (shared = 0; shared < maxShared && (fromParent = (String)fromParents.get(shared)).equals(toParent = (String)toParents.get(shared)); ++shared) {
        }
        StringBuilder relPathBuf = new StringBuilder();
        for (i = shared; i < fromParents.size() - 1; ++i) {
            relPathBuf.append("..").append(File.separator);
        }
        for (i = shared; i < toParents.size() - 1; ++i) {
            relPathBuf.append((String)toParents.get(i)).append(File.separator);
        }
        relPathBuf.append(new File(to).getName());
        String relPath = relPathBuf.toString();
        try {
            String absPath = new File(relPath).getCanonicalPath();
            if (!absPath.equals(relPath)) {
                relPath = relPath.replace('\\', '/');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return relPath;
    }

    public boolean accept(File pathName) {
        try {
            String path = pathName.getCanonicalPath();
            if (path.endsWith(".tmx") || path.endsWith(".tsx") || path.endsWith(".tmx.gz")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private int getGid(Tile tile) {
        TileSet tileset = tile.getTileSet();
        if (tileset != null) {
            return tile.getId() + this.getFirstGidForTileset(tileset);
        }
        return tile.getId();
    }

    private void setFirstGidForTileset(TileSet tileset, int firstGid) {
        this.firstGidPerTileset.put(tileset, firstGid);
    }

    private int getFirstGidForTileset(TileSet tileset) {
        if (this.firstGidPerTileset == null) {
            return 1;
        }
        return this.firstGidPerTileset.get(tileset);
    }

    public static class Settings {
        @Deprecated
        public static final String LAYER_COMPRESSION_METHOD_GZIP = "gzip";
        public static final String LAYER_COMPRESSION_METHOD_ZLIB = "zlib";
        public String layerCompressionMethod = "zlib";
    }
}

