/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.util;

import java.awt.image.BufferedImage;
import org.mapeditor.util.TileCutter;

public class BasicTileCutter
implements TileCutter {
    private int nextX;
    private int nextY;
    private BufferedImage image;
    private final int tileWidth;
    private final int tileHeight;
    private final int tileSpacing;
    private final int tileMargin;

    public BasicTileCutter(int tileWidth, int tileHeight, int tileSpacing, int tileMargin) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.tileSpacing = tileSpacing;
        this.tileMargin = tileMargin;
        this.reset();
    }

    @Override
    public String getName() {
        return "Basic";
    }

    @Override
    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Override
    public BufferedImage getNextTile() {
        if (this.nextY + this.tileHeight + this.tileMargin <= this.image.getHeight()) {
            BufferedImage tile = this.image.getSubimage(this.nextX, this.nextY, this.tileWidth, this.tileHeight);
            this.nextX += this.tileWidth + this.tileSpacing;
            if (this.nextX + this.tileWidth + this.tileMargin > this.image.getWidth()) {
                this.nextX = this.tileMargin;
                this.nextY += this.tileHeight + this.tileSpacing;
            }
            return tile;
        }
        return null;
    }

    @Override
    public final void reset() {
        this.nextX = this.tileMargin;
        this.nextY = this.tileMargin;
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileSpacing() {
        return this.tileSpacing;
    }

    public int getTileMargin() {
        return this.tileMargin;
    }

    public int getColumns() {
        return (this.image.getWidth() - 2 * this.tileMargin + this.tileSpacing) / (this.tileWidth + this.tileSpacing);
    }
}

