/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageHelper {
    public static byte[] imageToPNG(BufferedImage image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BufferedImage buffer = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            buffer.createGraphics().drawImage((Image)image, 0, 0, null);
            ImageIO.write((RenderedImage)buffer, "PNG", baos);
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static BufferedImage bytesToImage(byte[] imageData) throws IOException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image toolkitImage = toolkit.createImage(imageData);
        int width = toolkitImage.getWidth(null);
        int height = toolkitImage.getHeight(null);
        toolkitImage = toolkitImage.getScaledInstance(width, height, 2);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics g = img.getGraphics();
        g.drawImage(toolkitImage, 0, 0, null);
        g.dispose();
        return img;
    }
}

