/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URLHelper {
    private static final String JAR_PROTOCOL = "jar";
    private static final char URL_SEPARATOR_CHAR = '/';
    private static final String URL_SEPARATOR = "/";
    private static final String PARENT_DIR = "..";
    private static final String CURRENT_DIR = ".";
    private static final char JAR_PATH_SEPARATOR_CHAR = '!';

    private URLHelper() {
    }

    public static URL getParent(URL url) throws MalformedURLException, URISyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("Url cannot be null");
        }
        if (URLHelper.isDirectory(url)) {
            return URLHelper.resolve(url, PARENT_DIR);
        }
        return URLHelper.resolve(url, CURRENT_DIR);
    }

    private static boolean isDirectory(URL url) {
        return url.getPath().endsWith(URL_SEPARATOR);
    }

    public static URL resolve(URL url, String path) throws URISyntaxException, MalformedURLException {
        if (url == null) {
            throw new IllegalArgumentException("Url cannot be null");
        }
        if (path == null || path.isEmpty()) {
            return url;
        }
        String urlPath = path.replace(File.separatorChar, '/');
        if (JAR_PROTOCOL.equals(url.getProtocol())) {
            String urlStr = url.toString();
            int jarPathStart = urlStr.lastIndexOf(33);
            String withinJarPath = urlStr.substring(jarPathStart + 1);
            return new URL(urlStr.substring(0, jarPathStart + 1) + new URI(withinJarPath).resolve(urlPath));
        }
        return url.toURI().resolve(urlPath).toURL();
    }
}

