/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import org.mapeditor.core.Map;
import org.mapeditor.core.MapObject;
import org.mapeditor.core.ObjectGroup;
import org.mapeditor.core.Tile;
import org.mapeditor.core.TileLayer;
import org.mapeditor.view.MapRenderer;

public class HexagonalRenderer
implements MapRenderer {
    public static final int ALIGN_TOP = 1;
    public static final int ALIGN_BOTTOM = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int ALIGN_LEFT = 4;
    private final Map map;
    private final int mapAlignment;
    private boolean hexEdgesToTheLeft;
    private boolean alignedToBottomOrRight;

    public HexagonalRenderer(Map map) {
        this.map = map;
        this.mapAlignment = 4;
        this.hexEdgesToTheLeft = false;
        if (this.mapAlignment == 1 || this.mapAlignment == 2) {
            this.hexEdgesToTheLeft = true;
        }
        this.alignedToBottomOrRight = false;
        if (this.mapAlignment == 2 || this.mapAlignment == 3) {
            this.alignedToBottomOrRight = true;
        }
    }

    @Override
    public Dimension getMapSize() {
        int h;
        int w;
        Dimension tsize = this.getEffectiveMapTileSize();
        int tq = this.getThreeQuarterHex(tsize);
        int oq = this.getOneQuarterHex(tsize);
        if (this.hexEdgesToTheLeft) {
            w = this.map.getWidth() * tq + oq;
            h = this.map.getHeight() * tsize.height + (int)((double)(tsize.height / 2) + 0.49);
        } else {
            w = this.map.getWidth() * tsize.width + (int)((double)(tsize.width / 2) + 0.49);
            h = this.map.getHeight() * tq + oq;
        }
        return new Dimension(w, h);
    }

    @Override
    public void paintTileLayer(Graphics2D g, TileLayer layer) {
        Dimension tsize = this.getEffectiveMapTileSize();
        Rectangle clipRect = g.getClipBounds();
        Point topLeft = this.screenToTileCoords(layer, (int)clipRect.getMinX(), (int)clipRect.getMinY());
        Point bottomRight = this.screenToTileCoords(layer, (int)clipRect.getMaxX(), (int)clipRect.getMaxY());
        int startX = (int)topLeft.getX();
        int startY = (int)topLeft.getY();
        int endX = (int)bottomRight.getX();
        int endY = (int)bottomRight.getY();
        if (startX < 0) {
            startX = 0;
        }
        if (startY < 0) {
            startY = 0;
        }
        if (endX >= this.map.getWidth()) {
            endX = this.map.getWidth() - 1;
        }
        if (endY >= this.map.getHeight()) {
            endY = this.map.getHeight() - 1;
        }
        for (int y = startY; y <= endY; ++y) {
            for (int x = startX; x <= endX; ++x) {
                Tile t = layer.getTileAt(x, y);
                if (t == null) continue;
                Point screenCoords = this.getTopLeftCornerOfTile(tsize, x, y);
                double gx = screenCoords.getX();
                double gy = screenCoords.getY();
                g.drawImage((Image)t.getImage(), (int)gx, (int)gy, null);
            }
        }
    }

    @Override
    public void paintObjectGroup(Graphics2D g, ObjectGroup group) {
        for (MapObject mo : group) {
            double ox = mo.getX();
            double oy = mo.getY();
            if (mo.getWidth() == 0.0 || mo.getHeight() == 0.0) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.black);
                g.fillOval((int)ox + 1, (int)oy + 1, 10, 10);
                g.setColor(Color.orange);
                g.fillOval((int)ox, (int)oy, 10, 10);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                continue;
            }
            g.setColor(Color.black);
            g.drawRect((int)ox + 1, (int)oy + 1, mo.getWidth().intValue(), mo.getHeight().intValue());
            g.setColor(Color.orange);
            g.drawRect((int)ox, (int)oy, mo.getWidth().intValue(), mo.getHeight().intValue());
        }
    }

    private Dimension getEffectiveMapTileSize() {
        return new Dimension((int)((double)this.map.getTileWidth() + 0.999), (int)((double)this.map.getTileHeight() + 0.999));
    }

    private int getThreeQuarterHex(Dimension tileDimension) {
        int tq = this.hexEdgesToTheLeft ? (int)((double)tileDimension.width * 3.0 / 4.0 + 0.49) : (int)((double)tileDimension.height * 3.0 / 4.0 + 0.49);
        return tq;
    }

    private int getOneQuarterHex(Dimension tileDimension) {
        int oq = this.hexEdgesToTheLeft ? tileDimension.width : tileDimension.height;
        return oq - this.getThreeQuarterHex(tileDimension);
    }

    public Point screenToTileCoords(TileLayer layer, int screenX, int screenY) {
        Dimension tileSize = this.getEffectiveMapTileSize();
        int tileWidth = tileSize.width;
        int tileHeight = tileSize.height;
        int hWidth = (int)((double)(tileWidth / 2) + 0.49);
        int hHeight = (int)((double)(tileHeight / 2) + 0.49);
        Point[] fourPoints = new Point[4];
        Point[] fourTiles = new Point[4];
        int x = screenX;
        int y = screenY;
        int col = x < hWidth ? -1 : (this.hexEdgesToTheLeft ? (int)((double)(x - hWidth) / (double)this.getThreeQuarterHex(tileSize) + 0.001) : (int)((double)(x - hWidth) / (double)tileWidth + 0.001));
        int row = y < hHeight ? -1 : (this.hexEdgesToTheLeft ? (int)((double)(y - hHeight) / (double)tileHeight + 0.001) : (int)((double)(y - hHeight) / (double)this.getThreeQuarterHex(tileSize) + 0.001));
        fourTiles[0] = new Point(col, row);
        fourTiles[1] = new Point(col, row + 1);
        fourTiles[2] = new Point(col + 1, row);
        fourTiles[3] = new Point(col + 1, row + 1);
        fourPoints[0] = this.tileToScreenCoords(tileSize, col, row);
        fourPoints[1] = this.tileToScreenCoords(tileSize, col, row + 1);
        fourPoints[2] = this.tileToScreenCoords(tileSize, col + 1, row);
        fourPoints[3] = this.tileToScreenCoords(tileSize, col + 1, row + 1);
        double minDist = 2 * (this.map.getTileWidth() + this.map.getTileHeight());
        int minI = 5;
        for (int i = 0; i < fourPoints.length; ++i) {
            if (!(fourPoints[i].distance(x, y) < minDist)) continue;
            minDist = fourPoints[i].distance(x, y);
            minI = i;
        }
        int tx = (int)fourTiles[minI].getX();
        int ty = (int)fourTiles[minI].getY();
        return new Point(tx, ty);
    }

    public Point tileToScreenCoords(Dimension tileSize, int x, int y) {
        Point p = this.getTopLeftCornerOfTile(tileSize, x, y);
        return new Point((int)p.getX() + (int)((double)(tileSize.width / 2) + 0.49), (int)p.getY() + (int)((double)(tileSize.height / 2) + 0.49));
    }

    private Point getTopLeftCornerOfTile(Dimension tileSize, int x, int y) {
        int yy;
        int xx;
        int w = tileSize.width;
        int h = tileSize.height;
        if (this.hexEdgesToTheLeft) {
            xx = x * this.getThreeQuarterHex(tileSize);
            yy = y * h;
        } else {
            xx = x * w;
            yy = y * this.getThreeQuarterHex(tileSize);
        }
        if (Math.abs(x % 2) == 1 && this.mapAlignment == 1 || x % 2 == 0 && this.mapAlignment == 2) {
            yy += (int)((double)h / 2.0 + 0.49);
        }
        if (Math.abs(y % 2) == 1 && this.mapAlignment == 4 || y % 2 == 0 && this.mapAlignment == 3) {
            xx += (int)((double)w / 2.0 + 0.49);
        }
        return new Point(xx, yy);
    }
}

