/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.view;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.mapeditor.core.Map;
import org.mapeditor.core.ObjectGroup;
import org.mapeditor.core.Tile;
import org.mapeditor.core.TileLayer;
import org.mapeditor.view.MapRenderer;

public class IsometricRenderer
implements MapRenderer {
    private final Map map;

    public IsometricRenderer(Map map) {
        this.map = map;
    }

    @Override
    public Dimension getMapSize() {
        int side = this.map.getHeight() + this.map.getWidth();
        return new Dimension(side * this.map.getTileWidth() / 2, side * this.map.getTileHeight() / 2);
    }

    @Override
    public void paintTileLayer(Graphics2D g, TileLayer layer) {
        Rectangle clip = g.getClipBounds();
        int tileWidth = this.map.getTileWidth();
        int tileHeight = this.map.getTileHeight();
        double tileRatio = (double)tileWidth / (double)tileHeight;
        clip.x -= this.map.getHeight() * (tileWidth / 2);
        int mx = clip.y + (int)((double)clip.x / tileRatio);
        int my = clip.y - (int)((double)clip.x / tileRatio);
        Point rowItr = new Point((mx < 0 ? mx - tileHeight : mx) / tileHeight, (my < 0 ? my - tileHeight : my) / tileHeight);
        --rowItr.x;
        int originX = this.map.getHeight() * tileWidth / 2;
        Point drawLoc = new Point((rowItr.x - rowItr.y) * tileWidth / 2 + originX, (rowItr.x + rowItr.y) * tileHeight / 2);
        drawLoc.x -= tileWidth / 2;
        drawLoc.y -= tileHeight / 2;
        drawLoc.x = drawLoc.x + (layer.getOffsetX() != null ? layer.getOffsetX() : 0);
        drawLoc.y = drawLoc.y + (layer.getOffsetY() != null ? layer.getOffsetY() : 0);
        int tileStepY = tileHeight / 2 == 0 ? 1 : tileHeight / 2;
        int columns = clip.width / tileWidth + 3;
        int rows = clip.height / tileStepY + 4;
        for (int y = 0; y < rows; ++y) {
            Point columnItr = new Point(rowItr);
            for (int x = 0; x < columns; ++x) {
                Tile tile = layer.getTileAt(columnItr.x, columnItr.y);
                if (tile != null) {
                    BufferedImage image = tile.getImage();
                    if (image == null) continue;
                    drawLoc.x = drawLoc.x + (tile.getTileSet().getTileoffset() != null ? tile.getTileSet().getTileoffset().getX() : 0);
                    drawLoc.y = drawLoc.y + (tile.getTileSet().getTileoffset() != null ? tile.getTileSet().getTileoffset().getY() : 0);
                    g.drawImage((Image)image, drawLoc.x, drawLoc.y, null);
                }
                ++columnItr.x;
                --columnItr.y;
                drawLoc.x += tileWidth;
            }
            if ((y & 1) > 0) {
                ++rowItr.x;
                drawLoc.x += tileWidth / 2;
            } else {
                ++rowItr.y;
                drawLoc.x -= tileWidth / 2;
            }
            drawLoc.x -= columns * tileWidth;
            drawLoc.y += tileStepY;
        }
    }

    @Override
    public void paintObjectGroup(Graphics2D g, ObjectGroup group) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

