/*
 * Decompiled with CFR 0.152.
 */
package org.mapeditor.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.mapeditor.core.Map;
import org.mapeditor.core.MapObject;
import org.mapeditor.core.ObjectGroup;
import org.mapeditor.core.Tile;
import org.mapeditor.core.TileLayer;
import org.mapeditor.view.MapRenderer;

public class OrthogonalRenderer
implements MapRenderer {
    private final Map map;

    public OrthogonalRenderer(Map map) {
        this.map = map;
    }

    @Override
    public Dimension getMapSize() {
        return new Dimension(this.map.getWidth() * this.map.getTileWidth(), this.map.getHeight() * this.map.getTileHeight());
    }

    @Override
    public void paintTileLayer(Graphics2D g, TileLayer layer) {
        Rectangle clip = g.getClipBounds();
        int tileWidth = this.map.getTileWidth();
        int tileHeight = this.map.getTileHeight();
        Rectangle bounds = layer.getBounds();
        g.translate(bounds.x * tileWidth, bounds.y * tileHeight);
        clip.translate(-bounds.x * tileWidth, -bounds.y * tileHeight);
        clip.height += this.map.getTileHeightMax();
        int startX = Math.max(0, clip.x / tileWidth);
        int startY = Math.max(0, clip.y / tileHeight);
        int endX = Math.min(layer.getWidth(), (int)Math.ceil(clip.getMaxX() / (double)tileWidth));
        int endY = Math.min(layer.getHeight(), (int)Math.ceil(clip.getMaxY() / (double)tileHeight));
        for (int x = startX; x < endX; ++x) {
            for (int y = startY; y < endY; ++y) {
                BufferedImage image;
                Tile tile = layer.getTileAt(x, y);
                if (tile == null || (image = tile.getImage()) == null) continue;
                Point drawLoc = new Point(x * tileWidth, (y + 1) * tileHeight - ((Image)image).getHeight(null));
                drawLoc.x = drawLoc.x + (layer.getOffsetX() != null ? layer.getOffsetX() : 0);
                drawLoc.y = drawLoc.y + (layer.getOffsetY() != null ? layer.getOffsetY() : 0);
                drawLoc.x = drawLoc.x + (tile.getTileSet().getTileoffset() != null ? tile.getTileSet().getTileoffset().getX() : 0);
                drawLoc.y = drawLoc.y + (tile.getTileSet().getTileoffset() != null ? tile.getTileSet().getTileoffset().getY() : 0);
                g.drawImage((Image)image, drawLoc.x, drawLoc.y, null);
            }
        }
        g.translate(-bounds.x * tileWidth, -bounds.y * tileHeight);
    }

    @Override
    public void paintObjectGroup(Graphics2D g, ObjectGroup group) {
        Dimension tsize = new Dimension(this.map.getTileWidth(), this.map.getTileHeight());
        assert (tsize.width != 0 && tsize.height != 0);
        Rectangle bounds = this.map.getBounds();
        g.translate(bounds.x * tsize.width, bounds.y * tsize.height);
        for (MapObject mo : group) {
            double ox = mo.getX();
            double oy = mo.getY();
            Double objectWidth = mo.getWidth();
            Double objectHeight = mo.getHeight();
            double rotation = mo.getRotation();
            Tile tile = mo.getTile();
            if (tile != null) {
                BufferedImage objectImage = tile.getImage();
                AffineTransform old = g.getTransform();
                g.rotate(Math.toRadians(rotation));
                g.drawImage((Image)objectImage, (int)ox, (int)oy, null);
                g.setTransform(old);
            } else if (objectWidth == null || objectWidth == 0.0 || objectHeight == null || objectHeight == 0.0) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.black);
                g.fillOval((int)ox + 1, (int)oy + 1, 10, 10);
                g.setColor(Color.orange);
                g.fillOval((int)ox, (int)oy, 10, 10);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                g.setColor(Color.black);
                g.drawRect((int)ox + 1, (int)oy + 1, mo.getWidth().intValue(), mo.getHeight().intValue());
                g.setColor(Color.orange);
                g.drawRect((int)ox, (int)oy, mo.getWidth().intValue(), mo.getHeight().intValue());
            }
            String s = mo.getName() != null ? mo.getName() : "(null)";
            g.setColor(Color.black);
            g.drawString(s, (int)(ox - 5.0) + 1, (int)(oy - 5.0) + 1);
            g.setColor(Color.white);
            g.drawString(s, (int)(ox - 5.0), (int)(oy - 5.0));
        }
        g.translate(-bounds.x * tsize.width, -bounds.y * tsize.height);
    }
}

