/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.text.pdf.PdfTemplate;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.mapfish.print.ChunkDrawer;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.HorizontalAlign;
import org.mapfish.print.config.layout.MapBlock;
import org.mapfish.print.config.layout.ScalebarBlock;
import org.mapfish.print.config.layout.TableConfig;
import org.mapfish.print.utils.PJsonObject;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class PDFUtils {
    public static final Logger LOGGER = Logger.getLogger(PDFUtils.class);
    private static final Map<String, Image> placeholderCache = new HashMap<String, Image>();
    private static final Pattern VAR_REGEXP = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final Pattern FORMAT_PATTERN = Pattern.compile("^format\\s+(%[-+# 0,(]*\\d*(\\.\\d*)?(d))\\s+(.*)$");

    public static Image getImage(RenderingContext context, URI uri, float w, float h) throws IOException, DocumentException {
        return PDFUtils.getImage(context, uri, w, h, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(RenderingContext context, URI uri, float w, float h, float scale) throws IOException, DocumentException {
        Map<URI, PdfTemplate> cache = context.getTemplateCache();
        PdfTemplate template = cache.get(uri);
        if (template == null) {
            Image content = PDFUtils.getImageDirect(context, uri);
            content.setAbsolutePosition(0.0f, 0.0f);
            PdfContentByte dc = context.getDirectContent();
            Object object = context.getPdfLock();
            synchronized (object) {
                template = dc.createTemplate(content.getPlainWidth(), content.getPlainHeight());
                template.addImage(content);
            }
            cache.put(uri, template);
        }
        if (w == 0.0f) {
            if (h == 0.0f) {
                scale = scale == 0.0f ? 1.0f : scale;
                w = template.getWidth() * scale;
                h = template.getHeight() * scale;
            } else if (scale == 0.0f) {
                w = h / template.getHeight() * template.getWidth();
            } else {
                float maxh = h;
                w = template.getWidth() * scale;
                h = template.getWidth() * scale;
                float scaleh = h / maxh;
                if (scaleh > 1.0f) {
                    w /= scaleh;
                    h /= scaleh;
                }
            }
        } else if (h == 0.0f) {
            if (scale == 0.0f) {
                h = w / template.getWidth() * template.getHeight();
            } else {
                float maxw = w;
                w = template.getWidth() * scale;
                h = template.getWidth() * scale;
                float scalew = w / maxw;
                if (scalew > 1.0f) {
                    w /= scalew;
                    h /= scalew;
                }
            }
        } else if (scale == 0.0f) {
            float scalew = template.getWidth() / w;
            float scaleh = template.getHeight() / h;
            float maxscale = Math.max(scalew, scaleh);
            w = template.getWidth() / maxscale;
            h = template.getHeight() / maxscale;
        } else {
            float scaleh;
            float maxw = w;
            float maxh = h;
            w = template.getWidth() * scale;
            float scalew = w / maxw;
            float maxscale = Math.max(scalew, scaleh = (h = template.getHeight() * scale) / maxh);
            if (maxscale > 1.0f) {
                w /= maxscale;
                h /= maxscale;
            }
        }
        Image result = Image.getInstance((PdfTemplate)template);
        result.scaleToFit(w, h);
        return result;
    }

    protected static Image getImageDirect(RenderingContext context, URI uri) throws IOException, DocumentException {
        return PDFUtils.loadImageFromUrl(context, uri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image loadImageFromUrl(RenderingContext context, URI uri, boolean alwaysThrowExceptionOnError) throws IOException, DocumentException {
        File uriAsFile = null;
        try {
            uriAsFile = new File(uri.toString());
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (uriAsFile != null && uriAsFile.exists()) {
            return Image.getInstance((URL)uriAsFile.toURI().toURL());
        }
        if (!uri.isAbsolute()) {
            return Image.getInstance((String)uri.toString());
        }
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            String path = uri.getHost() != null && uri.getPath() != null ? uri.getHost() + uri.getPath() : (uri.getHost() == null && uri.getPath() != null ? uri.getPath() : uri.toString().substring("file:".length()).replaceAll("/+", "/"));
            path = path.replace("/", File.separator);
            return Image.getInstance((URL)new File(path).toURI().toURL());
        }
        byte[] data = null;
        try {
            Image image;
            String contentType;
            String statusText;
            int statusCode;
            if ((uri.getScheme().equals("http") || uri.getScheme().equals("https")) && context.getConfig().localHostForwardIsFrom(uri.getHost())) {
                String scheme = uri.getScheme();
                String host = uri.getHost();
                if (uri.getScheme().equals("https") && context.getConfig().localHostForwardIsHttps2http()) {
                    scheme = "http";
                }
                URL url = new URL(scheme, "localhost", uri.getPort(), uri.getPath() + "?" + uri.getQuery());
                HttpURLConnection connexion = (HttpURLConnection)url.openConnection();
                connexion.setRequestProperty("Host", host);
                for (Map.Entry<String, String> entry : context.getHeaders().entrySet()) {
                    connexion.setRequestProperty(entry.getKey(), entry.getValue());
                }
                InputStream is = null;
                try {
                    try {
                        int length;
                        is = connexion.getInputStream();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((length = is.read(buffer)) != -1) {
                            baos.write(buffer, 0, length);
                        }
                        baos.flush();
                        data = baos.toByteArray();
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)e);
                    }
                    statusCode = connexion.getResponseCode();
                    statusText = connexion.getResponseMessage();
                    contentType = connexion.getContentType();
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            GetMethod getMethod = null;
            MetricRegistry registry = context.getConfig().getMetricRegistry();
            Timer.Context timer = registry.timer("http_" + uri.getAuthority()).time();
            try {
                getMethod = new GetMethod(uri.toString());
                for (Map.Entry<String, String> entry : context.getHeaders().entrySet()) {
                    getMethod.setRequestHeader(entry.getKey(), entry.getValue());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("loading image: " + uri));
                }
                context.getConfig().getHttpClient(uri).executeMethod((HttpMethod)getMethod);
                statusCode = getMethod.getStatusCode();
                statusText = getMethod.getStatusText();
                Header contentTypeHeader = getMethod.getResponseHeader("Content-Type");
                contentType = contentTypeHeader == null ? "" : contentTypeHeader.getValue();
                data = getMethod.getResponseBody();
            }
            finally {
                timer.close();
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
            if (statusCode == 204) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("creating a transparent image for: " + uri));
                }
                try {
                    byte[] maskr = new byte[]{-1};
                    Image mask = Image.getInstance((int)1, (int)1, (int)1, (int)1, (byte[])maskr);
                    mask.makeMask();
                    data = new byte[3];
                    Image image2 = Image.getInstance((int)1, (int)1, (int)3, (int)8, (byte[])data);
                    image2.setImageMask(mask);
                    return image2;
                }
                catch (DocumentException e) {
                    LOGGER.warn((Object)"Couldn't generate a transparent image");
                    if (alwaysThrowExceptionOnError) {
                        throw e;
                    }
                    image = PDFUtils.handleImageLoadError(context, e.getMessage());
                    LOGGER.warn((Object)"The status code was not a valid code, a default image is being returned.");
                    return image;
                }
            }
            if (statusCode < 200 || statusCode >= 300 || contentType.startsWith("text/") || contentType.equals("application/vnd.ogc.se_xml")) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Server returned an error for " + uri + ": " + new String(data)));
                }
                String errorMessage = statusCode < 200 || statusCode >= 300 ? "Error (status=" + statusCode + ") while reading the image from " + uri + ": " + statusText : "Didn't receive an image while reading: " + uri;
                if (alwaysThrowExceptionOnError) {
                    throw new IOException(errorMessage);
                }
                image = PDFUtils.handleImageLoadError(context, errorMessage);
                LOGGER.warn((Object)"The status code was not a valid code, a default image is being returned.");
                return image;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("loaded image: " + uri));
            }
            return Image.getInstance((byte[])data);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Server returned an error for " + uri + ": " + e.getMessage()));
            if (alwaysThrowExceptionOnError) {
                throw e;
            }
            return PDFUtils.handleImageLoadError(context, e.getMessage());
        }
    }

    public static Image handleImageLoadError(RenderingContext context, String errorMessage) throws IOException, DocumentException {
        String placeholderString = context.getConfig().getBrokenUrlPlaceholder();
        if (placeholderString.equalsIgnoreCase("throw")) {
            throw new IOException(errorMessage);
        }
        Image image = placeholderCache.get(placeholderString);
        if (image == null) {
            try {
                if (placeholderString.equalsIgnoreCase("default")) {
                    URL url = PDFUtils.class.getClassLoader().getResource("default_error.png");
                    image = PDFUtils.loadImageFromUrl(context, url.toURI(), true);
                } else {
                    image = PDFUtils.loadImageFromUrl(context, new URI(placeholderString), true);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (image != null) {
                placeholderCache.put(placeholderString, image);
            }
        }
        return image;
    }

    public static PdfPTable createPlaceholderTable(double width, double height, double spacingAfter, ChunkDrawer drawer, HorizontalAlign align, PDFCustomBlocks customBlocks) {
        PdfPTable placeHolderTable = new PdfPTable(1);
        placeHolderTable.setLockedWidth(true);
        placeHolderTable.setTotalWidth((float)width);
        PdfPCell placeHolderCell = new PdfPCell();
        placeHolderCell.setMinimumHeight((float)height);
        placeHolderCell.setPadding(0.0f);
        placeHolderCell.setBorder(0);
        placeHolderTable.addCell(placeHolderCell);
        customBlocks.addChunkDrawer(drawer);
        placeHolderTable.setTableEvent((PdfPTableEvent)drawer);
        placeHolderTable.setComplete(true);
        PdfPCell surroundingCell = new PdfPCell(placeHolderTable);
        surroundingCell.setPadding(0.0f);
        surroundingCell.setBorder(0);
        if (align != null) {
            placeHolderTable.setHorizontalAlignment(align.getCode());
            surroundingCell.setHorizontalAlignment(align.getCode());
        }
        PdfPTable surroundingTable = new PdfPTable(1);
        surroundingTable.setSpacingAfter((float)spacingAfter);
        surroundingTable.addCell(surroundingCell);
        surroundingTable.setComplete(true);
        return surroundingTable;
    }

    public static Phrase renderString(RenderingContext context, PJsonObject params, String val, Font font, String mapName) throws BadElementException {
        Matcher matcher;
        Phrase result = new Phrase();
        while ((matcher = VAR_REGEXP.matcher(val)).find()) {
            result.add(val.substring(0, matcher.start()));
            String varName = matcher.group(1);
            if (varName.equals("pageTot")) {
                result.add((Element)context.getCustomBlocks().getOrCreateTotalPagesBlock(font));
            } else {
                String value = PDFUtils.getContextValue(context, params, varName, mapName);
                result.add(value);
            }
            val = val.substring(matcher.end());
        }
        result.add(val);
        return result;
    }

    public static String evalString(RenderingContext context, PJsonObject params, String val, String mapName) {
        Matcher matcher;
        if (val == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        while ((matcher = VAR_REGEXP.matcher(val)).find()) {
            result.append(val.substring(0, matcher.start()));
            result.append(PDFUtils.getContextValue(context, params, matcher.group(1), mapName));
            val = val.substring(matcher.end());
        }
        result.append(val);
        String uri = result.toString();
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 && (uri = uri.replace("\\", "/")).matches("file://\\w:(/.*)?")) {
            return "file:/" + uri.substring(7);
        }
        return uri;
    }

    public static String getValueFromString(String val) {
        Matcher matcher;
        String str = val;
        while ((matcher = VAR_REGEXP.matcher(val)).find()) {
            str = val.substring(0, matcher.start());
            String varName = matcher.group(1);
            str = str + PDFUtils.getDateValue(varName);
            val = val.substring(matcher.end());
        }
        return str;
    }

    private static String getDateValue(String key) {
        String val = "";
        if (key.equals("now")) {
            val = new Date().toString();
        } else if (key.startsWith("now ")) {
            val = PDFUtils.formatTime(key);
        }
        return val;
    }

    private static String getContextValue(RenderingContext context, PJsonObject params, String key, String mapName) {
        String result = null;
        if (context != null) {
            if (key.equals("pageNum")) {
                return Integer.toString(context.getWriter().getPageNumber());
            }
            if (key.equals("now")) {
                return new Date().toString();
            }
            if (key.startsWith("now ")) {
                return PDFUtils.formatTime(context, key);
            }
            Matcher matcher = FORMAT_PATTERN.matcher(key);
            if (matcher != null && matcher.matches()) {
                return PDFUtils.format(context, params, matcher, mapName);
            }
            if (key.equals("configDir")) {
                return context.getConfigDir().replace('\\', '/');
            }
            if (key.equals("scale") || key.startsWith("scale.")) {
                if (key.startsWith("scale.")) {
                    mapName = key.substring(6);
                }
                return Integer.toString((int)context.getLayout().getMainPage().getMap(mapName).createTransformer(context, params).getScale());
            }
            result = context.getGlobalParams().optString(key);
        }
        if (result == null) {
            result = params.getString(key);
        }
        return result;
    }

    private static String format(RenderingContext context, PJsonObject params, Matcher matcher, String mapName) {
        Object value;
        String valueTxt = PDFUtils.getContextValue(context, params, matcher.group(4), mapName);
        try {
            switch (matcher.group(3).charAt(0)) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    value = Math.round(Double.valueOf(valueTxt));
                    break;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    value = Double.valueOf(valueTxt);
                    break;
                }
                default: {
                    value = valueTxt;
                    break;
                }
            }
        }
        catch (Throwable e) {
            context.addError(new RuntimeException("Error converting valueTxt: '" + valueTxt + "' to a number.  Pattern: " + matcher.group(3)));
            return valueTxt;
        }
        try {
            return String.format(matcher.group(1), value);
        }
        catch (RuntimeException e) {
            context.addError(e);
            return valueTxt;
        }
    }

    private static String formatTime(RenderingContext context, String key) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(key.substring(4));
            return format.format(new Date());
        }
        catch (IllegalArgumentException e) {
            context.addError(e);
            return new Date().toString();
        }
    }

    private static String formatTime(String key) throws IllegalArgumentException {
        SimpleDateFormat format = new SimpleDateFormat(key.substring(4));
        return format.format(new Date());
    }

    public static PdfPTable buildTable(List<Block> items, PJsonObject params, RenderingContext context, int nbColumns, TableConfig tableConfig) throws DocumentException {
        int nbCells = 0;
        for (int i = 0; i < items.size(); ++i) {
            Block block = items.get(i);
            if (!block.isVisible(context, params)) continue;
            if (block.isAbsolute()) {
                block.render(params, null, context);
                continue;
            }
            ++nbCells;
        }
        if (nbCells == 0) {
            return null;
        }
        nbColumns = nbColumns > 0 ? nbColumns : nbCells;
        int nbRows = (nbCells + nbColumns - 1) / nbColumns;
        PdfPTable table = new PdfPTable(nbColumns);
        table.setWidthPercentage(100.0f);
        int cellNum = 0;
        for (int i = 0; i < items.size(); ++i) {
            Block block = items.get(i);
            if (!block.isVisible(context, params) || block.isAbsolute()) continue;
            PdfPCell cell = PDFUtils.createCell(params, context, block, cellNum / nbColumns, cellNum % nbColumns, nbRows, nbColumns, tableConfig);
            table.addCell(cell);
            ++cellNum;
        }
        table.setComplete(true);
        return table;
    }

    public static PdfPCell createCell(final PJsonObject params, final RenderingContext context, final Block block, final int row, final int col, final int nbRows, final int nbCols, final TableConfig tableConfig) throws DocumentException {
        final PdfPCell[] cell = new PdfPCell[1];
        block.render(params, new Block.PdfElement(){

            @Override
            public void add(Element element) throws DocumentException {
                if (element instanceof PdfPTable) {
                    cell[0] = new PdfPCell((PdfPTable)element);
                } else {
                    Phrase phrase = new Phrase();
                    phrase.add(element);
                    cell[0] = new PdfPCell(phrase);
                }
                cell[0].setBorder(0);
                cell[0].setPadding(0.0f);
                if (tableConfig != null) {
                    tableConfig.apply(cell[0], row, col, nbRows, nbCols, context, params);
                }
                if (block.getAlign() != null) {
                    cell[0].setHorizontalAlignment(block.getAlign().getCode());
                }
                if (block.getVertAlign() != null) {
                    cell[0].setVerticalAlignment(block.getVertAlign().getCode());
                }
                if (!(block instanceof MapBlock) && !(block instanceof ScalebarBlock) && block.getBackgroundColorVal(context, params) != null) {
                    cell[0].setBackgroundColor(block.getBackgroundColorVal(context, params));
                }
            }
        }, context);
        return cell[0];
    }

    public static Chunk createImageChunk(RenderingContext context, double maxWidth, double maxHeight, URI url, float rotation) throws DocumentException {
        return PDFUtils.createImageChunk(context, maxWidth, maxHeight, 0.0f, url, rotation);
    }

    public static Chunk createImageChunk(RenderingContext context, double maxWidth, double maxHeight, float scale, URI url, float rotation) throws DocumentException {
        Image image = PDFUtils.createImage(context, maxWidth, maxHeight, scale, url, rotation);
        return new Chunk(image, 0.0f, 0.0f, true);
    }

    public static Image createImage(RenderingContext context, double maxWidth, double maxHeight, URI url, float rotation) throws DocumentException {
        return PDFUtils.createImage(context, maxWidth, maxHeight, 0.0f, url, rotation);
    }

    public static Image createImage(RenderingContext context, double maxWidth, double maxHeight, float scale, URI url, float rotation) throws DocumentException {
        Image image;
        try {
            image = PDFUtils.getImage(context, url, (float)maxWidth, (float)maxHeight, scale);
        }
        catch (IOException e) {
            throw new InvalidValueException("url", url.toString(), e);
        }
        if (rotation != 0.0f) {
            image.setRotation(rotation);
        }
        return image;
    }

    public static BaseFont getBaseFont(String fontFamily, String fontSize, String fontWeight) {
        Font.FontFamily myFontValue = fontFamily.toUpperCase().contains("COURIER") ? Font.FontFamily.COURIER : (fontFamily.toUpperCase().contains("HELVETICA") ? Font.FontFamily.HELVETICA : (fontFamily.toUpperCase().contains("ROMAN") ? Font.FontFamily.TIMES_ROMAN : Font.FontFamily.HELVETICA));
        float myFontSize = (float)Double.parseDouble(fontSize.toLowerCase().replaceAll("px", ""));
        int myFontWeight = fontWeight.toUpperCase().contains("NORMAL") ? 0 : (fontWeight.toUpperCase().contains("BOLD") ? 1 : (fontWeight.toUpperCase().contains("ITALIC") ? 2 : 0));
        Font pdfFont = new Font(myFontValue, myFontSize, myFontWeight);
        return pdfFont.getCalculatedBaseFont(false);
    }

    public static int getHorizontalAlignment(String labelAlign) {
        int myAlignment = 0;
        if (labelAlign.toUpperCase().contains("L")) {
            myAlignment = 0;
        }
        if (labelAlign.toUpperCase().contains("C")) {
            myAlignment = 1;
        }
        if (labelAlign.toUpperCase().contains("R")) {
            myAlignment = 2;
        }
        return myAlignment;
    }

    public static float getVerticalOffset(String labelAlign, float fontHeight) {
        float myOffset = 0.0f;
        if (labelAlign.toUpperCase().contains("T")) {
            myOffset = fontHeight;
        }
        if (labelAlign.toUpperCase().contains("M")) {
            myOffset = fontHeight / 2.0f;
        }
        if (labelAlign.toUpperCase().contains("B")) {
            myOffset = 0.0f;
        }
        return myOffset;
    }

    public static Chunk createImageChunkFromSVG(RenderingContext context, String iconItem, double maxIconWidth, double maxIconHeight, double scale) throws IOException {
        return new Chunk(PDFUtils.createImageFromSVG(context, iconItem, maxIconWidth, maxIconHeight, scale), 0.0f, 0.0f, true);
    }

    public static Image createImageFromSVG(RenderingContext context, String iconItem, double maxIconWidth, double maxIconHeight, double scale) throws IOException {
        Image image = null;
        try {
            PdfContentByte dc = context.getDirectContent();
            URI uri = URI.create(iconItem);
            URL url = uri.toURL();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            ctx.setDynamicState(2);
            SVGDocument svgDoc = factory.createSVGDocument(null, url.openStream());
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode graphics = builder.build(ctx, (Document)svgDoc);
            String svgWidthString = svgDoc.getDocumentElement().getAttribute("width");
            String svgHeightString = svgDoc.getDocumentElement().getAttribute("height");
            float svgWidth = Float.valueOf(svgWidthString.substring(0, svgWidthString.length() - 2)).floatValue();
            float svgHeight = Float.valueOf(svgHeightString.substring(0, svgHeightString.length() - 2)).floatValue();
            float svgFactor = 25.4f / userAgent.getPixelUnitToMillimeter() / 72.0f;
            PdfTemplate map = dc.createTemplate(svgWidth * svgFactor, svgHeight * svgFactor);
            PdfGraphics2D g2d = new PdfGraphics2D((PdfContentByte)map, svgWidth * svgFactor, svgHeight * svgFactor);
            graphics.paint((Graphics2D)g2d);
            g2d.dispose();
            image = Image.getInstance((PdfTemplate)map);
            image.scalePercent((float)(scale * 100.0));
            if ((double)image.getWidth() * scale > maxIconWidth || (double)image.getHeight() * scale > maxIconHeight) {
                image.scaleToFit((float)maxIconWidth, (float)maxIconHeight);
            }
        }
        catch (BadElementException bee) {
            LOGGER.warn((Object)("Bad Element " + iconItem + " with " + bee.getMessage()));
        }
        catch (MalformedURLException mue) {
            LOGGER.warn((Object)("Malformed URL " + iconItem + " with " + mue.getMessage()));
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return image;
    }
}

