/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.styling.Displacement;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.PDFConfig;
import org.mapfish.print.config.Template;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.config.access.AlwaysAllowAssertion;
import org.mapfish.print.config.access.RoleAccessAssertion;
import org.mapfish.print.http.CertificateStore;
import org.mapfish.print.http.HttpCredential;
import org.mapfish.print.http.HttpProxy;
import org.mapfish.print.map.style.StyleParser;
import org.mapfish.print.servlet.fileloader.ConfigFileLoaderManager;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.Halo;
import org.opengis.style.LabelPlacement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;

public class Configuration {
    private static final Map<String, String> GEOMETRY_NAME_ALIASES;
    private Map<String, Template> templates;
    private File configurationFile;
    private Map<String, String> styles = new HashMap<String, String>();
    private Map<String, Style> defaultStyle = new HashMap<String, Style>();
    private boolean throwErrorOnExtraParameters = true;
    private List<HttpProxy> proxies = Lists.newArrayList();
    private PDFConfig pdfConfig = new PDFConfig();
    private List<HttpCredential> credentials = Lists.newArrayList();
    private CertificateStore certificateStore;
    private String outputFilename;
    private boolean defaultToSvg = false;
    @Autowired
    private StyleParser styleParser;
    @Autowired
    private ClientHttpRequestFactory clientHttpRequestFactory;
    @Autowired
    private ConfigFileLoaderManager fileLoaderManager;
    private AccessAssertion accessAssertion = AlwaysAllowAssertion.INSTANCE;

    final PDFConfig getPdfConfig() {
        return this.pdfConfig;
    }

    public final boolean renderAsSvg(Boolean renderAsSvg) {
        return renderAsSvg == null ? this.defaultToSvg : renderAsSvg;
    }

    public final void setDefaultToSvg(boolean defaultToSvg) {
        this.defaultToSvg = defaultToSvg;
    }

    public final void setPdfConfig(PDFConfig pdfConfig) {
        this.pdfConfig = pdfConfig;
    }

    public final void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    @Nullable
    public final CertificateStore getCertificateStore() {
        return this.certificateStore;
    }

    public final void setCertificateStore(CertificateStore certificateStore) {
        this.certificateStore = certificateStore;
    }

    public final List<HttpCredential> getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(List<HttpCredential> credentials) {
        this.credentials = credentials;
    }

    public final List<HttpProxy> getProxies() {
        return this.proxies;
    }

    public final void setProxies(List<HttpProxy> proxies) {
        this.proxies = proxies;
    }

    public final void printClientConfig(JSONWriter json) throws JSONException {
        json.key("layouts");
        json.array();
        Map<String, Template> accessibleTemplates = this.getTemplates();
        for (String name : accessibleTemplates.keySet()) {
            json.object();
            json.key("name").value((Object)name);
            accessibleTemplates.get(name).printClientConfig(json);
            json.endObject();
        }
        json.endArray();
    }

    public final String getOutputFilename() {
        return this.outputFilename;
    }

    public final Map<String, Template> getTemplates() {
        return Maps.filterEntries(this.templates, (Predicate)new Predicate<Map.Entry<String, Template>>(){

            public boolean apply(@Nullable Map.Entry<String, Template> input) {
                if (input == null) {
                    return false;
                }
                try {
                    Configuration.this.accessAssertion.assertAccess("Configuration", this);
                    input.getValue().assertAccessible(input.getKey());
                    return true;
                }
                catch (AccessDeniedException e) {
                    return false;
                }
                catch (AuthenticationCredentialsNotFoundException e) {
                    return false;
                }
            }
        });
    }

    public final Template getTemplate(String name) {
        Template template = this.templates.get(name);
        if (template == null) {
            throw new IllegalArgumentException("Template '" + name + " does not exist.  Options are: " + this.templates.keySet());
        }
        this.accessAssertion.assertAccess("Configuration", this);
        template.assertAccessible(name);
        return template;
    }

    public final void setTemplates(Map<String, Template> templates) {
        this.templates = templates;
    }

    public final File getDirectory() {
        return this.configurationFile.getAbsoluteFile().getParentFile();
    }

    public final void setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public final void setStyles(Map<String, String> styles) {
        this.styles = styles;
    }

    public final Optional<? extends Style> getStyle(String styleName, MapfishMapContext mapContext) {
        String styleRef = this.styles.get(styleName);
        if (styleRef != null) {
            return this.styleParser.loadStyle(this, this.clientHttpRequestFactory, styleRef, mapContext);
        }
        return Optional.absent();
    }

    @Nonnull
    public final Style getDefaultStyle(@Nonnull String geometryType) {
        Style style;
        String normalizedGeomName = GEOMETRY_NAME_ALIASES.get(geometryType.toLowerCase());
        if (normalizedGeomName == null) {
            normalizedGeomName = geometryType.toLowerCase();
        }
        if ((style = this.defaultStyle.get(normalizedGeomName.toLowerCase())) == null) {
            PointSymbolizer symbolizer;
            StyleBuilder builder = new StyleBuilder();
            if (normalizedGeomName.equalsIgnoreCase(Point.class.getSimpleName())) {
                symbolizer = builder.createPointSymbolizer();
            } else if (normalizedGeomName.equalsIgnoreCase(LineString.class.getSimpleName())) {
                symbolizer = builder.createLineSymbolizer(Color.black, 2.0);
            } else if (normalizedGeomName.equalsIgnoreCase(Polygon.class.getSimpleName())) {
                symbolizer = builder.createPolygonSymbolizer(Color.lightGray, Color.black, 2.0);
            } else if (normalizedGeomName.equalsIgnoreCase("raster")) {
                symbolizer = builder.createRasterSymbolizer();
            } else {
                if (normalizedGeomName.equalsIgnoreCase("grid")) {
                    return this.createGridStyle(builder);
                }
                if (normalizedGeomName.equalsIgnoreCase("overview-map")) {
                    symbolizer = this.createMapOverviewStyle(builder);
                } else {
                    Style geomStyle = this.defaultStyle.get(Geometry.class.getSimpleName().toLowerCase());
                    if (geomStyle != null) {
                        return geomStyle;
                    }
                    symbolizer = builder.createPointSymbolizer();
                }
            }
            style = builder.createStyle((Symbolizer)symbolizer);
        }
        return style;
    }

    private Symbolizer createMapOverviewStyle(@Nonnull StyleBuilder builder) {
        Stroke stroke = builder.createStroke(Color.blue, 2.0);
        org.geotools.styling.Fill fill = builder.createFill(Color.blue, 0.2);
        return builder.createPolygonSymbolizer(stroke, fill);
    }

    private Style createGridStyle(StyleBuilder builder) {
        LineSymbolizer lineSymbolizer = builder.createLineSymbolizer();
        Color strokeColor = new Color(127, 127, 255);
        Color textColor = new Color(50, 50, 255);
        lineSymbolizer.setStroke((org.opengis.style.Stroke)builder.createStroke(strokeColor, 1.0, new float[]{4.0f, 4.0f}));
        Style style = builder.createStyle((Symbolizer)lineSymbolizer);
        List symbolizers = ((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers();
        symbolizers.add(0, this.createGridTextSymbolizer(builder, textColor));
        return style;
    }

    private TextSymbolizer createGridTextSymbolizer(StyleBuilder builder, Color color) {
        Expression xDisplacement = builder.attributeExpression("xDisplacement");
        Expression yDisplacement = builder.attributeExpression("yDisplacement");
        Displacement displacement = builder.createDisplacement(xDisplacement, yDisplacement);
        Expression rotation = builder.attributeExpression("rotation");
        PointPlacement text1Placement = builder.createPointPlacement(builder.createAnchorPoint(0.0, 0.0), displacement, rotation);
        TextSymbolizer text1 = builder.createTextSymbolizer();
        text1.setFill((Fill)builder.createFill(color));
        text1.setLabelPlacement((LabelPlacement)text1Placement);
        double opacity = 0.8;
        text1.setHalo((Halo)builder.createHalo(Color.white, 0.8, 2.0));
        text1.setLabel(builder.attributeExpression("label"));
        return text1;
    }

    public final void setDefaultStyle(Map<String, Style> defaultStyle) {
        this.defaultStyle = Maps.newHashMapWithExpectedSize((int)defaultStyle.size());
        for (Map.Entry<String, Style> entry : defaultStyle.entrySet()) {
            String normalizedName = GEOMETRY_NAME_ALIASES.get(entry.getKey().toLowerCase());
            if (normalizedName == null) {
                normalizedName = entry.getKey().toLowerCase();
            }
            this.defaultStyle.put(normalizedName, entry.getValue());
        }
    }

    public final boolean isThrowErrorOnExtraParameters() {
        return this.throwErrorOnExtraParameters;
    }

    public final void setThrowErrorOnExtraParameters(boolean throwErrorOnExtraParameters) {
        this.throwErrorOnExtraParameters = throwErrorOnExtraParameters;
    }

    public final List<Throwable> validate() {
        ArrayList validationErrors = Lists.newArrayList();
        this.accessAssertion.validate(validationErrors, this);
        if (this.configurationFile == null) {
            validationErrors.add(new ConfigurationException("Configuration file is field on configuration object is null"));
        }
        if (this.templates.isEmpty()) {
            validationErrors.add(new ConfigurationException("There are not templates defined."));
        }
        for (Template template : this.templates.values()) {
            template.validate(validationErrors, this);
        }
        for (HttpProxy proxy : this.proxies) {
            proxy.validate(validationErrors, this);
        }
        return validationErrors;
    }

    public final boolean isAccessible(String pathToSubResource) throws IOException {
        return this.fileLoaderManager.isAccessible(this.configurationFile.toURI(), pathToSubResource);
    }

    public final byte[] loadFile(String pathToSubResource) throws IOException {
        return this.fileLoaderManager.loadFile(this.configurationFile.toURI(), pathToSubResource);
    }

    public final void setFileLoaderManager(ConfigFileLoaderManager fileLoaderManager) {
        this.fileLoaderManager = fileLoaderManager;
    }

    public final void setAccess(ArrayList<String> access) {
        RoleAccessAssertion assertion = new RoleAccessAssertion();
        assertion.setRequiredRoles(access);
        this.accessAssertion = assertion;
    }

    public final AccessAssertion getAccessAssertion() {
        return this.accessAssertion;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Geometry.class.getSimpleName().toLowerCase(), Geometry.class.getSimpleName().toLowerCase());
        map.put("geom", Geometry.class.getSimpleName().toLowerCase());
        map.put("geometrycollection", Geometry.class.getSimpleName().toLowerCase());
        map.put("multigeometry", Geometry.class.getSimpleName().toLowerCase());
        map.put("line", LineString.class.getSimpleName().toLowerCase());
        map.put(LineString.class.getSimpleName().toLowerCase(), LineString.class.getSimpleName().toLowerCase());
        map.put("linearring", LineString.class.getSimpleName().toLowerCase());
        map.put("multilinestring", LineString.class.getSimpleName().toLowerCase());
        map.put("multiline", LineString.class.getSimpleName().toLowerCase());
        map.put("poly", Polygon.class.getSimpleName().toLowerCase());
        map.put(Polygon.class.getSimpleName().toLowerCase(), Polygon.class.getSimpleName().toLowerCase());
        map.put("multipolygon", Polygon.class.getSimpleName().toLowerCase());
        map.put(Point.class.getSimpleName().toLowerCase(), Point.class.getSimpleName().toLowerCase());
        map.put("multipoint", Point.class.getSimpleName().toLowerCase());
        map.put("overview-map", "overview-map");
        GEOMETRY_NAME_ALIASES = map;
    }
}

