/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.MfClientHttpRequestFactory;

public abstract class AbstractGeotoolsLayer
implements MapLayer {
    private final ExecutorService executorService;

    protected AbstractGeotoolsLayer(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public final Optional<MapLayer> tryAddLayer(MapLayer newLayer) {
        return Optional.absent();
    }

    @Override
    public final void render(Graphics2D graphics2D, MfClientHttpRequestFactory clientHttpRequestFactory, MapfishMapContext transformer, boolean isFirstLayer) {
        Rectangle paintArea = new Rectangle(transformer.getMapSize());
        MapBounds bounds = transformer.getBounds();
        MapfishMapContext layerTransformer = transformer;
        if (transformer.getRotation() != 0.0 && !this.supportsNativeRotation()) {
            paintArea = new Rectangle(transformer.getRotatedMapSize());
            bounds = transformer.getRotatedBounds();
            graphics2D.setTransform(transformer.getTransform());
            Dimension mapSize = new Dimension(paintArea.width, paintArea.height);
            layerTransformer = new MapfishMapContext(bounds, mapSize, transformer.getRotation(), transformer.getDPI(), transformer.getRequestorDPI(), transformer.isForceLongitudeFirst(), transformer.isDpiSensitiveStyle());
        }
        MapContent content = new MapContent();
        try {
            List<? extends Layer> layers = this.getLayers(clientHttpRequestFactory, layerTransformer, isFirstLayer);
            content.addLayers(layers);
            StreamingRenderer renderer = new StreamingRenderer();
            RenderingHints hints = new RenderingHints(Collections.emptyMap());
            hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE));
            hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
            hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
            hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
            graphics2D.addRenderingHints(hints);
            renderer.setJava2DHints(hints);
            HashMap renderHints = Maps.newHashMap();
            if (transformer.isForceLongitudeFirst() != null) {
                renderHints.put("ForceEPSGAxisOrder", transformer.isForceLongitudeFirst());
            }
            renderer.setRendererHints((Map)renderHints);
            renderer.setMapContent(content);
            renderer.setThreadPool(this.executorService);
            ReferencedEnvelope mapArea = bounds.toReferencedEnvelope(paintArea, transformer.getDPI());
            renderer.paint(graphics2D, paintArea, mapArea);
        }
        catch (Exception e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
        finally {
            content.dispose();
        }
    }

    protected abstract List<? extends Layer> getLayers(MfClientHttpRequestFactory var1, MapfishMapContext var2, boolean var3) throws Exception;

    @Override
    public boolean supportsNativeRotation() {
        return false;
    }
}

