/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.vividsolutions.jts.util.Assert;
import java.util.Arrays;
import org.mapfish.print.map.geotools.grid.GridLayer;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.OneOf;
import org.mapfish.print.parser.Requires;

public final class GridParam {
    private static final int DEFAULT_POINTS_IN_GRID_LINE = 10000;
    @OneOf(value="spacing")
    @Requires(value={"origin"})
    public double[] spacing;
    @HasDefaultValue
    public double[] origin;
    @OneOf(value="spacing")
    public int[] numberOfLines;
    @HasDefaultValue
    public String style;
    @HasDefaultValue
    public Boolean renderAsSvg = false;
    @HasDefaultValue
    public int pointsInLine = 10000;

    public void postConstruct() {
        Assert.isTrue((this.spacing == null || this.spacing.length == 2 ? 1 : 0) != 0, (String)(GridLayer.class.getSimpleName() + ".spacing has the wrong number of elements.  Expected 2 (x,y) but was: " + Arrays.toString(this.spacing)));
        Assert.isTrue((this.numberOfLines == null || this.numberOfLines.length == 2 ? 1 : 0) != 0, (String)(GridLayer.class.getSimpleName() + ".numberOfLines has the wrong number of elements.  Expected 2 (x,y) but was: " + Arrays.toString(this.numberOfLines)));
        Assert.isTrue((this.pointsInLine > 2 ? 1 : 0) != 0, (String)("There must be at least 2 points in a line.  There were: " + this.pointsInLine));
        if (this.style == null) {
            this.style = "grid";
        }
    }
}

