/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.google.common.io.Closer;
import com.vividsolutions.jts.util.Assert;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.imageio.ImageIO;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.AbstractSingleImageLayer;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.map.image.wms.WmsUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public final class WmsLayer
extends AbstractSingleImageLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmsLayer.class);
    private final WmsLayerParam params;

    protected WmsLayer(ExecutorService executorService, StyleSupplier<GridCoverage2D> styleSupplier, WmsLayerParam params) {
        super(executorService, styleSupplier);
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BufferedImage loadImage(MfClientHttpRequestFactory requestFactory, MapfishMapContext transformer, boolean isFirstLayer) throws Throwable {
        WmsLayerParam wmsLayerParam = this.params;
        URI commonUri = new URI(wmsLayerParam.getBaseUrl());
        Rectangle paintArea = transformer.getPaintArea();
        ReferencedEnvelope envelope = transformer.getBounds().toReferencedEnvelope(paintArea, transformer.getDPI());
        URI uri = WmsUtilities.makeWmsGetLayerRequest(requestFactory, wmsLayerParam, commonUri, paintArea.getSize(), envelope);
        Closer closer = Closer.create();
        try {
            ClientHttpResponse response = (ClientHttpResponse)closer.register((Closeable)requestFactory.createRequest(uri, HttpMethod.GET).execute());
            Assert.equals((Object)HttpStatus.OK, (Object)response.getStatusCode(), (String)("Http status code for " + uri + " was not OK.  It was: " + response.getStatusCode() + ".  The response message was: '" + response.getStatusText() + "'"));
            BufferedImage image = ImageIO.read(response.getBody());
            if (image == null) {
                LOGGER.warn("The URI: " + uri + " is an image format that can be decoded");
                BufferedImage bufferedImage = this.createErrorImage(paintArea);
                return bufferedImage;
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            closer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createErrorImage(Rectangle area) {
        BufferedImage bufferedImage = new BufferedImage(area.width, area.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        try {
            graphics.setBackground(new Color(255, 255, 255, 125));
            graphics.clearRect(0, 0, area.width, area.height);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            graphics.dispose();
        }
    }

    public WmsLayerParam getParams() {
        return this.params;
    }

    @Override
    public boolean supportsNativeRotation() {
        return this.params.getCustomParams().containsKey((Object)"angle") || this.params.getMergeableParams().containsKey((Object)"angle");
    }
}

