/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.mapfish.print.URIUtils;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.map.image.wms.WmsVersion;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;

public final class WmsUtilities {
    private WmsUtilities() {
    }

    public static URI makeWmsGetLayerRequest(MfClientHttpRequestFactory requestFactory, WmsLayerParam wmsLayerParam, URI commonURI, Dimension imageSize, ReferencedEnvelope bounds) throws FactoryException, URISyntaxException, IOException {
        GetMapRequest getMapRequest = WmsVersion.lookup(wmsLayerParam.version).getGetMapRequest(commonURI.toURL());
        getMapRequest.setBBox((Envelope)bounds);
        getMapRequest.setDimensions(imageSize.width, imageSize.height);
        getMapRequest.setFormat(wmsLayerParam.imageFormat);
        getMapRequest.setSRS(CRS.lookupIdentifier((IdentifiedObject)bounds.getCoordinateReferenceSystem(), (boolean)false));
        for (int i = 0; i < wmsLayerParam.layers.length; ++i) {
            String layer = wmsLayerParam.layers[i];
            String style = "";
            if (wmsLayerParam.styles != null) {
                style = wmsLayerParam.styles[i];
            }
            getMapRequest.addLayer(layer, style);
        }
        URI getMapUri = getMapRequest.getFinalURL().toURI();
        HashMultimap extraParams = HashMultimap.create();
        extraParams.putAll(wmsLayerParam.getMergeableParams());
        extraParams.putAll(wmsLayerParam.getCustomParams());
        return URIUtils.addParams(getMapUri, (Multimap<String, String>)extraParams, Collections.<String>emptySet());
    }
}

