/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.Scale;
import org.mapfish.print.map.tiled.AbstractTiledLayerParams;
import org.springframework.http.client.ClientHttpRequest;

public abstract class TileCacheInformation {
    protected final MapBounds bounds;
    protected final Rectangle paintArea;
    protected final double dpi;
    private final AbstractTiledLayerParams params;

    public TileCacheInformation(MapBounds bounds, Rectangle paintArea, double dpi, AbstractTiledLayerParams params) {
        this.bounds = bounds;
        this.paintArea = paintArea;
        this.dpi = dpi;
        this.params = params;
    }

    @Nonnull
    public abstract ClientHttpRequest getTileRequest(MfClientHttpRequestFactory var1, String var2, ReferencedEnvelope var3, Dimension var4, int var5, int var6) throws Exception;

    protected abstract void customizeQueryParams(Multimap<String, String> var1);

    public abstract Scale getScale();

    public abstract Double getLayerDpi();

    public abstract Dimension getTileSize();

    @Nonnull
    protected abstract ReferencedEnvelope getTileCacheBounds();

    @Nonnull
    public Coordinate getMinGeoCoordinate(ReferencedEnvelope envelope, Coordinate geoTileSize) {
        ReferencedEnvelope tileCacheBounds = this.getTileCacheBounds();
        double tileCacheMinX = tileCacheBounds.getMinX();
        double minGeoX = envelope.getMinX();
        double minGeoY = envelope.getMinY();
        double tileMinGeoX = tileCacheMinX + Math.floor((minGeoX - tileCacheMinX) / geoTileSize.x) * geoTileSize.x;
        double tileCacheMinY = tileCacheBounds.getMinY();
        double tileMinGeoY = tileCacheMinY + Math.floor((minGeoY - tileCacheMinY) / geoTileSize.y) * geoTileSize.y;
        return new Coordinate(tileMinGeoX, tileMinGeoY);
    }

    @Nonnull
    public BufferedImage createBufferedImage(int imageWidth, int imageHeight) {
        return new BufferedImage(imageWidth, imageHeight, 6);
    }

    protected String createCommonUrl() throws URISyntaxException, UnsupportedEncodingException {
        return this.params.createCommonUrl(new Function<Multimap<String, String>, Multimap<String, String>>(){

            @Nullable
            public Multimap<String, String> apply(@Nullable Multimap<String, String> input) {
                TileCacheInformation.this.customizeQueryParams(input);
                return input;
            }
        });
    }

    @Nullable
    public BufferedImage getMissingTileImage() {
        return null;
    }
}

