/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.osm;

import com.google.common.collect.Multimap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import jsr166y.ForkJoinPool;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.Scale;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.tiled.AbstractTiledLayer;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.osm.OsmLayerParam;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class OsmLayer
extends AbstractTiledLayer {
    private final OsmLayerParam param;

    public OsmLayer(ForkJoinPool forkJoinPool, StyleSupplier<GridCoverage2D> styleSupplier, OsmLayerParam param) {
        super(forkJoinPool, styleSupplier);
        this.param = param;
    }

    @Override
    protected TileCacheInformation createTileInformation(MapBounds bounds, Rectangle paintArea, double dpi, boolean isFirstLayer) {
        return new OsmTileCacheInformation(bounds, paintArea, dpi, isFirstLayer);
    }

    private final class OsmTileCacheInformation
    extends TileCacheInformation {
        private final Scale scale;
        private final int resolutionIndex;

        public OsmTileCacheInformation(MapBounds bounds, Rectangle paintArea, double dpi, boolean isFirstLayer) {
            super(bounds, paintArea, dpi, OsmLayer.this.param);
            double targetResolution = bounds.getScaleDenominator(paintArea, dpi).toResolution(bounds.getProjection(), dpi);
            Double[] resolutions = ((OsmLayer)OsmLayer.this).param.resolutions;
            int pos = resolutions.length - 1;
            double result = resolutions[pos];
            for (int i = resolutions.length - 1; i >= 0; --i) {
                double cur = resolutions[i];
                if (!(cur <= targetResolution * ((OsmLayer)OsmLayer.this).param.resolutionTolerance)) continue;
                result = cur;
                pos = i;
            }
            this.scale = Scale.fromResolution(result, bounds.getProjection(), dpi);
            this.resolutionIndex = pos;
        }

        @Override
        @Nonnull
        public ClientHttpRequest getTileRequest(MfClientHttpRequestFactory httpRequestFactory, String commonUrl, ReferencedEnvelope tileBounds, Dimension tileSizeOnScreen, int column, int row) throws IOException, URISyntaxException {
            URI uri;
            if (commonUrl.contains("{x}") && commonUrl.contains("{z}") && (commonUrl.contains("{y}") || commonUrl.contains("{-y}"))) {
                String url = commonUrl.replace("{z}", String.format("%02d", this.resolutionIndex)).replace("{x}", Integer.toString(column)).replace("{y}", Integer.toString(row));
                if (commonUrl.contains("{-y}")) {
                    url = url.replace("{-y}", Integer.toString((int)Math.pow(2.0, this.resolutionIndex) - 1 - row));
                }
                uri = new URI(url);
            } else {
                StringBuilder path = new StringBuilder();
                if (!commonUrl.endsWith("/")) {
                    path.append('/');
                }
                path.append(String.format("%02d", this.resolutionIndex));
                path.append('/').append(column);
                path.append('/').append(row);
                path.append('.').append(((OsmLayer)OsmLayer.this).param.imageFormat);
                uri = new URI(commonUrl + path.toString());
            }
            return httpRequestFactory.createRequest(uri, HttpMethod.GET);
        }

        @Override
        protected void customizeQueryParams(Multimap<String, String> result) {
        }

        @Override
        public Scale getScale() {
            return this.scale;
        }

        @Override
        public Double getLayerDpi() {
            return ((OsmLayer)OsmLayer.this).param.dpi;
        }

        @Override
        public Dimension getTileSize() {
            return OsmLayer.this.param.getTileSize();
        }

        @Override
        @Nonnull
        protected ReferencedEnvelope getTileCacheBounds() {
            return new ReferencedEnvelope(OsmLayer.this.param.getMaxExtent(), this.bounds.getProjection());
        }
    }
}

