/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.wmts;

import com.google.common.collect.Multimap;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import jsr166y.ForkJoinPool;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.URIUtils;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.Scale;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.tiled.AbstractTiledLayer;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.wmts.Matrix;
import org.mapfish.print.map.tiled.wmts.RequestEncoding;
import org.mapfish.print.map.tiled.wmts.WMTSLayerParam;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public class WMTSLayer
extends AbstractTiledLayer {
    private final WMTSLayerParam param;

    protected WMTSLayer(ForkJoinPool executorService, StyleSupplier<GridCoverage2D> styleSupplier, WMTSLayerParam param) {
        super(executorService, styleSupplier);
        this.param = param;
    }

    @Override
    protected final TileCacheInformation createTileInformation(MapBounds bounds, Rectangle paintArea, double dpi, boolean isFirstLayer) {
        return new WMTSTileCacheInfo(bounds, paintArea, dpi);
    }

    private final class WMTSTileCacheInfo
    extends TileCacheInformation {
        private Matrix matrix;

        public WMTSTileCacheInfo(MapBounds bounds, Rectangle paintArea, double dpi) {
            super(bounds, paintArea, dpi, WMTSLayer.this.param);
            double diff = Double.POSITIVE_INFINITY;
            double targetScale = bounds.getScaleDenominator(paintArea, dpi).getDenominator();
            for (Matrix m : ((WMTSLayer)WMTSLayer.this).param.matrices) {
                double delta = Math.abs(m.scaleDenominator - targetScale);
                if (!(delta < diff)) continue;
                diff = delta;
                this.matrix = m;
            }
            if (this.matrix == null) {
                throw new IllegalArgumentException("Unable to find a matrix that at the scale: " + targetScale);
            }
        }

        @Override
        @Nonnull
        public Dimension getTileSize() {
            int width = this.matrix.getTileWidth();
            int height = this.matrix.getTileHeight();
            return new Dimension(width, height);
        }

        @Override
        @Nonnull
        protected ReferencedEnvelope getTileCacheBounds() {
            double scaleDenominator = new Scale(this.matrix.scaleDenominator).toResolution(this.bounds.getProjection(), this.getLayerDpi());
            double minX = this.matrix.topLeftCorner[0];
            double minY = this.matrix.topLeftCorner[1] - (double)(this.matrix.getTileHeight() * this.matrix.matrixSize[1]) * scaleDenominator;
            double maxX = this.matrix.topLeftCorner[0] + (double)(this.matrix.getTileWidth() * this.matrix.matrixSize[0]) * scaleDenominator;
            double maxY = this.matrix.topLeftCorner[1];
            return new ReferencedEnvelope(minX, maxX, minY, maxY, this.bounds.getProjection());
        }

        @Override
        @Nonnull
        public ClientHttpRequest getTileRequest(MfClientHttpRequestFactory httpRequestFactory, String commonUrl, ReferencedEnvelope tileBounds, Dimension tileSizeOnScreen, int column, int row) throws URISyntaxException, IOException {
            URI commonUri = new URI(commonUrl);
            WMTSLayerParam layerParam = WMTSLayer.this.param;
            URI uri = RequestEncoding.REST == layerParam.requestEncoding ? this.createRestURI(commonUri, row, column, layerParam) : this.createKVPUri(commonUri, row, column, layerParam);
            return httpRequestFactory.createRequest(uri, HttpMethod.GET);
        }

        private URI createKVPUri(URI commonURI, int row, int col, WMTSLayerParam layerParam) throws URISyntaxException {
            Multimap<String, String> queryParams = URIUtils.getParameters(commonURI);
            queryParams.put((Object)"SERVICE", (Object)"WMTS");
            queryParams.put((Object)"REQUEST", (Object)"GetTile");
            queryParams.put((Object)"VERSION", (Object)layerParam.version);
            queryParams.put((Object)"LAYER", (Object)layerParam.layer);
            queryParams.put((Object)"STYLE", (Object)layerParam.style);
            queryParams.put((Object)"TILEMATRIXSET", (Object)layerParam.matrixSet);
            queryParams.put((Object)"TILEMATRIX", (Object)this.matrix.identifier);
            queryParams.put((Object)"TILEROW", (Object)String.valueOf(row));
            queryParams.put((Object)"TILECOL", (Object)String.valueOf(col));
            queryParams.put((Object)"FORMAT", (Object)("image/" + layerParam.imageFormat));
            if (layerParam.dimensions != null) {
                for (int i = 0; i < layerParam.dimensions.length; ++i) {
                    String d = layerParam.dimensions[i];
                    String dimensionValue = layerParam.dimensionParams.getString(d.toUpperCase());
                    queryParams.put((Object)d, (Object)dimensionValue);
                }
            }
            URI uri = URIUtils.setQueryParams(commonURI, queryParams);
            return uri;
        }

        private URI createRestURI(URI commonURI, int row, int col, WMTSLayerParam layerParam) throws URISyntaxException {
            String path = layerParam.baseURL;
            for (int i = 0; i < layerParam.dimensions.length; ++i) {
                String dimension = layerParam.dimensions[i];
                String value = layerParam.dimensionParams.getString(dimension.toUpperCase());
                path = path.replace("{" + dimension + "}", value);
            }
            path = path.replace("{TileMatrixSet}", layerParam.matrixSet);
            path = path.replace("{TileMatrix}", this.matrix.identifier);
            path = path.replace("{TileRow}", String.valueOf(row));
            path = path.replace("{TileCol}", String.valueOf(col));
            URI uri = URIUtils.setPath(commonURI, path);
            return uri;
        }

        @Override
        protected void customizeQueryParams(Multimap<String, String> result) {
        }

        @Override
        public Scale getScale() {
            return new Scale(this.matrix.scaleDenominator);
        }

        @Override
        public Double getLayerDpi() {
            return ((WMTSLayer)WMTSLayer.this).param.dpi;
        }
    }
}

