/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import org.mapfish.print.output.AbstractJasperReportOutputFormat;
import org.mapfish.print.output.OutputFormat;

public final class JasperReportImageOutputFormat
extends AbstractJasperReportOutputFormat
implements OutputFormat {
    private int imageType = 2;
    private String fileSuffix;

    @Override
    public String getContentType() {
        return "image/" + this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    @Override
    public String getFileSuffix() {
        return this.fileSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExport(OutputStream outputStream, AbstractJasperReportOutputFormat.Print print) throws JRException, IOException {
        JasperPrint jasperPrint = print.print;
        int numPages = jasperPrint.getPages().size();
        double dpiRatio = print.dpi / print.requestorDpi;
        int pageHeightOnImage = (int)((double)(jasperPrint.getPageHeight() + 1) * dpiRatio);
        int pageWidthOnImage = (int)((double)(jasperPrint.getPageWidth() + 1) * dpiRatio);
        BufferedImage pageImage = new BufferedImage(pageWidthOnImage, numPages * pageHeightOnImage, this.imageType);
        Graphics2D graphics2D = pageImage.createGraphics();
        graphics2D.scale(dpiRatio, dpiRatio);
        try {
            JRGraphics2DExporter exporter = new JRGraphics2DExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)graphics2D);
            for (int pageIndex = 0; pageIndex < numPages; ++pageIndex) {
                exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pageIndex);
                exporter.exportReport();
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(0, pageHeightOnImage, pageWidthOnImage, pageHeightOnImage);
                graphics2D.translate(0, pageHeightOnImage);
            }
        }
        finally {
            graphics2D.dispose();
        }
        ImageIO.write((RenderedImage)pageImage, this.getFileSuffix(), outputStream);
    }

    public void setImageType(int imageType) {
        this.imageType = imageType;
    }
}

