/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.google.common.base.Strings;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.output.Values;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.Processor;

public final class ProcessorUtils {
    private ProcessorUtils() {
    }

    public static <In, Out> In populateInputParameter(Processor<In, Out> processor, Values values) {
        In inputObject = processor.createInputParameter();
        if (inputObject instanceof Values) {
            Values castValues = values;
            return (In)castValues;
        }
        if (inputObject != null) {
            Object inputMapper = processor.getInputMapperBiMap();
            inputMapper = inputMapper == null ? Collections.emptyMap() : processor.getInputMapperBiMap().inverse();
            Collection<Field> fields = ParserUtils.getAllAttributes(inputObject.getClass());
            for (Field field : fields) {
                Object value;
                String name = (String)inputMapper.get(field.getName());
                if (name == null) {
                    name = field.getName();
                }
                if ((value = field.getType() == Values.class ? values : values.getObject(name, Object.class)) != null) {
                    try {
                        field.set(inputObject, value);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw ExceptionUtils.getRuntimeException(e);
                    }
                }
                if (field.getAnnotation(HasDefaultValue.class) != null) continue;
                throw new NoSuchElementException(name + " is a required property for " + processor + " and therefore must be defined in the Request Data or be an output of one" + " of the other processors.");
            }
        }
        return inputObject;
    }

    public static void writeProcessorOutputToValues(Object output, Processor<?, ?> processor, Values values) {
        Object mapper = processor.getOutputMapperBiMap();
        if (mapper == null) {
            mapper = Collections.emptyMap();
        }
        Collection<Field> fields = ParserUtils.getAllAttributes(output.getClass());
        for (Field field : fields) {
            String name = ProcessorUtils.getOutputValueName(processor.getOutputPrefix(), mapper, field);
            try {
                Object value = field.get(output);
                if (value != null) {
                    values.put(name, value);
                    continue;
                }
                values.remove(name);
            }
            catch (IllegalAccessException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
        }
    }

    public static String getOutputValueName(@Nullable String outputPrefix, @Nonnull Map<String, String> outputMapper, @Nonnull Field field) {
        String name = outputMapper.get(field.getName());
        if (name == null) {
            name = field.getName();
            if (!Strings.isNullOrEmpty((String)outputPrefix) && !outputPrefix.trim().isEmpty()) {
                name = outputPrefix.trim() + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            }
        }
        return name;
    }
}

