/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.AbstractMfClientHttpRequestFactoryWrapper;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.http.AbstractClientHttpRequestFactoryProcessor;
import org.mapfish.print.processor.http.ClientHttpFactoryProcessorParam;
import org.mapfish.print.processor.http.matcher.AcceptAllMatcher;
import org.mapfish.print.processor.http.matcher.HostMatcher;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.mapfish.print.processor.http.matcher.URIMatcher;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class RestrictUrisProcessor
extends AbstractClientHttpRequestFactoryProcessor {
    private List<? extends URIMatcher> matchers = Collections.singletonList(new AcceptAllMatcher());

    public void setMatchers(List<? extends HostMatcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.matchers == null) {
            validationErrors.add(new IllegalArgumentException("Matchers cannot be null.  There should be at least a !acceptAll matcher"));
        }
        if (this.matchers != null && this.matchers.isEmpty()) {
            validationErrors.add(new IllegalArgumentException("There are no url matchers defined.  There should be at least a !acceptAll matcher"));
        }
    }

    @Override
    public MfClientHttpRequestFactory createFactoryWrapper(ClientHttpFactoryProcessorParam clientHttpFactoryProcessorParam, MfClientHttpRequestFactory requestFactory) {
        return new AbstractMfClientHttpRequestFactoryWrapper(requestFactory){

            @Override
            protected ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod, MfClientHttpRequestFactory requestFactory) throws IOException {
                for (URIMatcher matcher : RestrictUrisProcessor.this.matchers) {
                    if (!matcher.accepts(MatchInfo.fromUri(uri, httpMethod))) continue;
                    return requestFactory.createRequest(uri, httpMethod);
                }
                throw new IllegalArgumentException(uri + " is not one of the permitted urls.");
            }
        };
    }
}

