/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.processor.http.matcher.AddressHostMatcher;
import org.mapfish.print.processor.http.matcher.HostMatcher;
import org.mapfish.print.processor.http.matcher.MatchInfo;

public class DnsHostMatcher
extends HostMatcher {
    private List<AddressHostMatcher> matchersForHost = Lists.newArrayList();
    private String host;

    @Override
    public final Optional<Boolean> tryOverrideValidation(MatchInfo matchInfo) throws SocketException, UnknownHostException, MalformedURLException {
        for (AddressHostMatcher addressHostMatcher : this.matchersForHost) {
            if (!addressHostMatcher.accepts(matchInfo)) continue;
            return Optional.absent();
        }
        return Optional.of((Object)false);
    }

    @Override
    public final void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.host == null) {
            validationErrors.add(new ConfigurationException("No host defined: " + this.getClass().getName()));
        }
    }

    public final void setHost(String host) throws UnknownHostException {
        InetAddress[] inetAddresses;
        this.host = host;
        for (InetAddress address : inetAddresses = InetAddress.getAllByName(host)) {
            AddressHostMatcher matcher = new AddressHostMatcher();
            matcher.setIp(address.getHostAddress());
            this.matchersForHost.add(matcher);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DnsHostMatcher");
        sb.append("{host='").append(this.host).append('\'');
        if (this.port >= 0) {
            sb.append(", port=").append(this.port);
        }
        if (this.pathRegex != null) {
            sb.append(", pathRegexp=").append(this.pathRegex);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsHostMatcher other = (DnsHostMatcher)obj;
        return !(this.host == null ? other.host != null : !this.host.equals(other.host));
    }
}

