/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.mapfish.print.processor.http.matcher.HostMatcher;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InetHostMatcher
extends HostMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(InetHostMatcher.class);
    protected byte[][] authorizedIPs = null;

    @Override
    protected final Optional<Boolean> tryOverrideValidation(MatchInfo matchInfo) throws UnknownHostException, SocketException {
        InetAddress[] requestedIPs;
        String host = matchInfo.getHost();
        if (host == MatchInfo.ANY_HOST) {
            return Optional.absent();
        }
        InetAddress maskAddress = this.getMaskAddress();
        try {
            requestedIPs = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException ex) {
            return Optional.of((Object)false);
        }
        for (InetAddress requestedIP : requestedIPs) {
            if (!this.isInAuthorized(requestedIP, maskAddress)) continue;
            return Optional.absent();
        }
        return Optional.of((Object)false);
    }

    private boolean isInAuthorized(InetAddress requestedIP, InetAddress mask) throws UnknownHostException, SocketException {
        byte[][] finalAuthorizedIPs;
        byte[] rBytes = this.mask(requestedIP, mask);
        for (byte[] authorizedIP : finalAuthorizedIPs = this.getAuthorizedIPs(mask)) {
            if (!this.compareIP(rBytes, authorizedIP)) continue;
            return true;
        }
        LOGGER.debug("Address not in the authorized set: " + requestedIP);
        return false;
    }

    private boolean compareIP(byte[] rBytes, byte[] authorizedIP) {
        if (rBytes.length != authorizedIP.length) {
            return false;
        }
        for (int j = 0; j < authorizedIP.length; ++j) {
            byte bA = authorizedIP[j];
            byte bR = rBytes[j];
            if (bA == bR) continue;
            return false;
        }
        return true;
    }

    private byte[] mask(InetAddress address, InetAddress mask) {
        byte[] aBytes = address.getAddress();
        if (mask != null) {
            byte[] mBytes = mask.getAddress();
            if (aBytes.length != mBytes.length) {
                LOGGER.warn("Cannot mask address [" + address + "] with :" + mask);
                return aBytes;
            }
            byte[] result = new byte[aBytes.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)(aBytes[i] & mBytes[i]);
            }
            return result;
        }
        return aBytes;
    }

    protected abstract InetAddress getMaskAddress() throws UnknownHostException;

    protected final byte[][] buildMaskedAuthorizedIPs(InetAddress[] ips) throws UnknownHostException {
        InetAddress maskAddress = this.getMaskAddress();
        byte[][] tmpAuthorizedIPs = new byte[ips.length][];
        for (int i = 0; i < ips.length; ++i) {
            tmpAuthorizedIPs[i] = this.mask(ips[i], maskAddress);
        }
        return tmpAuthorizedIPs;
    }

    protected abstract byte[][] getAuthorizedIPs(InetAddress var1) throws UnknownHostException, SocketException;

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode((Object[])this.authorizedIPs);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetHostMatcher other = (InetHostMatcher)obj;
        return Arrays.equals((Object[])this.authorizedIPs, (Object[])other.authorizedIPs);
    }
}

