/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jsr166y.ForkJoinTask;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.DataSourceAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.Template;
import org.mapfish.print.output.Values;
import org.mapfish.print.parser.MapfishParser;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.ProcessorDependencyGraphFactory;
import org.mapfish.print.processor.jasper.JasperReportBuilder;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.springframework.beans.factory.annotation.Autowired;

public final class DataSourceProcessor
extends AbstractProcessor<Input, Output> {
    private Map<String, Attribute> attributes = Maps.newHashMap();
    @Autowired
    private ProcessorDependencyGraphFactory processorGraphFactory;
    private ProcessorDependencyGraph processorGraph;
    @Autowired
    private MapfishParser parser;
    @Autowired
    private JasperReportBuilder jasperReportBuilder;
    private String reportTemplate;
    private String reportKey;

    public DataSourceProcessor() {
        super(Output.class);
    }

    public void setReportTemplate(String reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    public void setProcessors(List<Processor> processors) {
        this.processorGraph = this.processorGraphFactory.build(processors);
    }

    public void setAttributes(Map<String, Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    @Nullable
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    @Nullable
    public Output execute(Input input, Processor.ExecutionContext context) throws Exception {
        JRDataSource jrDataSource = this.processInput(input);
        if (jrDataSource == null) {
            jrDataSource = new JREmptyDataSource();
        }
        return new Output(jrDataSource);
    }

    private JRDataSource processInput(@Nonnull Input input) throws JSONException, JRException {
        ArrayList dataSourceValues = Lists.newArrayList();
        for (Map<String, Object> o : input.datasource.attributesValues) {
            Values rowValues = new Values(input.values);
            for (Map.Entry<String, Object> entry : o.entrySet()) {
                rowValues.put(entry.getKey(), entry.getValue());
            }
            dataSourceValues.add(rowValues);
        }
        ArrayList futures = Lists.newArrayList();
        if (!dataSourceValues.isEmpty()) {
            File reportFile;
            for (Values dataSourceValue : dataSourceValues) {
                this.addAttributes(input.template, dataSourceValue);
                ForkJoinTask taskFuture = this.processorGraph.createTask(dataSourceValue).fork();
                futures.add(taskFuture);
            }
            if (this.reportTemplate != null) {
                Configuration configuration = input.template.getConfiguration();
                File file = new File(configuration.getDirectory(), this.reportTemplate);
                reportFile = this.jasperReportBuilder.compileJasperReport(configuration, file);
            } else {
                reportFile = null;
            }
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            for (ForkJoinTask future : futures) {
                Values rowData = (Values)future.join();
                if (reportFile != null) {
                    rowData.put(this.reportKey, reportFile.getAbsolutePath());
                }
                rows.add(rowData.asMap());
            }
            return new JRMapCollectionDataSource(rows);
        }
        return null;
    }

    private void addAttributes(@Nonnull Template template, @Nonnull Values dataSourceValue) throws JSONException {
        dataSourceValue.populateFromAttributes(template, this.parser, this.attributes, new PJsonObject(new JSONObject(), "DataSourceProcessorAttributes"));
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.processorGraph == null || this.processorGraph.getAllProcessors().isEmpty()) {
            validationErrors.add(new ConfigurationException("There are child processors for this processor"));
        }
        if (this.reportTemplate != null && this.reportKey == null || this.reportTemplate == null && this.reportKey != null) {
            validationErrors.add(new ConfigurationException("'reportKey' and 'reportTemplate' must either both be null or both be non-null.  reportKey: " + this.reportKey + " reportTemplate: " + this.reportTemplate));
        }
        for (Attribute attribute : this.attributes.values()) {
            attribute.validate(validationErrors, configuration);
        }
    }

    public static final class Output {
        public final JRDataSource jrDataSource;

        public Output(@Nonnull JRDataSource datasource) {
            this.jrDataSource = datasource;
        }
    }

    public static final class Input {
        @InternalValue
        public Template template;
        @InternalValue
        public Values values;
        public DataSourceAttribute.DataSourceAttributeValue datasource;
    }
}

