/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.google.common.io.Closer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.mapfish.print.attribute.LegendAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.JasperReportBuilder;
import org.mapfish.print.processor.jasper.TableDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class LegendProcessor
extends AbstractProcessor<Input, Output> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegendProcessor.class);
    private static final String NAME_COLUMN = "name";
    private static final String ICON_COLUMN = "icon";
    private static final String LEVEL_COLUMN = "level";
    @Autowired
    private JasperReportBuilder jasperReportBuilder;
    private Dimension missingImageSize = new Dimension(24, 24);
    private BufferedImage missingImage;
    private Color missingImageColor = Color.PINK;
    private String template;

    protected LegendProcessor() {
        super(Output.class);
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    public Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        ArrayList<Object[]> legendList = new ArrayList<Object[]>();
        String[] legendColumns = new String[]{NAME_COLUMN, ICON_COLUMN, LEVEL_COLUMN};
        LegendAttribute.LegendAttributeValue legendAttributes = values.legend;
        this.fillLegend(values.clientHttpRequestFactory, legendAttributes, legendList, 0, context);
        Object[][] legend = new Object[legendList.size()][];
        JRTableModelDataSource dataSource = new JRTableModelDataSource((TableModel)new TableDataSource(legendColumns, (Object[][])legendList.toArray((T[])legend)));
        String compiledTemplatePath = this.compileTemplate(values.template.getConfiguration());
        return new Output(dataSource, legendList.size(), compiledTemplatePath);
    }

    private String compileTemplate(Configuration configuration) throws JRException {
        if (this.template != null) {
            File file = new File(configuration.getDirectory(), this.template);
            return this.jasperReportBuilder.compileJasperReport(configuration, file).getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillLegend(MfClientHttpRequestFactory clientHttpRequestFactory, LegendAttribute.LegendAttributeValue legendAttributes, List<Object[]> legendList, int level, Processor.ExecutionContext context) throws IOException, URISyntaxException {
        Object[] row = new Object[]{legendAttributes.name, null, level};
        legendList.add(row);
        URL[] icons = legendAttributes.icons;
        if (icons != null) {
            for (URL icon : icons) {
                BufferedImage image = null;
                Closer closer = Closer.create();
                try {
                    this.checkCancelState(context);
                    ClientHttpRequest request = clientHttpRequestFactory.createRequest(icon.toURI(), HttpMethod.GET);
                    ClientHttpResponse httpResponse = (ClientHttpResponse)closer.register((Closeable)request.execute());
                    if (httpResponse.getStatusCode() == HttpStatus.OK) {
                        image = ImageIO.read(httpResponse.getBody());
                        if (image == null) {
                            LOGGER.warn("The URL: " + icon + " is NOT an image format that can be decoded");
                        }
                    } else {
                        LOGGER.warn("Failed to load image from: " + icon + " due to server side error.\n\tResponse Code: " + httpResponse.getStatusCode() + "\n\tResponse Text: " + httpResponse.getStatusText());
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load image from: " + icon, (Throwable)e);
                }
                finally {
                    closer.close();
                }
                if (image == null) {
                    image = this.getMissingImage();
                }
                Object[] iconRow = new Object[]{null, image, level};
                legendList.add(iconRow);
            }
        }
        if (legendAttributes.classes != null) {
            for (LegendAttribute.LegendAttributeValue value : legendAttributes.classes) {
                this.fillLegend(clientHttpRequestFactory, value, legendList, level + 1, context);
            }
        }
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized BufferedImage getMissingImage() {
        if (this.missingImage == null) {
            this.missingImage = new BufferedImage(this.missingImageSize.width, this.missingImageSize.height, 1);
            Graphics2D graphics = this.missingImage.createGraphics();
            try {
                graphics.setBackground(this.missingImageColor);
                graphics.clearRect(0, 0, this.missingImageSize.width, this.missingImageSize.height);
            }
            finally {
                graphics.dispose();
            }
        }
        return this.missingImage;
    }

    public static final class Output {
        public final JRTableModelDataSource legend;
        public final String legendSubReport;
        public final int numberOfLegendRows;

        Output(JRTableModelDataSource legend, int numberOfLegendRows, String legendSubReport) {
            this.legend = legend;
            this.numberOfLegendRows = numberOfLegendRows;
            this.legendSubReport = legendSubReport;
        }
    }

    public static final class Input {
        @InternalValue
        public Template template;
        @InternalValue
        public MfClientHttpRequestFactory clientHttpRequestFactory;
        public LegendAttribute.LegendAttributeValue legend;
    }
}

