/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import org.mapfish.print.attribute.ScalebarAttribute;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.MapSubReport;
import org.mapfish.print.processor.map.scalebar.ScalebarGraphic;

public class CreateScalebarProcessor
extends AbstractProcessor<Input, Output> {
    protected CreateScalebarProcessor() {
        super(Output.class);
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    @Override
    public final Input createInputParameter() {
        return new Input();
    }

    @Override
    public final Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        this.checkCancelState(context);
        URI scalebarGraphicFile = this.createScalebarGraphic(values);
        this.checkCancelState(context);
        URI scalebarSubReport = this.createScalebarSubReport(values.tempTaskDirectory, values.scalebar.getSize(), Lists.newArrayList((Object[])new URI[]{scalebarGraphicFile}), values.map.getDpi());
        return new Output(scalebarGraphicFile, scalebarSubReport.toString());
    }

    private URI createScalebarGraphic(Input values) throws IOException, ParserConfigurationException {
        ScalebarGraphic scalebar = new ScalebarGraphic();
        return scalebar.render(values.map, values.scalebar, values.tempTaskDirectory, values.template);
    }

    private URI createScalebarSubReport(File printDirectory, Dimension size, List<URI> graphics, double dpi) throws IOException, JRException {
        MapSubReport subReport = new MapSubReport(graphics, size, dpi);
        File compiledReport = File.createTempFile("scalebar-report-", ".jasper", printDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }

    public static final class Output {
        @InternalValue
        public final URI graphic;
        public final String subReport;

        private Output(URI graphic, String subReport) {
            this.graphic = graphic;
            this.subReport = subReport;
        }
    }

    public static class Input {
        public MapAttribute.MapAttributeValues map;
        public ScalebarAttribute.ScalebarAttributeValues scalebar;
        @InternalValue
        public File tempTaskDirectory;
        @InternalValue
        public Template template;
    }
}

