/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.Constants;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.config.Template;
import org.mapfish.print.servlet.BaseMapServlet;
import org.mapfish.print.servlet.HandleReportLoadResult;
import org.mapfish.print.servlet.NoSuchAppException;
import org.mapfish.print.servlet.ServletInfo;
import org.mapfish.print.servlet.job.FailedPrintJob;
import org.mapfish.print.servlet.job.JobManager;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PrintJob;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.SuccessfulPrintJob;
import org.mapfish.print.servlet.job.loader.ReportLoader;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MapPrinterServlet
extends BaseMapServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapPrinterServlet.class);
    public static final String CAPABILITIES_URL = "/capabilities.json";
    public static final String LIST_APPS_URL = "/apps.json";
    public static final String EXAMPLE_REQUEST_URL = "/exampleRequest.json";
    public static final String CREATE_AND_GET_URL = "/buildreport";
    public static final String STATUS_URL = "/status";
    public static final String CANCEL_URL = "/cancel";
    public static final String REPORT_URL = "/report";
    public static final String JSON_ERROR = "error";
    public static final String JSON_APP = "app";
    public static final String JSON_COUNT = "count";
    public static final String JSON_SPEC = "spec";
    public static final String JSON_DONE = "done";
    public static final String JSON_TIME = "time";
    public static final String JSON_PRINT_JOB_REF = "ref";
    public static final String JSON_STATUS_LINK = "statusURL";
    public static final String JSON_DOWNLOAD_LINK = "downloadURL";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{(\\S+)}");
    public static final String JSON_OUTPUT_FORMAT = "outputFormat";
    private static final int JSON_INDENT_FACTOR = 4;
    public static final String JSON_ATTRIBUTES = "attributes";
    public static final String JSON_REQUEST_HEADERS = "requestHeaders";
    @Autowired
    private JobManager jobManager;
    @Autowired
    private List<ReportLoader> reportLoaders;
    @Autowired
    private MapPrinterFactory printerFactory;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ServletInfo servletInfo;
    private long maxCreateAndGetWaitTimeInSeconds;
    @Autowired
    private MapPrinterFactory mapPrinterFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/status/{referenceId:\\S+}.json"}, method={RequestMethod.GET})
    public final void getStatus(@PathVariable String referenceId, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletRequest statusRequest, HttpServletResponse statusResponse) {
        PrintWriter writer = null;
        try {
            boolean done = this.jobManager.isDone(referenceId);
            this.setContentType(statusResponse, jsonpCallback);
            writer = statusResponse.getWriter();
            this.appendJsonpCallback(jsonpCallback, writer);
            JSONWriter json = new JSONWriter((Writer)writer);
            json.object();
            json.key(JSON_DONE).value(done);
            Optional<? extends PrintJobStatus> metadata = this.jobManager.getCompletedPrintJob(referenceId);
            if (metadata.isPresent() && metadata.get() instanceof FailedPrintJob) {
                json.key(JSON_ERROR).value((Object)((FailedPrintJob)metadata.get()).getError());
            }
            json.key(JSON_COUNT).value((long)this.jobManager.getLastPrintCount());
            json.key(JSON_TIME).value(this.jobManager.getAverageTimeSpentPrinting());
            this.addDownloadLinkToJson(statusRequest, referenceId, json);
            json.endObject();
            this.appendJsonpCallbackEnd(jsonpCallback, writer);
        }
        catch (JSONException e) {
            LOGGER.error("Error obtaining status", (Throwable)e);
            throw ExceptionUtils.getRuntimeException(e);
        }
        catch (IOException e) {
            LOGGER.error("Error obtaining status", (Throwable)e);
            throw ExceptionUtils.getRuntimeException(e);
        }
        catch (NoSuchReferenceException e) {
            MapPrinterServlet.error(statusResponse, e.getMessage(), HttpStatus.NOT_FOUND);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @RequestMapping(value={"/cancel/{referenceId:\\S+}"}, method={RequestMethod.DELETE})
    public final void cancel(@PathVariable String referenceId, HttpServletResponse statusResponse) {
        try {
            this.jobManager.cancel(referenceId);
        }
        catch (NoSuchReferenceException e) {
            MapPrinterServlet.error(statusResponse, e.getMessage(), HttpStatus.NOT_FOUND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{appId}/report.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReport(@PathVariable String appId, @PathVariable String format, @RequestBody String requestData, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws JSONException, NoSuchAppException {
        String ref = this.createAndSubmitPrintJob(appId, format, requestData, createReportRequest, createReportResponse);
        if (ref == null) {
            MapPrinterServlet.error(createReportResponse, "Failed to create a print job", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        PrintWriter writer = null;
        try {
            createReportResponse.setContentType("application/json; charset=utf-8");
            writer = createReportResponse.getWriter();
            JSONWriter json = new JSONWriter((Writer)writer);
            json.object();
            json.key(JSON_PRINT_JOB_REF).value((Object)ref);
            String statusURL = this.getBaseUrl(createReportRequest) + STATUS_URL + "/" + ref + ".json";
            json.key(JSON_STATUS_LINK).value((Object)statusURL);
            this.addDownloadLinkToJson(createReportRequest, ref, json);
            json.endObject();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @RequestMapping(value={"/report/{referenceId:\\S+}"}, method={RequestMethod.GET})
    public final void getReport(@PathVariable String referenceId, final @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletResponse getReportResponse) throws IOException, ServletException {
        this.loadReport(referenceId, getReportResponse, new HandleReportLoadResult<Void>(){

            @Override
            public Void unknownReference(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Print with ref=" + referenceId + " unknown", HttpStatus.NOT_FOUND);
                return null;
            }

            @Override
            public Void unsupportedLoader(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Print with ref=" + referenceId + " can not be loaded", HttpStatus.NOT_FOUND);
                return null;
            }

            @Override
            public Void successfulPrint(SuccessfulPrintJob successfulPrintResult, HttpServletResponse httpServletResponse, URI reportURI, ReportLoader loader) throws IOException, ServletException {
                MapPrinterServlet.this.sendReportFile(successfulPrintResult, httpServletResponse, loader, reportURI, inline);
                return null;
            }

            @Override
            public Void failedPrint(FailedPrintJob failedPrintJob, HttpServletResponse httpServletResponse) {
                BaseMapServlet.error(httpServletResponse, failedPrintJob.getError(), HttpStatus.INTERNAL_SERVER_ERROR);
                return null;
            }

            @Override
            public Void printJobPending(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Report has not yet completed processing", HttpStatus.ACCEPTED);
                return null;
            }
        });
    }

    @RequestMapping(value={"/report.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReport(@PathVariable String format, @RequestBody String requestData, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws JSONException, NoSuchAppException {
        PJsonObject spec = MapPrinterServlet.parseJson(requestData, createReportResponse);
        String appId = spec.optString(JSON_APP, "default");
        this.createReport(appId, format, requestData, createReportRequest, createReportResponse);
    }

    @RequestMapping(value={"/{appId}/buildreport.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReportAndGet(@PathVariable String appId, @PathVariable String format, @RequestBody String requestData, final @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws IOException, ServletException, InterruptedException, JSONException, NoSuchAppException {
        String ref = this.createAndSubmitPrintJob(appId, format, requestData, createReportRequest, createReportResponse);
        if (ref == null) {
            MapPrinterServlet.error(createReportResponse, "Failed to create a print job", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        HandleReportLoadResult<Boolean> handler = new HandleReportLoadResult<Boolean>(){

            @Override
            public Boolean unknownReference(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Print with ref=" + referenceId + " unknown", HttpStatus.NOT_FOUND);
                return true;
            }

            @Override
            public Boolean unsupportedLoader(HttpServletResponse httpServletResponse, String referenceId) {
                BaseMapServlet.error(httpServletResponse, "Print with ref=" + referenceId + " can not be loaded", HttpStatus.NOT_FOUND);
                return true;
            }

            @Override
            public Boolean successfulPrint(SuccessfulPrintJob successfulPrintResult, HttpServletResponse httpServletResponse, URI reportURI, ReportLoader loader) throws IOException, ServletException {
                MapPrinterServlet.this.sendReportFile(successfulPrintResult, httpServletResponse, loader, reportURI, inline);
                return true;
            }

            @Override
            public Boolean failedPrint(FailedPrintJob failedPrintJob, HttpServletResponse httpServletResponse) {
                BaseMapServlet.error(httpServletResponse, failedPrintJob.getError(), HttpStatus.INTERNAL_SERVER_ERROR);
                return true;
            }

            @Override
            public Boolean printJobPending(HttpServletResponse httpServletResponse, String referenceId) {
                return false;
            }
        };
        boolean isDone = false;
        long startWaitTime = System.currentTimeMillis();
        long maxWaitTimeInMillis = TimeUnit.SECONDS.toMillis(this.maxCreateAndGetWaitTimeInSeconds);
        while (!isDone && System.currentTimeMillis() - startWaitTime < maxWaitTimeInMillis) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            isDone = this.loadReport(ref, createReportResponse, handler);
        }
    }

    @RequestMapping(value={"/buildreport.{format:\\w+}"}, method={RequestMethod.POST})
    public final void createReportAndGetNoAppId(@PathVariable String format, @RequestBody String requestData, @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletRequest createReportRequest, HttpServletResponse createReportResponse) throws IOException, ServletException, InterruptedException, JSONException, NoSuchAppException {
        PJsonObject spec = MapPrinterServlet.parseJson(requestData, createReportResponse);
        String appId = spec.optString(JSON_APP, "default");
        this.createReportAndGet(appId, format, requestData, inline, createReportRequest, createReportResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/apps.json"}, method={RequestMethod.GET})
    public final void listAppIds(@RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletResponse listAppsResponse) throws ServletException, IOException {
        Set<String> appIds = this.printerFactory.getAppIds();
        this.setContentType(listAppsResponse, jsonpCallback);
        PrintWriter writer = listAppsResponse.getWriter();
        try {
            this.appendJsonpCallback(jsonpCallback, writer);
            JSONWriter json = new JSONWriter((Writer)writer);
            try {
                json.array();
                for (String appId : appIds) {
                    json.value((Object)appId);
                }
                json.endArray();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
            this.appendJsonpCallbackEnd(jsonpCallback, writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @RequestMapping(value={"/capabilities.json"}, method={RequestMethod.GET})
    public final void getCapabilities(@RequestParam(value="pretty", defaultValue="false") boolean pretty, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletResponse capabilitiesResponse) throws ServletException, IOException, JSONException {
        this.getCapabilities("default", pretty, jsonpCallback, capabilitiesResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{appId:\\w+}/capabilities.json"}, method={RequestMethod.GET})
    public final void getCapabilities(@PathVariable String appId, @RequestParam(value="pretty", defaultValue="false") boolean pretty, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletResponse capabilitiesResponse) throws ServletException, IOException, JSONException {
        MapPrinter printer;
        try {
            printer = this.printerFactory.create(appId);
        }
        catch (NoSuchAppException e) {
            MapPrinterServlet.error(capabilitiesResponse, e.getMessage(), HttpStatus.NOT_FOUND);
            return;
        }
        this.setContentType(capabilitiesResponse, jsonpCallback);
        ByteArrayOutputStream prettyPrintBuffer = new ByteArrayOutputStream();
        Writer writer = pretty ? new OutputStreamWriter((OutputStream)prettyPrintBuffer, Constants.DEFAULT_CHARSET) : capabilitiesResponse.getWriter();
        try {
            if (!pretty && !Strings.isNullOrEmpty((String)jsonpCallback)) {
                writer.append(jsonpCallback + "(");
            }
            JSONWriter json = new JSONWriter(writer);
            try {
                json.object();
                json.key(JSON_APP).value((Object)appId);
                printer.printClientConfig(json);
                json.key("formats");
                Set<String> formats = printer.getOutputFormatsNames();
                json.array();
                for (String format : formats) {
                    json.value((Object)format);
                }
                json.endArray();
                json.endObject();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
            if (!pretty && !Strings.isNullOrEmpty((String)jsonpCallback)) {
                writer.append(");");
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (pretty) {
            JSONObject jsonObject = new JSONObject(new String(prettyPrintBuffer.toByteArray(), Constants.DEFAULT_CHARSET));
            if (!Strings.isNullOrEmpty((String)jsonpCallback)) {
                capabilitiesResponse.getOutputStream().print(jsonpCallback + "(");
            }
            capabilitiesResponse.getOutputStream().print(jsonObject.toString(4));
            if (!Strings.isNullOrEmpty((String)jsonpCallback)) {
                capabilitiesResponse.getOutputStream().print(");");
            }
        }
    }

    @RequestMapping(value={"/exampleRequest.json"}, method={RequestMethod.GET})
    public final void getExampleRequest(@RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletResponse getExampleResponse) throws ServletException, IOException {
        this.getExampleRequest("default", jsonpCallback, getExampleResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"{appId}/exampleRequest.json"}, method={RequestMethod.GET})
    public final void getExampleRequest(@PathVariable String appId, @RequestParam(value="jsonp", defaultValue="") String jsonpCallback, HttpServletResponse getExampleResponse) throws ServletException, IOException {
        PrintWriter writer = null;
        try {
            String result;
            MapPrinter mapPrinter = this.printerFactory.create(appId);
            Iterable children = Files.fileTreeTraverser().children((Object)mapPrinter.getConfiguration().getDirectory());
            JSONObject allExamples = new JSONObject();
            for (File child : children) {
                String requestDataPrefix = "requestData";
                if (!child.isFile() || !child.getName().startsWith("requestData") || !child.getName().endsWith(".json")) continue;
                String requestData = Files.toString((File)child, (Charset)Constants.DEFAULT_CHARSET);
                try {
                    JSONObject jsonObject = new JSONObject(requestData);
                    jsonObject.remove(JSON_OUTPUT_FORMAT);
                    jsonObject.remove(JSON_APP);
                    requestData = jsonObject.toString(4);
                    this.setContentType(getExampleResponse, jsonpCallback);
                }
                catch (JSONException e) {
                    // empty catch block
                }
                String name = child.getName();
                name = name.substring("requestData".length());
                if (name.startsWith("-")) {
                    name = name.substring(1);
                }
                name = Files.getNameWithoutExtension((String)name);
                if ((name = name.trim()).isEmpty()) {
                    name = Files.getNameWithoutExtension((String)child.getName());
                }
                try {
                    allExamples.put(name, (Object)requestData);
                }
                catch (JSONException e) {
                    Log.error((Object)"Error translating object to json", (Exception)((Object)e));
                    MapPrinterServlet.error(getExampleResponse, "Error translating object to json: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                    if (writer != null) {
                        writer.close();
                    }
                    return;
                }
            }
            try {
                result = allExamples.toString(4);
            }
            catch (JSONException e) {
                Log.error((Object)"Error translating object to json", (Exception)((Object)e));
                MapPrinterServlet.error(getExampleResponse, "Error translating object to json: " + e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                if (writer != null) {
                    writer.close();
                }
                return;
            }
            writer = getExampleResponse.getWriter();
            this.appendJsonpCallback(jsonpCallback, writer);
            writer.append(result);
            this.appendJsonpCallbackEnd(jsonpCallback, writer);
        }
        catch (NoSuchAppException e) {
            MapPrinterServlet.error(getExampleResponse, "No print app identified by: " + appId, HttpStatus.NOT_FOUND);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public final void setMaxCreateAndGetWaitTimeInSeconds(long maxCreateAndGetWaitTimeInSeconds) {
        this.maxCreateAndGetWaitTimeInSeconds = maxCreateAndGetWaitTimeInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void sendReportFile(SuccessfulPrintJob metadata, HttpServletResponse httpServletResponse, ReportLoader reportLoader, URI reportURI, boolean inline) throws IOException, ServletException {
        ServletOutputStream response = httpServletResponse.getOutputStream();
        try {
            httpServletResponse.setContentType(metadata.getMimeType());
            if (!inline) {
                String fileName = metadata.getFileName();
                Matcher matcher = VARIABLE_PATTERN.matcher(fileName);
                while (matcher.find()) {
                    String variable = matcher.group(1);
                    String replacement = MapPrinterServlet.findReplacement(variable, metadata.getCompletionDate());
                    fileName = fileName.replace("${" + variable + "}", replacement);
                    matcher = VARIABLE_PATTERN.matcher(fileName);
                }
                fileName = fileName + "." + metadata.getFileExtension();
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + MapPrinterServlet.cleanUpName(fileName));
            }
            reportLoader.loadReport(reportURI, (OutputStream)response);
        }
        finally {
            response.close();
        }
    }

    private void addDownloadLinkToJson(HttpServletRequest httpServletRequest, String ref, JSONWriter json) throws JSONException {
        String downloadURL = this.getBaseUrl(httpServletRequest) + REPORT_URL + "/" + ref;
        json.key(JSON_DOWNLOAD_LINK).value((Object)downloadURL);
    }

    protected final JSONObject getHeaders(HttpServletRequest httpServletRequest) throws JSONException {
        Enumeration headersName = httpServletRequest.getHeaderNames();
        JSONObject headers = new JSONObject();
        while (headersName.hasMoreElements()) {
            String name = headersName.nextElement().toString();
            Enumeration e = httpServletRequest.getHeaders(name);
            while (e.hasMoreElements()) {
                headers.append(name, e.nextElement());
            }
        }
        JSONObject requestHeadersAttribute = new JSONObject();
        requestHeadersAttribute.put(JSON_REQUEST_HEADERS, (Object)headers);
        return requestHeadersAttribute;
    }

    public static PJsonObject parseJson(String requestDataRaw, HttpServletResponse httpServletResponse) {
        try {
            if (requestDataRaw == null) {
                MapPrinterServlet.error(httpServletResponse, "Missing post data.  The post payload must either be a form post with a spec parameter or must be a raw json post with the request.", HttpStatus.INTERNAL_SERVER_ERROR);
                return null;
            }
            String requestData = requestDataRaw;
            if (!requestData.startsWith("spec=") && !requestData.startsWith("{")) {
                try {
                    requestData = URLDecoder.decode(requestData, Constants.DEFAULT_ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    throw ExceptionUtils.getRuntimeException(e);
                }
            }
            if (requestData.startsWith("spec=")) {
                requestData = requestData.substring("spec=".length());
            }
            try {
                return MapPrinter.parseSpec(requestData);
            }
            catch (RuntimeException e) {
                try {
                    return MapPrinter.parseSpec(URLDecoder.decode(requestData, Constants.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException uee) {
                    throw ExceptionUtils.getRuntimeException(e);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error parsing request data: " + requestDataRaw);
            throw e;
        }
    }

    public final String createAndSubmitPrintJob(String appId, String format, String requestDataRaw, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws JSONException, NoSuchAppException {
        PJsonObject specJson = MapPrinterServlet.parseJson(requestDataRaw, httpServletResponse);
        if (specJson == null) {
            return null;
        }
        if (SPEC_LOGGER.isInfoEnabled()) {
            SPEC_LOGGER.info(specJson.toString());
        }
        specJson.getInternalObj().remove(JSON_OUTPUT_FORMAT);
        specJson.getInternalObj().put(JSON_OUTPUT_FORMAT, (Object)format);
        specJson.getInternalObj().remove(JSON_APP);
        specJson.getInternalObj().put(JSON_APP, (Object)appId);
        JSONObject requestHeaders = this.getHeaders(httpServletRequest);
        if (requestHeaders.length() > 0) {
            specJson.getInternalObj().getJSONObject(JSON_ATTRIBUTES).put(JSON_REQUEST_HEADERS, (Object)requestHeaders);
        }
        String ref = UUID.randomUUID().toString() + "@" + this.servletInfo.getServletId();
        PrintJob job = (PrintJob)this.context.getBean(PrintJob.class);
        job.setReferenceId(ref);
        job.setRequestData(specJson);
        job.setSecurityContext(SecurityContextHolder.getContext());
        String templateName = specJson.getString("layout");
        MapPrinter mapPrinter = this.mapPrinterFactory.create(appId);
        Template template = mapPrinter.getConfiguration().getTemplate(templateName);
        job.configureAccess(template);
        try {
            this.jobManager.submit(job);
        }
        catch (RuntimeException exc) {
            LOGGER.error("Error when creating job", (Throwable)exc);
            ref = null;
        }
        return ref;
    }

    private <R> R loadReport(String referenceId, HttpServletResponse httpServletResponse, HandleReportLoadResult<R> handler) throws IOException, ServletException {
        Optional<? extends PrintJobStatus> metadata;
        try {
            metadata = this.jobManager.getCompletedPrintJob(referenceId);
        }
        catch (NoSuchReferenceException e) {
            return handler.unknownReference(httpServletResponse, referenceId);
        }
        if (!metadata.isPresent()) {
            return handler.printJobPending(httpServletResponse, referenceId);
        }
        if (metadata.get() instanceof SuccessfulPrintJob) {
            SuccessfulPrintJob successfulPrintJob = (SuccessfulPrintJob)metadata.get();
            URI pdfURI = successfulPrintJob.getURI();
            ReportLoader loader = null;
            for (ReportLoader reportLoader : this.reportLoaders) {
                if (!reportLoader.accepts(pdfURI)) continue;
                loader = reportLoader;
                break;
            }
            if (loader == null) {
                return handler.unsupportedLoader(httpServletResponse, referenceId);
            }
            return handler.successfulPrint(successfulPrintJob, httpServletResponse, pdfURI, loader);
        }
        if (metadata.get() instanceof FailedPrintJob) {
            FailedPrintJob failedPrintJob = (FailedPrintJob)metadata.get();
            return handler.failedPrint(failedPrintJob, httpServletResponse);
        }
        throw new ServletException("Unexpected state");
    }

    private void setContentType(HttpServletResponse statusResponse, String jsonpCallback) {
        if (Strings.isNullOrEmpty((String)jsonpCallback)) {
            statusResponse.setContentType("application/json; charset=utf-8");
        } else {
            statusResponse.setContentType("application/javascript; charset=utf-8");
        }
    }

    private void appendJsonpCallback(String jsonpCallback, PrintWriter writer) {
        if (!Strings.isNullOrEmpty((String)jsonpCallback)) {
            writer.append(jsonpCallback + "(");
        }
    }

    private void appendJsonpCallbackEnd(String jsonpCallback, PrintWriter writer) {
        if (!Strings.isNullOrEmpty((String)jsonpCallback)) {
            writer.append(");");
        }
    }
}

