/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.json.JSONException;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.access.AccessAssertionPersister;
import org.mapfish.print.servlet.job.FailedPrintJob;
import org.mapfish.print.servlet.job.JobManager;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PendingPrintJob;
import org.mapfish.print.servlet.job.PrintJob;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.SubmittedPrintJob;
import org.mapfish.print.servlet.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class ThreadPoolJobManager
implements JobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolJobManager.class);
    private static final String REPORT_URI_PREFIX = "REPORT_URI_";
    private static final String NEW_PRINT_COUNT = "newPrintCount";
    private static final String LAST_PRINT_COUNT = "lastPrintCount";
    private static final String TOTAL_PRINT_TIME = "totalPrintTime";
    private static final String NB_PRINT_DONE = "nbPrintDone";
    private static final String LAST_POLL = "lastPoll_";
    private static final int DEFAULT_MAX_WAITING_JOBS = 5000;
    private static final long DEFAULT_THREAD_IDLE_TIME = 60L;
    private static final long DEFAULT_TIMEOUT_IN_SECONDS = 600L;
    private static final long DEFAULT_ABANDONED_TIMEOUT_IN_SECONDS = 120L;
    private int maxNumberOfRunningPrintJobs = Runtime.getRuntime().availableProcessors();
    private int maxNumberOfWaitingJobs = 5000;
    private long maxIdleTime = 60L;
    private long timeout = 600L;
    private long abandonedTimeout = 120L;
    private Comparator<PrintJob> jobPriorityComparator = new Comparator<PrintJob>(){

        @Override
        public int compare(PrintJob o1, PrintJob o2) {
            return 0;
        }
    };
    private ThreadPoolExecutor executor;
    private final Map<String, SubmittedPrintJob> runningTasksFutures = Collections.synchronizedMap(new HashMap());
    @Autowired
    private Registry registry;
    private PriorityBlockingQueue<Runnable> queue;
    private Timer timer;
    @Qualifier(value="accessAssertionPersister")
    @Autowired
    private AccessAssertionPersister assertionPersister;

    public final void setMaxNumberOfRunningPrintJobs(int maxNumberOfRunningPrintJobs) {
        this.maxNumberOfRunningPrintJobs = maxNumberOfRunningPrintJobs;
    }

    public final void setMaxNumberOfWaitingJobs(int maxNumberOfWaitingJobs) {
        this.maxNumberOfWaitingJobs = maxNumberOfWaitingJobs;
    }

    public final void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public final void setAbandonedTimeout(long abandonedTimeout) {
        this.abandonedTimeout = abandonedTimeout;
    }

    public final void setJobPriorityComparator(Comparator<PrintJob> jobPriorityComparator) {
        this.jobPriorityComparator = jobPriorityComparator;
    }

    @PostConstruct
    public final void init() {
        if (TimeUnit.SECONDS.toMillis(this.abandonedTimeout) >= this.registry.getTimeToKeepAfterAccessInMillis()) {
            String msg = String.format("%s abandonTimeout must be smaller than %s timeToKeepAfterAccess", this.getClass().getName(), this.registry.getClass().getName());
            throw new IllegalStateException(msg);
        }
        if (TimeUnit.SECONDS.toMillis(this.timeout) >= this.registry.getTimeToKeepAfterAccessInMillis()) {
            String msg = String.format("%s timeout must be smaller than %s timeToKeepAfterAccess", this.getClass().getName(), this.registry.getClass().getName());
            throw new IllegalStateException(msg);
        }
        CustomizableThreadFactory threadFactory = new CustomizableThreadFactory();
        threadFactory.setDaemon(true);
        threadFactory.setThreadNamePrefix("PrintJobManager-");
        this.queue = new PriorityBlockingQueue<Runnable>(this.maxNumberOfWaitingJobs, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                if (o1 instanceof PrintJob) {
                    if (o2 instanceof PrintJob) {
                        return ThreadPoolJobManager.this.jobPriorityComparator.compare((PrintJob)((Object)o1), (PrintJob)((Object)o2));
                    }
                    return 1;
                }
                if (o2 instanceof PrintJob) {
                    return -1;
                }
                return 0;
            }
        });
        this.executor = new ThreadPoolExecutor(this.maxNumberOfRunningPrintJobs, this.maxNumberOfRunningPrintJobs, this.maxIdleTime, TimeUnit.SECONDS, this.queue, (ThreadFactory)threadFactory);
        this.timer = new Timer("Post result to registry", true);
        this.timer.schedule((TimerTask)new PostResultToRegistryTask(this.assertionPersister), 500L, 500L);
    }

    @PreDestroy
    public final void shutdown() {
        this.timer.cancel();
        this.executor.shutdownNow();
    }

    @Override
    public final void submit(PrintJob job) {
        int numberOfWaitingRequests = this.queue.size();
        if (numberOfWaitingRequests >= this.maxNumberOfWaitingJobs) {
            throw new RuntimeException("Max. number of waiting print job requests exceeded.  Number of waiting requests are: " + numberOfWaitingRequests);
        }
        this.registry.incrementInt(NEW_PRINT_COUNT, 1);
        Future<PrintJobStatus> future = this.executor.submit(job);
        try {
            PendingPrintJob pendingPrintJob = new PendingPrintJob(job.getReferenceId(), job.getAppId(), job.getAccess());
            pendingPrintJob.store(this.registry, this.assertionPersister);
            this.registry.put(LAST_POLL + job.getReferenceId(), new Date().getTime());
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
        finally {
            this.runningTasksFutures.put(job.getReferenceId(), new SubmittedPrintJob(future, job.getReferenceId(), job.getAppId(), job.getAccess()));
        }
    }

    @Override
    public final int getNumberOfRequestsMade() {
        return this.registry.opt(NEW_PRINT_COUNT, 0);
    }

    @Override
    public final boolean isDone(String referenceId) throws NoSuchReferenceException {
        boolean done = this.getCompletedPrintJob(referenceId).isPresent();
        if (!done) {
            this.registry.put(LAST_POLL + referenceId, new Date().getTime());
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel(String referenceId) throws NoSuchReferenceException {
        Optional<? extends PrintJobStatus> jobStatus = null;
        try {
            jobStatus = PrintJobStatus.load(referenceId, this.registry, this.assertionPersister);
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
        Map<String, SubmittedPrintJob> e = this.runningTasksFutures;
        synchronized (e) {
            if (this.runningTasksFutures.containsKey(referenceId)) {
                SubmittedPrintJob printJob = this.runningTasksFutures.get(referenceId);
                if (!printJob.getReportFuture().cancel(true)) {
                    LOGGER.info("Could not cancel job " + referenceId);
                }
                this.runningTasksFutures.remove(referenceId);
                this.registry.incrementInt(NB_PRINT_DONE, 1);
                this.registry.incrementLong(TOTAL_PRINT_TIME, printJob.getTimeSinceStart());
            }
        }
        FailedPrintJob failedJob = new FailedPrintJob(referenceId, ((PrintJobStatus)jobStatus.get()).getAppId(), new Date(), "", "task canceled", ((PrintJobStatus)jobStatus.get()).getAccess());
        try {
            failedJob.store(this.registry, this.assertionPersister);
        }
        catch (JSONException e2) {
            throw ExceptionUtils.getRuntimeException(e2);
        }
    }

    @Override
    public final long timeSinceLastStatusCheck(String referenceId) {
        return this.registry.opt(LAST_POLL + referenceId, System.currentTimeMillis());
    }

    @Override
    public final long getAverageTimeSpentPrinting() {
        return this.registry.opt(TOTAL_PRINT_TIME, 0L) / this.registry.opt(NB_PRINT_DONE, 1).longValue();
    }

    @Override
    public final int getLastPrintCount() {
        return this.registry.opt(LAST_PRINT_COUNT, 0);
    }

    @Override
    public final Optional<? extends PrintJobStatus> getCompletedPrintJob(String referenceId) throws NoSuchReferenceException {
        try {
            Optional<? extends PrintJobStatus> jobStatus = PrintJobStatus.load(referenceId, this.registry, this.assertionPersister);
            if (jobStatus.get() instanceof PendingPrintJob) {
                return Optional.absent();
            }
            return jobStatus;
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    private class PostResultToRegistryTask
    extends TimerTask {
        private static final int CHECK_INTERVAL = 500;
        private final AccessAssertionPersister assertionPersister;

        public PostResultToRegistryTask(AccessAssertionPersister assertionPersister) {
            this.assertionPersister = assertionPersister;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ThreadPoolJobManager.this.executor.isShutdown()) {
                return;
            }
            try {
                Map map = ThreadPoolJobManager.this.runningTasksFutures;
                synchronized (map) {
                    this.updateRegistry();
                }
            }
            catch (Throwable t) {
                LOGGER.error("Error while updating registry", t);
            }
        }

        private void updateRegistry() {
            Iterator submittedJobs = ThreadPoolJobManager.this.runningTasksFutures.values().iterator();
            while (submittedJobs.hasNext()) {
                SubmittedPrintJob printJob = (SubmittedPrintJob)submittedJobs.next();
                if (!printJob.getReportFuture().isDone() && (this.isTimeoutExceeded(printJob) || this.isAbandoned(printJob))) {
                    LOGGER.info("Cancelling job after timeout " + printJob.getReportRef());
                    if (!printJob.getReportFuture().cancel(true)) {
                        LOGGER.info("Could not cancel job after timeout " + printJob.getReportRef());
                    }
                    ThreadPoolJobManager.this.executor.purge();
                }
                if (!printJob.getReportFuture().isDone()) continue;
                submittedJobs.remove();
                Registry registryRef = ThreadPoolJobManager.this.registry;
                try {
                    printJob.getReportFuture().get().store(registryRef, this.assertionPersister);
                    registryRef.incrementInt(ThreadPoolJobManager.NB_PRINT_DONE, 1);
                    registryRef.incrementLong(ThreadPoolJobManager.TOTAL_PRINT_TIME, printJob.getTimeSinceStart());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    registryRef.incrementInt(ThreadPoolJobManager.LAST_PRINT_COUNT, 1);
                }
                catch (JSONException e) {
                    registryRef.incrementInt(ThreadPoolJobManager.LAST_PRINT_COUNT, 1);
                }
                catch (CancellationException e) {
                    try {
                        FailedPrintJob failedJob = new FailedPrintJob(printJob.getReportRef(), printJob.getAppId(), new Date(), "", "task canceled (timeout)", printJob.getAccessAssertion());
                        failedJob.store(registryRef, this.assertionPersister);
                        registryRef.incrementInt(ThreadPoolJobManager.NB_PRINT_DONE, 1);
                        registryRef.incrementLong(ThreadPoolJobManager.TOTAL_PRINT_TIME, printJob.getTimeSinceStart());
                    }
                    catch (JSONException e1) {
                        registryRef.incrementInt(ThreadPoolJobManager.LAST_PRINT_COUNT, 1);
                    }
                }
            }
        }

        private boolean isTimeoutExceeded(SubmittedPrintJob printJob) {
            return printJob.getTimeSinceStart() > TimeUnit.MILLISECONDS.convert(ThreadPoolJobManager.this.timeout, TimeUnit.SECONDS);
        }

        private boolean isAbandoned(SubmittedPrintJob printJob) {
            boolean abandoned;
            long duration = new Date().getTime() - ThreadPoolJobManager.this.timeSinceLastStatusCheck(printJob.getReportRef());
            boolean bl = abandoned = duration > TimeUnit.SECONDS.toMillis(ThreadPoolJobManager.this.abandonedTimeout);
            if (abandoned) {
                LOGGER.info("Job " + printJob.getReportRef() + " is abandoned (no status check within the " + "last " + ThreadPoolJobManager.this.abandonedTimeout + " seconds)");
            }
            return abandoned;
        }
    }
}

