/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.oldapi;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.wrapper.json.PJsonObject;

public final class OldAPILayerConverter {
    private static Map<String, LayerConverter> converters = new HashMap<String, LayerConverter>();

    private OldAPILayerConverter() {
    }

    public static JSONObject convert(PJsonObject oldLayer) throws JSONException {
        String layerType = oldLayer.optString("type", "").toLowerCase();
        if (!converters.containsKey(layerType)) {
            throw new UnsupportedOperationException("Layer type '" + layerType + "' is " + "not supported by the legacy API.");
        }
        return converters.get(layerType).convert(oldLayer);
    }

    static {
        converters.put("osm", new OSMConverter());
        converters.put("wms", new WMSConverter());
        converters.put("vector", new GeoJsonConverter());
    }

    private static class GeoJsonConverter
    extends AbstractLayerConverter {
        private GeoJsonConverter() {
        }

        @Override
        public final JSONObject convert(PJsonObject oldLayer) throws JSONException {
            JSONObject layer = super.convert(oldLayer);
            layer.put("type", (Object)"geojson");
            if (oldLayer.has("geoJson")) {
                try {
                    layer.put("geoJson", (Object)oldLayer.getInternalObj().getJSONObject("geoJson"));
                }
                catch (JSONException e) {
                    layer.put("geoJson", (Object)oldLayer.getString("geoJson"));
                }
            }
            if (oldLayer.has("styles")) {
                JSONObject styles = oldLayer.getInternalObj().getJSONObject("styles");
                if (oldLayer.has("styleProperty")) {
                    styles.put("styleProperty", (Object)oldLayer.getString("styleProperty"));
                }
                styles.put("version", (Object)"1");
                layer.put("style", (Object)styles);
                oldLayer.getInternalObj().remove("styles");
            }
            return layer;
        }
    }

    private static class WMSConverter
    extends AbstractLayerConverter {
        private WMSConverter() {
        }

        @Override
        public final JSONObject convert(PJsonObject oldLayer) throws JSONException {
            JSONArray stylesJson;
            JSONObject layer = super.convert(oldLayer);
            layer.put("type", (Object)"wms");
            if (oldLayer.has("baseURL")) {
                layer.put("baseURL", (Object)oldLayer.getString("baseURL"));
            }
            if (oldLayer.has("opacity")) {
                layer.put("opacity", oldLayer.getDouble("opacity"));
            }
            if (oldLayer.has("layers")) {
                layer.put("layers", (Object)oldLayer.getInternalObj().getJSONArray("layers"));
            }
            if (oldLayer.has("format")) {
                layer.put("imageFormat", (Object)oldLayer.getString("format"));
            }
            if (oldLayer.has("styles") && ((stylesJson = oldLayer.getInternalObj().getJSONArray("styles")).length() > 1 || stylesJson.length() == 1 && !stylesJson.getString(0).trim().isEmpty())) {
                layer.put("styles", (Object)stylesJson);
            }
            if (oldLayer.has("customParams")) {
                JSONObject customParams = oldLayer.getInternalObj().getJSONObject("customParams");
                if (customParams.has("version")) {
                    layer.put("version", (Object)customParams.getString("version"));
                    customParams.remove("version");
                }
                layer.put("customParams", (Object)customParams);
            }
            if (oldLayer.has("useNativeAngle")) {
                layer.put("useNativeAngle", oldLayer.getBool("useNativeAngle"));
            }
            return layer;
        }
    }

    private static class OSMConverter
    extends AbstractLayerConverter {
        private OSMConverter() {
        }

        @Override
        public final JSONObject convert(PJsonObject oldLayer) throws JSONException {
            JSONObject layer = super.convert(oldLayer);
            layer.put("type", (Object)"osm");
            if (oldLayer.has("baseURL")) {
                layer.put("baseURL", (Object)oldLayer.getString("baseURL"));
            }
            if (oldLayer.has("opacity")) {
                layer.put("opacity", oldLayer.getDouble("opacity"));
            }
            if (oldLayer.has("extension")) {
                layer.put("imageFormat", (Object)oldLayer.getString("extension"));
            }
            if (oldLayer.has("maxExtent")) {
                layer.put("maxExtent", (Object)oldLayer.getInternalObj().getJSONArray("maxExtent"));
            }
            if (oldLayer.has("tileSize")) {
                layer.put("tileSize", (Object)oldLayer.getInternalObj().getJSONArray("tileSize"));
            }
            if (oldLayer.has("resolutions")) {
                layer.put("resolutions", (Object)oldLayer.getInternalObj().getJSONArray("resolutions"));
            }
            return layer;
        }
    }

    private static abstract class AbstractLayerConverter
    implements LayerConverter {
        private AbstractLayerConverter() {
        }

        @Override
        public JSONObject convert(PJsonObject oldLayer) throws JSONException {
            return new JSONObject();
        }
    }

    private static interface LayerConverter {
        public JSONObject convert(PJsonObject var1) throws JSONException;
    }
}

