/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mapfish.print.attribute.InternalAttribute;
import org.mapfish.print.attribute.ReflectiveAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;

@InternalAttribute
public final class HttpRequestHeadersAttribute
extends ReflectiveAttribute<Value> {
    public HttpRequestHeadersAttribute() {
        this.init();
    }

    @Override
    protected Class<Value> getValueType() {
        return Value.class;
    }

    @Override
    public Value createValue(Template template) {
        return new Value();
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
    }

    public static final class Value {
        public PObject requestHeaders;

        public Map<String, List<String>> getHeaders() {
            HashMap headerMap = Maps.newHashMap();
            Iterator<String> keys = this.requestHeaders.keys();
            while (keys.hasNext()) {
                ArrayList valuesAsList = Lists.newArrayList();
                String headerName = keys.next();
                PArray values = this.requestHeaders.optArray(headerName);
                if (values != null) {
                    for (int i = 0; i < values.size(); ++i) {
                        valuesAsList.add(values.getString(i));
                    }
                } else {
                    valuesAsList.add(this.requestHeaders.getString(headerName));
                }
                headerMap.put(headerName, valuesAsList);
            }
            return headerMap;
        }
    }
}

