/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.google.common.base.Function;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.AreaOfInterest;
import org.mapfish.print.attribute.map.BBoxMapBounds;
import org.mapfish.print.attribute.map.CenterScaleMapBounds;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.attribute.map.ZoomToFeatures;
import org.mapfish.print.config.Template;
import org.mapfish.print.map.Scale;
import org.mapfish.print.parser.CanSatisfyOneOf;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.OneOf;
import org.mapfish.print.parser.Requires;
import org.mapfish.print.wrapper.PArray;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class MapAttribute
extends GenericMapAttribute<MapAttributeValues> {
    private static final double DEFAULT_SNAP_TOLERANCE = 0.05;
    private static final ZoomLevelSnapStrategy DEFAULT_SNAP_STRATEGY = ZoomLevelSnapStrategy.CLOSEST_LOWER_SCALE_ON_TIE;

    @Override
    protected Class<MapAttributeValues> getValueType() {
        return MapAttributeValues.class;
    }

    @Override
    public MapAttributeValues createValue(Template template) {
        return new MapAttributeValues(template, new Dimension(this.getWidth(), this.getHeight()));
    }

    private static <T> T getValueOr(T value, T defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public class OverriddenMapAttributeValues
    extends MapAttributeValues {
        private final MapAttributeValues params;
        private final GenericMapAttribute.GenericMapAttributeValues paramOverrides;
        private MapBounds zoomedOutBounds;
        private MapLayer mapExtentLayer;

        public OverriddenMapAttributeValues(MapAttributeValues params, GenericMapAttribute.GenericMapAttributeValues paramOverrides, Template template) {
            super(template, paramOverrides.getMapSize());
            this.zoomedOutBounds = null;
            this.mapExtentLayer = null;
            this.params = params;
            this.paramOverrides = paramOverrides;
        }

        @Override
        public final MapBounds getMapBounds() {
            return this.zoomedOutBounds;
        }

        public final MapBounds getOriginalBounds() {
            return this.params.getMapBounds();
        }

        public final void setZoomedOutBounds(MapBounds zoomedOutBounds) {
            this.zoomedOutBounds = zoomedOutBounds;
        }

        @Override
        public final Double getDpi() {
            return (Double)MapAttribute.getValueOr(this.paramOverrides.getDpi(), this.params.getDpi());
        }

        @Override
        public final Double getZoomSnapTolerance() {
            return (Double)MapAttribute.getValueOr(this.paramOverrides.getZoomSnapTolerance(), this.params.getZoomSnapTolerance());
        }

        @Override
        public final ZoomLevelSnapStrategy getZoomLevelSnapStrategy() {
            return (ZoomLevelSnapStrategy)((Object)MapAttribute.getValueOr((Object)this.paramOverrides.getZoomLevelSnapStrategy(), (Object)this.params.getZoomLevelSnapStrategy()));
        }

        @Override
        public final ZoomLevels getZoomLevels() {
            return (ZoomLevels)MapAttribute.getValueOr(this.paramOverrides.getZoomLevels(), this.params.getZoomLevels());
        }

        @Override
        public final Double getRotation() {
            return (Double)MapAttribute.getValueOr(this.paramOverrides.getRotation(), this.params.getRotation());
        }

        @Override
        public final Boolean isUseAdjustBounds() {
            return (Boolean)MapAttribute.getValueOr(this.paramOverrides.isUseAdjustBounds(), this.params.isUseAdjustBounds());
        }

        @Override
        public final Boolean isUseNearestScale() {
            Boolean useNearestScale = (Boolean)MapAttribute.getValueOr(this.paramOverrides.useNearestScale, this.params.useNearestScale);
            return (useNearestScale == null || useNearestScale != false) && this.getZoomLevels() != null;
        }

        public final void setMapExtentLayer(MapLayer mapExtentLayer) {
            this.mapExtentLayer = mapExtentLayer;
        }

        @Override
        public final List<MapLayer> getLayers() {
            ArrayList<MapLayer> layers = new ArrayList<MapLayer>();
            if (this.mapExtentLayer != null) {
                layers.add(this.mapExtentLayer);
            }
            if (!this.paramOverrides.getLayers().isEmpty()) {
                layers.addAll(this.paramOverrides.getLayers());
            } else {
                layers.addAll(this.params.getLayers());
            }
            return layers;
        }
    }

    public class MapAttributeValues
    extends GenericMapAttribute.GenericMapAttributeValues {
        private static final boolean DEFAULT_ADJUST_BOUNDS = false;
        private static final double DEFAULT_ROTATION = 0.0;
        private static final String DEFAULT_PROJECTION = "EPSG:3857";
        private MapBounds mapBounds;
        @OneOf(value="MapBounds")
        public double[] bbox;
        @CanSatisfyOneOf(value="MapBounds")
        public AreaOfInterest areaOfInterest;
        @Requires(value={"scale"})
        @OneOf(value="MapBounds")
        public double[] center;
        @HasDefaultValue
        public Double scale;
        @HasDefaultValue
        public ZoomToFeatures zoomToFeatures;
        public PArray layers;
        public double dpi;

        public MapAttributeValues(Template template, Dimension mapSize) {
            super(template, mapSize);
        }

        @Override
        public Double getDpi() {
            return this.dpi;
        }

        @Override
        protected final PArray getRawLayers() {
            return this.layers;
        }

        @Override
        public final void postConstruct() throws FactoryException {
            super.postConstruct();
            if (this.getDpi() > MapAttribute.this.getMaxDpi()) {
                throw new IllegalArgumentException("dpi parameter was " + this.getDpi() + " must be limited to " + MapAttribute.this.getMaxDpi() + ".  The path to the parameter is: " + this.getDpi());
            }
            if (this.zoomToFeatures != null) {
                if (this.zoomToFeatures.zoomType == ZoomToFeatures.ZoomType.CENTER) {
                    if (this.scale == null && this.zoomToFeatures.minScale == null) {
                        throw new IllegalArgumentException("When using 'zoomToFeatures.zoom.Type: center' either 'scale' or 'zoomToFeatures.minScale' has to be given.");
                    }
                } else if (this.zoomToFeatures.zoomType == ZoomToFeatures.ZoomType.EXTENT && this.zoomToFeatures.minScale == null) {
                    throw new IllegalArgumentException("When using 'zoomToFeatures.zoom.Type: extent' 'zoomToFeatures.minScale'has to be given.");
                }
            }
            this.mapBounds = this.parseBounds();
        }

        private MapBounds parseBounds() throws FactoryException {
            MapBounds bounds;
            CoordinateReferenceSystem crs = this.parseProjection();
            if (this.center != null && this.bbox != null) {
                throw new IllegalArgumentException("Cannot have both center and bbox defined");
            }
            if (this.center != null) {
                double centerX = this.center[0];
                double centerY = this.center[1];
                Scale scaleObject = new Scale(this.scale);
                bounds = new CenterScaleMapBounds(crs, centerX, centerY, scaleObject);
            } else if (this.bbox != null) {
                int maxYIndex = 3;
                double minX = this.bbox[0];
                double minY = this.bbox[1];
                double maxX = this.bbox[2];
                double maxY = this.bbox[3];
                bounds = new BBoxMapBounds(crs, minX, minY, maxX, maxY);
            } else if (this.areaOfInterest != null) {
                Envelope area = this.areaOfInterest.getArea().getEnvelopeInternal();
                bounds = new BBoxMapBounds(crs, area);
            } else {
                throw new IllegalArgumentException("Expected either: center and scale, bbox, or an areaOfInterest defined in order to calculate the map bounds");
            }
            return bounds;
        }

        public MapBounds getMapBounds() {
            return this.mapBounds;
        }

        public void setMapBounds(MapBounds mapBounds) {
            this.mapBounds = mapBounds;
        }

        public void recalculateBounds() {
            try {
                this.mapBounds = this.parseBounds();
            }
            catch (FactoryException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
        }

        @Override
        public String getProjection() {
            return (String)MapAttribute.getValueOr(super.getProjection(), DEFAULT_PROJECTION);
        }

        @Override
        public Double getZoomSnapTolerance() {
            return (Double)MapAttribute.getValueOr(super.getZoomSnapTolerance(), 0.05);
        }

        @Override
        public ZoomLevelSnapStrategy getZoomLevelSnapStrategy() {
            return (ZoomLevelSnapStrategy)((Object)MapAttribute.getValueOr((Object)super.getZoomLevelSnapStrategy(), (Object)DEFAULT_SNAP_STRATEGY));
        }

        @Override
        public Double getRotation() {
            return (Double)MapAttribute.getValueOr(super.getRotation(), 0.0);
        }

        @Override
        public Boolean isUseNearestScale() {
            return (this.useNearestScale == null || this.useNearestScale != false) && this.getZoomLevels() != null;
        }

        @Override
        public Boolean isUseAdjustBounds() {
            return (Boolean)MapAttribute.getValueOr(super.isUseAdjustBounds(), false);
        }

        public final OverriddenMapAttributeValues getWithOverrides(GenericMapAttribute.GenericMapAttributeValues paramOverrides) {
            return new OverriddenMapAttributeValues(this, paramOverrides, this.getTemplate());
        }

        public MapAttributeValues copy(@Nonnull Dimension newMapSize, @Nonnull Function<MapAttributeValues, Void> updater) {
            MapAttributeValues copy = new MapAttributeValues(this.getTemplate(), newMapSize);
            copy.areaOfInterest = this.areaOfInterest.copy();
            copy.bbox = this.bbox;
            copy.center = this.center;
            copy.scale = this.scale;
            copy.layers = this.layers;
            copy.dpi = this.getDpi();
            copy.projection = this.getProjection();
            copy.rotation = this.getRotation();
            copy.useNearestScale = this.isUseNearestScale();
            copy.useAdjustBounds = this.useAdjustBounds;
            copy.longitudeFirst = this.longitudeFirst;
            copy.zoomToFeatures = this.zoomToFeatures == null ? null : this.zoomToFeatures.copy();
            updater.apply((Object)copy);
            try {
                copy.postConstruct();
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
            return copy;
        }
    }
}

