/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import java.awt.Rectangle;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.map.Scale;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class MapBounds {
    private final CoordinateReferenceSystem projection;

    protected MapBounds(CoordinateReferenceSystem projection) {
        this.projection = projection;
    }

    public abstract ReferencedEnvelope toReferencedEnvelope(Rectangle var1, double var2);

    public abstract MapBounds adjustedEnvelope(Rectangle var1);

    public final CoordinateReferenceSystem getProjection() {
        return this.projection;
    }

    public abstract MapBounds adjustBoundsToNearestScale(ZoomLevels var1, double var2, ZoomLevelSnapStrategy var4, Rectangle var5, double var6);

    public abstract Scale getScaleDenominator(Rectangle var1, double var2);

    public abstract MapBounds adjustBoundsToRotation(double var1);

    public abstract MapBounds zoomOut(double var1);

    public abstract MapBounds zoomToScale(double var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBounds mapBounds = (MapBounds)o;
        return this.projection.equals(mapBounds.projection);
    }

    public int hashCode() {
        return this.projection.hashCode();
    }
}

