/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.map.Scale;

public class MapfishMapContext {
    private final MapBounds bounds;
    private final Dimension mapSize;
    private final double rotation;
    private final double dpi;
    private final double requestorDpi;
    private final boolean forceLongitudeFirst;
    private final boolean dpiSensitiveStyle;

    public MapfishMapContext(MapBounds bounds, Dimension mapSize, double rotationInDegree, double dpi, double requestorDpi, Boolean forceLongitudeFirst, boolean dpiSensitiveStyle) {
        this.bounds = bounds;
        this.mapSize = mapSize;
        this.rotation = Math.toRadians(rotationInDegree);
        this.dpi = dpi;
        this.requestorDpi = requestorDpi;
        this.forceLongitudeFirst = forceLongitudeFirst == null ? false : forceLongitudeFirst;
        this.dpiSensitiveStyle = dpiSensitiveStyle;
    }

    public final double getRotation() {
        return this.rotation;
    }

    public final MapBounds getBounds() {
        return this.bounds;
    }

    public final MapBounds getRotatedBounds() {
        return this.bounds.adjustBoundsToRotation(this.rotation);
    }

    public final Dimension getMapSize() {
        return this.mapSize;
    }

    public final Scale getScale() {
        return this.bounds.getScaleDenominator(this.getPaintArea(), this.dpi);
    }

    public final double getRoundedScale() {
        double scale = this.bounds.getScaleDenominator(this.getPaintArea(), this.dpi).getDenominator();
        int numChars = String.format("%d", Math.round(scale)).length();
        if (numChars > 2) {
            double factor = Math.pow(10.0, numChars - 2);
            scale = (double)Math.round(scale / factor) * factor;
        } else if (scale > 1.0) {
            scale = Math.round(scale);
        }
        return scale;
    }

    public final Dimension getRotatedMapSize() {
        if (this.rotation == 0.0) {
            return this.mapSize;
        }
        int rotatedWidth = this.getRotatedMapWidth();
        int rotatedHeight = this.getRotatedMapHeight();
        return new Dimension(rotatedWidth, rotatedHeight);
    }

    public final AffineTransform getTransform() {
        if (this.rotation == 0.0) {
            return null;
        }
        Dimension rotatedMapSize = this.getRotatedMapSize();
        AffineTransform transform = AffineTransform.getTranslateInstance(0.0, 0.0);
        transform.translate(this.mapSize.width / 2, this.mapSize.height / 2);
        transform.rotate(this.rotation);
        transform.translate(-rotatedMapSize.width / 2, -rotatedMapSize.height / 2);
        return transform;
    }

    public final double getDPI() {
        return this.dpi;
    }

    public final double getRequestorDPI() {
        return this.requestorDpi;
    }

    private int getRotatedMapWidth() {
        double width = this.mapSize.getWidth();
        if (this.rotation != 0.0) {
            double height = this.mapSize.getHeight();
            width = Math.abs(width * Math.cos(this.rotation)) + Math.abs(height * Math.sin(this.rotation));
        }
        return (int)Math.round(width);
    }

    private int getRotatedMapHeight() {
        double height = this.mapSize.getHeight();
        if (this.rotation != 0.0) {
            double width = this.mapSize.getWidth();
            height = Math.abs(height * Math.cos(this.rotation)) + Math.abs(width * Math.sin(this.rotation));
        }
        return (int)Math.round(height);
    }

    public final Rectangle getPaintArea() {
        return new Rectangle(this.mapSize);
    }

    public final Boolean isForceLongitudeFirst() {
        return this.forceLongitudeFirst;
    }

    public final Boolean isDpiSensitiveStyle() {
        return this.dpiSensitiveStyle;
    }

    public final ReferencedEnvelope toReferencedEnvelope() {
        return this.bounds.toReferencedEnvelope(this.getPaintArea(), this.dpi);
    }
}

