/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.Constants;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FileUtils;
import org.mapfish.print.PrintException;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;

public class FeaturesParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesParser.class);
    private final MfClientHttpRequestFactory httpRequestFactory;
    private final boolean forceLongitudeFirst;

    public FeaturesParser(MfClientHttpRequestFactory httpRequestFactory, boolean forceLongitudeFirst) {
        this.httpRequestFactory = httpRequestFactory;
        this.forceLongitudeFirst = forceLongitudeFirst;
    }

    public final SimpleFeatureCollection autoTreat(Template template, String features) throws IOException {
        SimpleFeatureCollection featuresCollection = this.treatStringAsURL(template, features);
        if (featuresCollection == null) {
            featuresCollection = this.treatStringAsGeoJson(features);
        }
        return featuresCollection;
    }

    public final SimpleFeatureCollection treatStringAsURL(Template template, String geoJsonUrl) throws IOException {
        String geojsonString;
        URL url;
        try {
            url = FileUtils.testForLegalFileUrl(template.getConfiguration(), new URL(geoJsonUrl));
        }
        catch (MalformedURLException e) {
            return null;
        }
        Closer closer = Closer.create();
        try {
            Reader input;
            if (url.getProtocol().equalsIgnoreCase("file")) {
                CharSource charSource = Files.asCharSource((File)new File(url.getFile()), (Charset)Constants.DEFAULT_CHARSET);
                input = (Reader)closer.register((Closeable)charSource.openBufferedStream());
            } else {
                ClientHttpResponse response = (ClientHttpResponse)closer.register((Closeable)this.httpRequestFactory.createRequest(url.toURI(), HttpMethod.GET).execute());
                input = (Reader)closer.register((Closeable)new BufferedReader(new InputStreamReader(response.getBody(), Constants.DEFAULT_CHARSET)));
            }
            geojsonString = CharStreams.toString((Readable)input);
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
        finally {
            closer.close();
        }
        return this.treatStringAsGeoJson(geojsonString);
    }

    public final SimpleFeatureCollection treatStringAsGeoJson(String geoJsonString) throws IOException {
        return this.readFeatureCollection(geoJsonString);
    }

    private SimpleFeatureCollection readFeatureCollection(String geojsonData) throws IOException {
        String convertedGeojsonObject = this.convertToGeoJsonCollection(geojsonData);
        FeatureJSON geoJsonReader = new FeatureJSON();
        SimpleFeatureType featureType = this.createFeatureType(convertedGeojsonObject);
        if (featureType != null) {
            geoJsonReader.setFeatureType(featureType);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(convertedGeojsonObject.getBytes(Constants.DEFAULT_CHARSET));
        return (SimpleFeatureCollection)geoJsonReader.readFeatureCollection((InputStream)input);
    }

    private String convertToGeoJsonCollection(String geojsonData) {
        String convertedGeojsonObject = geojsonData.trim();
        if (convertedGeojsonObject.startsWith("[")) {
            convertedGeojsonObject = "{\"type\": \"FeatureCollection\", \"features\": " + convertedGeojsonObject + "}";
        }
        return convertedGeojsonObject;
    }

    private SimpleFeatureType createFeatureType(@Nonnull String geojsonData) {
        try {
            JSONObject geojson = new JSONObject(geojsonData);
            if (geojson.has("type") && geojson.getString("type").equalsIgnoreCase("FeatureCollection")) {
                CoordinateReferenceSystem crs = this.parseCoordinateReferenceSystem(geojson);
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName("GeosjonFeatureType");
                JSONArray features = geojson.getJSONArray("features");
                HashSet allAttributes = Sets.newHashSet();
                Class<Geometry> geomType = null;
                for (int i = 0; i < features.length(); ++i) {
                    JSONObject feature = features.getJSONObject(i);
                    JSONObject properties = feature.getJSONObject("properties");
                    Iterator keys = properties.keys();
                    while (keys.hasNext()) {
                        Class<Geometry> thisGeomType;
                        String nextKey = (String)keys.next();
                        if (!allAttributes.contains(nextKey)) {
                            allAttributes.add(nextKey);
                            builder.add(nextKey, Object.class);
                        }
                        if (geomType == Geometry.class || (thisGeomType = this.parseGeometryType(feature)) == null) continue;
                        if (geomType == null) {
                            geomType = thisGeomType;
                            continue;
                        }
                        if (geomType == thisGeomType) continue;
                        geomType = Geometry.class;
                    }
                }
                builder.add("geometry", geomType, crs);
                builder.setDefaultGeometry("geometry");
                return builder.buildFeatureType();
            }
            return null;
        }
        catch (JSONException e) {
            throw new PrintException("Invalid geoJSON: \n" + geojsonData + ": " + e.getMessage(), e);
        }
    }

    private Class<Geometry> parseGeometryType(@Nonnull JSONObject featureJson) throws JSONException {
        JSONObject geomJson = featureJson.optJSONObject("geometry");
        if (geomJson == null) {
            return null;
        }
        String geomTypeString = geomJson.optString("type", "Geometry");
        if (geomTypeString.equalsIgnoreCase("Positions")) {
            return Geometry.class;
        }
        try {
            return Class.forName("com.vividsolutions.jts.geom." + geomTypeString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unrecognized geometry type in geojson: " + geomTypeString);
        }
    }

    private CoordinateReferenceSystem parseCoordinateReferenceSystem(JSONObject geojson) {
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.GENERIC_2D;
        StringBuilder code = new StringBuilder();
        try {
            if (geojson.has("crs")) {
                JSONObject propertiesJson;
                JSONObject crsJson = geojson.getJSONObject("crs");
                if (crsJson.has("type")) {
                    code.append(crsJson.getString("type"));
                }
                if (crsJson.has("properties") && (propertiesJson = crsJson.getJSONObject("properties")).has("code")) {
                    if (code.length() > 0) {
                        code.append(":");
                    }
                    code.append(propertiesJson.getString("code"));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.warn("Error reading the required elements to parse crs of the geojson: \n" + geojson, (Throwable)e);
        }
        try {
            if (code.length() > 0) {
                crs = CRS.decode((String)code.toString(), (boolean)this.forceLongitudeFirst);
            }
        }
        catch (NoSuchAuthorityCodeException e) {
            LOGGER.warn("No CRS with code: " + code + ".\nRead from geojson: \n" + geojson);
        }
        catch (FactoryException e) {
            LOGGER.warn("Error loading CRS with code: " + code + ".\nRead from geojson: \n" + geojson);
        }
        return crs;
    }
}

