/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.vividsolutions.jts.util.Assert;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.mapfish.print.map.image.wms.WmsVersion;
import org.mapfish.print.map.tiled.AbstractWMXLayerParams;
import org.mapfish.print.parser.HasDefaultValue;

public class WmsLayerParam
extends AbstractWMXLayerParams {
    public String baseURL;
    public String[] layers;
    @HasDefaultValue
    public String[] styles;
    @HasDefaultValue
    public String version = "1.1.1";
    @HasDefaultValue
    public boolean useNativeAngle = false;
    @HasDefaultValue
    public ServerType serverType;

    @Override
    public final String getBaseUrl() {
        return this.baseURL;
    }

    public void postConstruct() throws URISyntaxException {
        WmsVersion.lookup(this.version);
        Assert.isTrue((boolean)this.validateBaseUrl(), (String)"invalid baseURL");
        Assert.isTrue((this.layers.length > 0 ? 1 : 0) != 0, (String)"There must be at least one layer defined for a WMS request to make sense");
        if (this.styles != null && this.styles.length != this.layers.length && this.styles.length == 1 && this.styles[0].trim().isEmpty()) {
            this.styles = null;
        } else {
            Assert.isTrue((this.styles == null || this.layers.length == this.styles.length ? 1 : 0) != 0, (String)("If styles are defined then there must be one for each layer.  Number of layers: " + this.layers.length + "\nStyles: " + Arrays.toString(this.styles)));
        }
        if (!this.imageFormat.startsWith("image/")) {
            this.imageFormat = "image/" + this.imageFormat;
        }
    }

    public static enum ServerType {
        MAPSERVER,
        GEOSERVER,
        QGISSERVER;

    }
}

