/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.wms;

import com.google.common.collect.Multimap;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import jsr166y.ForkJoinPool;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.Scale;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.wms.WmsUtilities;
import org.mapfish.print.map.tiled.AbstractTiledLayer;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.wms.TiledWmsLayerParam;
import org.opengis.referencing.FactoryException;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class TiledWmsLayer
extends AbstractTiledLayer {
    private final TiledWmsLayerParam param;

    public TiledWmsLayer(ForkJoinPool forkJoinPool, StyleSupplier<GridCoverage2D> styleSupplier, TiledWmsLayerParam param) {
        super(forkJoinPool, styleSupplier, param);
        this.param = param;
    }

    public TiledWmsLayerParam getParams() {
        return this.param;
    }

    @Override
    protected TileCacheInformation createTileInformation(MapBounds bounds, Rectangle paintArea, double dpi, boolean isFirstLayer) {
        return new WmsTileCacheInformation(bounds, paintArea, dpi, isFirstLayer);
    }

    private final class WmsTileCacheInformation
    extends TileCacheInformation {
        public WmsTileCacheInformation(MapBounds bounds, Rectangle paintArea, double dpi, boolean isFirstLayer) {
            super(bounds, paintArea, dpi, TiledWmsLayer.this.param);
        }

        @Override
        @Nonnull
        public ClientHttpRequest getTileRequest(MfClientHttpRequestFactory httpRequestFactory, String commonUrl, ReferencedEnvelope tileBounds, Dimension tileSizeOnScreen, int column, int row) throws IOException, URISyntaxException, FactoryException {
            URI uri = WmsUtilities.makeWmsGetLayerRequest(httpRequestFactory, TiledWmsLayer.this.param, new URI(commonUrl), tileSizeOnScreen, this.dpi, tileBounds);
            return httpRequestFactory.createRequest(uri, HttpMethod.GET);
        }

        @Override
        protected void customizeQueryParams(Multimap<String, String> result) {
        }

        @Override
        public Scale getScale() {
            return this.bounds.getScaleDenominator(this.paintArea, this.dpi);
        }

        @Override
        public Double getLayerDpi() {
            return this.dpi;
        }

        @Override
        public Dimension getTileSize() {
            return TiledWmsLayer.this.param.getTileSize();
        }

        @Override
        @Nonnull
        protected ReferencedEnvelope getTileCacheBounds() {
            return new ReferencedEnvelope((Envelope)this.bounds.toReferencedEnvelope(this.paintArea, this.dpi), this.bounds.getProjection());
        }
    }
}

