/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.vividsolutions.jts.util.Assert;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.DataSourceAttribute;
import org.mapfish.print.attribute.HttpRequestHeadersAttribute;
import org.mapfish.print.attribute.PrimitiveAttribute;
import org.mapfish.print.attribute.ReflectiveAttribute;
import org.mapfish.print.config.PDFConfig;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.ConfigFileResolvingHttpRequestFactory;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.mapfish.print.parser.MapfishParser;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.mapfish.print.wrapper.multi.PMultiObject;

public final class Values {
    public static final String TASK_DIRECTORY_KEY = "tempTaskDirectory";
    public static final String CLIENT_HTTP_REQUEST_FACTORY_KEY = "clientHttpRequestFactory";
    public static final String TEMPLATE_KEY = "template";
    public static final String PDF_CONFIG = "pdfConfig";
    public static final String SUBREPORT_DIR = "SUBREPORT_DIR";
    private final Map<String, Object> values = new ConcurrentHashMap<String, Object>();

    public Values(Map<String, Object> values) {
        this.values.putAll(values);
    }

    public Values() {
    }

    public Values(PJsonObject requestData, Template template, MapfishParser parser, File taskDirectory, MfClientHttpRequestFactoryImpl httpRequestFactory, File jasperTemplateBuild) throws JSONException {
        Assert.isTrue((!taskDirectory.mkdirs() || taskDirectory.exists() ? 1 : 0) != 0);
        this.values.put(TASK_DIRECTORY_KEY, taskDirectory);
        this.values.put(CLIENT_HTTP_REQUEST_FACTORY_KEY, new ConfigFileResolvingHttpRequestFactory(httpRequestFactory, template.getConfiguration()));
        this.values.put(TEMPLATE_KEY, template);
        this.values.put(PDF_CONFIG, template.getPdfConfig());
        this.values.put(SUBREPORT_DIR, jasperTemplateBuild.getAbsolutePath());
        PJsonObject jsonAttributes = requestData.getJSONObject("attributes");
        HashMap attributes = Maps.newHashMap(template.getAttributes());
        this.populateFromAttributes(template, parser, attributes, jsonAttributes);
    }

    public void populateFromAttributes(@Nonnull Template template, @Nonnull MapfishParser parser, @Nonnull Map<String, Attribute> attributes, @Nonnull PObject requestJsonAttributes) throws JSONException {
        if (requestJsonAttributes.has("requestHeaders") && requestJsonAttributes.getObject("requestHeaders").has("requestHeaders") && !attributes.containsKey("requestHeaders")) {
            attributes.put("requestHeaders", new HttpRequestHeadersAttribute());
        }
        for (String attributeName : attributes.keySet()) {
            Object value;
            Attribute attribute = attributes.get(attributeName);
            if (attribute instanceof PrimitiveAttribute) {
                PrimitiveAttribute pAtt = (PrimitiveAttribute)attribute;
                Object defaultVal = pAtt.getDefault();
                PObject jsonToUse = requestJsonAttributes;
                if (defaultVal != null) {
                    JSONObject obj = new JSONObject();
                    obj.put(attributeName, defaultVal);
                    PObject[] pValues = new PObject[]{requestJsonAttributes, new PJsonObject(obj, "default_" + attributeName)};
                    jsonToUse = new PMultiObject(pValues);
                }
                value = parser.parsePrimitive(attributeName, pAtt.getValueClass(), jsonToUse);
            } else if (attribute instanceof DataSourceAttribute) {
                DataSourceAttribute dsAttribute = (DataSourceAttribute)attribute;
                value = dsAttribute.parseAttribute(parser, template, requestJsonAttributes.optArray(attributeName));
            } else if (attribute instanceof ReflectiveAttribute) {
                boolean errorOnExtraParameters = template.getConfiguration().isThrowErrorOnExtraParameters();
                ReflectiveAttribute rAtt = (ReflectiveAttribute)attribute;
                value = rAtt.createValue(template);
                PObject pValue = requestJsonAttributes.optObject(attributeName);
                if (pValue != null) {
                    PObject[] pValues = new PObject[]{pValue, rAtt.getDefaultValue()};
                    pValue = new PMultiObject(pValues);
                } else {
                    pValue = rAtt.getDefaultValue();
                }
                parser.parse(errorOnExtraParameters, pValue, value, new String[0]);
            } else {
                throw new IllegalArgumentException("Unsupported attribute type: " + attribute);
            }
            this.put(attributeName, value);
        }
    }

    public Values(@Nonnull Values values) {
        this.addRequiredValues(values);
    }

    public void addRequiredValues(@Nonnull Values sourceValues) {
        Object taskDirectory = sourceValues.getObject(TASK_DIRECTORY_KEY, Object.class);
        MfClientHttpRequestFactory requestFactory = sourceValues.getObject(CLIENT_HTTP_REQUEST_FACTORY_KEY, MfClientHttpRequestFactory.class);
        Template template = sourceValues.getObject(TEMPLATE_KEY, Template.class);
        PDFConfig pdfConfig = sourceValues.getObject(PDF_CONFIG, PDFConfig.class);
        String subReportDir = sourceValues.getObject(SUBREPORT_DIR, String.class);
        this.values.put(TASK_DIRECTORY_KEY, taskDirectory);
        this.values.put(CLIENT_HTTP_REQUEST_FACTORY_KEY, requestFactory);
        this.values.put(TEMPLATE_KEY, template);
        this.values.put(PDF_CONFIG, pdfConfig);
        this.values.put(SUBREPORT_DIR, subReportDir);
    }

    public void put(String key, Object value) {
        if (TASK_DIRECTORY_KEY.equals(key) && this.values.keySet().contains(TASK_DIRECTORY_KEY)) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        if (value == null) {
            throw new IllegalArgumentException("A null value was attempted to be put into the values object under key: " + key);
        }
        this.values.put(key, value);
    }

    public Map<String, Object> asMap() {
        return this.values;
    }

    public String getString(String key) {
        return (String)this.values.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.values.get(key);
    }

    public Integer getInteger(String key) {
        return (Integer)this.values.get(key);
    }

    public <V> V getObject(String key, Class<V> type) {
        Object obj = this.values.get(key);
        return type.cast(obj);
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    @Nullable
    public Boolean getBoolean(@Nonnull String key) {
        return (Boolean)this.values.get(key);
    }

    public void remove(String key) {
        this.values.remove(key);
    }

    public <T> Map<String, T> find(final Class<T> valueTypeToFind) {
        Map filtered = Maps.filterEntries(this.values, (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(@Nullable Map.Entry<String, Object> input) {
                return input != null && valueTypeToFind.isInstance(input.getValue());
            }
        });
        return filtered;
    }

    public String toString() {
        return this.values.toString();
    }
}

