/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.vividsolutions.jts.util.Assert;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedByInterruptException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.config.ConfigurationFactory;
import org.mapfish.print.servlet.NoSuchAppException;
import org.mapfish.print.servlet.fileloader.ConfigFileLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ServletMapPrinterFactory
implements MapPrinterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletMapPrinterFactory.class);
    public static final String DEFAULT_CONFIGURATION_FILE_KEY = "default";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ConfigurationFactory configurationFactory;
    @Autowired
    private ConfigFileLoaderManager configFileLoader;
    private Map<String, URI> configurationFiles = new HashMap<String, URI>();
    private final Map<String, MapPrinter> printers = Maps.newConcurrentMap();
    private final HashMap<String, Long> configurationFileLastModifiedTimes = new HashMap();

    @PostConstruct
    private void validateConfigurationFiles() {
        if (!this.configurationFiles.containsKey(DEFAULT_CONFIGURATION_FILE_KEY)) {
            throw new BeanCreationException(this.getClass().getName() + " requires that one of the configurationFiles is called '" + DEFAULT_CONFIGURATION_FILE_KEY + "'");
        }
        for (URI file : this.configurationFiles.values()) {
            Assert.isTrue((boolean)this.configFileLoader.isAccessible(file), (String)(file + " does not exist or is not accessible."));
        }
    }

    @Override
    public final synchronized MapPrinter create(@Nullable String app) throws NoSuchAppException {
        URI configFile;
        String finalApp = app;
        if (app == null) {
            finalApp = DEFAULT_CONFIGURATION_FILE_KEY;
        }
        if ((configFile = this.configurationFiles.get(finalApp)) == null) {
            throw new NoSuchAppException("There is no configurationFile registered in the " + this.getClass().getName() + " bean with the " + "id: " + "'" + finalApp + "'");
        }
        long lastModified = this.configurationFileLastModifiedTimes.containsKey(finalApp) ? this.configurationFileLastModifiedTimes.get(finalApp) : 0L;
        MapPrinter printer = this.printers.get(finalApp);
        Optional<Long> configFileLastModified = this.configFileLoader.lastModified(configFile);
        if (configFileLastModified.isPresent() && (Long)configFileLastModified.get() > lastModified) {
            LOGGER.info("Configuration file modified. Reloading...");
            this.printers.remove(finalApp);
            printer = null;
        }
        if (printer == null) {
            if (configFileLastModified.isPresent()) {
                this.configurationFileLastModifiedTimes.put(finalApp, (Long)configFileLastModified.get());
            }
            try {
                LOGGER.info("Loading configuration file: " + configFile);
                printer = (MapPrinter)this.applicationContext.getBean(MapPrinter.class);
                byte[] bytes = this.configFileLoader.loadFile(configFile);
                printer.setConfiguration(configFile, bytes);
                this.printers.put(finalApp, printer);
            }
            catch (Throwable e) {
                if (e instanceof ClosedByInterruptException) {
                    Thread.currentThread().interrupt();
                }
                LOGGER.error("Error occurred while reading configuration file", e);
                throw new RuntimeException("Error occurred while reading configuration file '" + configFile + "': ", e);
            }
        }
        return printer;
    }

    @Override
    public final Set<String> getAppIds() {
        return this.configurationFiles.keySet();
    }

    public final void setConfigurationFiles(Map<String, String> configurationFiles) throws URISyntaxException {
        this.configurationFiles.clear();
        this.configurationFileLastModifiedTimes.clear();
        for (Map.Entry<String, String> entry : configurationFiles.entrySet()) {
            if (!entry.getValue().contains(":/")) {
                this.configurationFiles.put(entry.getKey(), new File(entry.getValue()).toURI());
                continue;
            }
            this.configurationFiles.put(entry.getKey(), new URI(entry.getValue()));
        }
        if (this.configFileLoader != null) {
            this.validateConfigurationFiles();
        }
    }

    public final void setAppsRootDirectory(String directory) throws URISyntaxException {
        Iterable children;
        if (!directory.contains(":/")) {
            children = Files.fileTreeTraverser().children((Object)new File(directory));
        } else {
            Optional<File> fileOptional = this.configFileLoader.toFile(new URI(directory));
            if (fileOptional.isPresent()) {
                children = Files.fileTreeTraverser().children(fileOptional.get());
            } else {
                throw new IllegalArgumentException(directory + " does not refer to a file on the current system.");
            }
        }
        for (File child : children) {
            File configFile = new File(child, "config.yaml");
            if (!configFile.exists()) continue;
            this.configurationFiles.put(child.getName(), configFile.toURI());
        }
        if (this.configurationFiles.isEmpty()) {
            throw new IllegalArgumentException(directory + " is an emptry directory.  There must be at least one subdirectory " + "containing a config.yaml file");
        }
        if (!this.configurationFiles.containsKey(DEFAULT_CONFIGURATION_FILE_KEY)) {
            String next = this.configurationFiles.keySet().iterator().next();
            URI uri = this.configurationFiles.get(next);
            this.configurationFiles.put(DEFAULT_CONFIGURATION_FILE_KEY, uri);
        }
    }
}

