/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.oldapi;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.LegendProcessor;
import org.mapfish.print.processor.jasper.TableProcessor;
import org.mapfish.print.processor.map.CreateMapProcessor;
import org.mapfish.print.servlet.oldapi.OldAPILayerConverter;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonArray;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OldAPIRequestConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldAPIRequestConverter.class);
    private static final Set<String> NON_CUSTOM_PARAMS = Sets.newHashSet((Object[])new String[]{"units", "srs", "layout", "dpi", "layers", "pages", "legends", "geodetic", "outputFilename", "outputFormat"});

    private OldAPIRequestConverter() {
    }

    public static PJsonObject convert(PJsonObject oldRequest, Configuration configuration) throws JSONException {
        String layout = oldRequest.getString("layout");
        if (configuration.getTemplate(layout) == null) {
            throw new IllegalArgumentException("Layout '" + layout + "' is not configured");
        }
        JSONObject request = new JSONObject();
        request.put("layout", (Object)oldRequest.getString("layout"));
        if (oldRequest.has("outputFilename")) {
            request.put("outputFilename", (Object)oldRequest.getString("outputFilename"));
        }
        if (oldRequest.has("outputFormat")) {
            request.put("outputFormat", (Object)oldRequest.getString("outputFormat"));
        }
        request.put("attributes", (Object)OldAPIRequestConverter.getAttributes(oldRequest, configuration.getTemplate(layout)));
        return new PJsonObject(request, "spec");
    }

    private static JSONObject getAttributes(PJsonObject oldRequest, Template template) throws JSONException {
        JSONObject attributes = new JSONObject();
        OldAPIRequestConverter.setMapAttribute(attributes, oldRequest, template);
        OldAPIRequestConverter.setTableAttribute(attributes, oldRequest, template);
        OldAPIRequestConverter.setLegendAttribute(attributes, oldRequest, template);
        Iterator<String> keys = oldRequest.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (NON_CUSTOM_PARAMS.contains(key)) continue;
            attributes.put(key, oldRequest.getInternalObj().get(key));
        }
        return attributes;
    }

    private static void setMapAttribute(JSONObject attributes, PJsonObject oldRequest, Template template) throws JSONException {
        CreateMapProcessor mapProcessor = OldAPIRequestConverter.getMapProcessor(template);
        PJsonObject oldMapPage = (PJsonObject)OldAPIRequestConverter.getOldMapPage(oldRequest);
        if (mapProcessor == null) {
            if (oldMapPage == null) {
                return;
            }
            LOGGER.warn("The request json data has attribute information for creating the map but config does not have amap attribute.  Check that the request and the config.yaml are correct.");
            return;
        }
        if (oldMapPage == null) {
            LOGGER.warn("The request json data does not have attribute information for creating the map.  Check that the request and the config.yaml are correct.");
            return;
        }
        String mapAttributeName = "map";
        if (mapProcessor.getInputMapperBiMap().containsValue((Object)"map")) {
            mapAttributeName = (String)mapProcessor.getInputMapperBiMap().inverse().get((Object)"map");
        }
        JSONObject map = new JSONObject();
        attributes.put(mapAttributeName, (Object)map);
        if (oldRequest.has("srs")) {
            map.put("projection", (Object)oldRequest.getString("srs"));
        }
        if (oldRequest.has("dpi")) {
            map.put("dpi", oldRequest.getInt("dpi"));
        }
        if (oldMapPage.has("rotation")) {
            map.put("rotation", oldMapPage.getDouble("rotation"));
        }
        if (oldMapPage.has("bbox")) {
            map.put("bbox", (Object)oldMapPage.getInternalObj().getJSONArray("bbox"));
        } else if (oldMapPage.has("center") && oldMapPage.has("scale")) {
            map.put("center", (Object)oldMapPage.getInternalObj().getJSONArray("center"));
            map.put("scale", oldMapPage.getDouble("scale"));
        }
        OldAPIRequestConverter.setMapLayers(map, oldRequest);
    }

    private static CreateMapProcessor getMapProcessor(Template template) {
        CreateMapProcessor mapProcessor = null;
        for (Processor processor : template.getProcessors()) {
            if (!(processor instanceof CreateMapProcessor)) continue;
            if (mapProcessor == null) {
                mapProcessor = (CreateMapProcessor)processor;
                continue;
            }
            throw new UnsupportedOperationException("Template contains more than one map configuration. The legacy API supports only one map per template.");
        }
        return mapProcessor;
    }

    private static PObject getOldMapPage(PJsonObject oldRequest) {
        PArray pages = oldRequest.getArray("pages");
        PObject mapPage = null;
        for (int i = 0; i < pages.size(); ++i) {
            PObject page = pages.getObject(i);
            if (!OldAPIRequestConverter.isMapPage(page)) continue;
            if (mapPage == null) {
                mapPage = page;
                continue;
            }
            throw new UnsupportedOperationException("Request contains more than one page with a map. The legacy API supports only one map per report.");
        }
        return mapPage;
    }

    private static boolean isMapPage(PObject page) {
        if (page.has("bbox") || page.has("center") && page.has("scale")) {
            return page.optBool("showMap", true);
        }
        return false;
    }

    private static void setMapLayers(JSONObject map, PJsonObject oldRequest) throws JSONException {
        JSONArray layers = new JSONArray();
        map.put("layers", (Object)layers);
        if (!oldRequest.has("layers")) {
            return;
        }
        PArray oldLayers = oldRequest.getArray("layers");
        for (int i = oldLayers.size() - 1; i > -1; --i) {
            PJsonObject oldLayer = (PJsonObject)oldLayers.getObject(i);
            layers.put((Object)OldAPILayerConverter.convert(oldLayer));
        }
    }

    private static void setLegendAttribute(JSONObject attributes, PJsonObject oldRequest, Template template) throws JSONException {
        List<LegendProcessor> legendProcessors = OldAPIRequestConverter.getLegendProcessor(template);
        PJsonArray oldLegendJson = OldAPIRequestConverter.getLegendJson(oldRequest);
        if (legendProcessors.isEmpty()) {
            if (oldLegendJson == null) {
                return;
            }
            LOGGER.warn("The request json data has attribute information for creating the map but config does not have amap attribute.  Check that the request and the config.yaml are correct.");
            return;
        }
        if (oldLegendJson == null) {
            LOGGER.warn("Configuration expects a table, but no table data is defined in the request");
            oldLegendJson = new PJsonArray(oldRequest, new JSONArray(), "generated");
        }
        if (legendProcessors.size() != oldLegendJson.size()) {
            LOGGER.warn("Not all legends processors have request data.  There are " + legendProcessors.size() + " and there are " + oldLegendJson.size() + " legend request objects.");
        }
        String legendAttName = "legend";
        for (int i = 0; i < legendProcessors.size(); ++i) {
            LegendProcessor legendProcessor = legendProcessors.get(i);
            if (legendProcessor.getInputMapperBiMap().containsValue((Object)"legend")) {
                legendAttName = (String)legendProcessor.getInputMapperBiMap().inverse().get((Object)"legend");
            }
            JSONObject value = oldLegendJson.size() > i ? oldLegendJson.getJSONObject(i).getInternalObj() : new JSONObject();
            attributes.put(legendAttName, (Object)value);
        }
        if (legendProcessors.size() < oldLegendJson.size()) {
            JSONObject newApiValue = new JSONObject();
            JSONArray classes = new JSONArray();
            newApiValue.put("classes", (Object)classes);
            classes.put(attributes.get(legendAttName));
            attributes.put(legendAttName, (Object)newApiValue);
            for (int i = legendProcessors.size(); i < oldLegendJson.size(); ++i) {
                classes.put((Object)oldLegendJson.getJSONObject(i).getInternalObj());
            }
        }
    }

    private static PJsonArray getLegendJson(PJsonObject oldRequest) {
        return oldRequest.optJSONArray("legends");
    }

    private static List<LegendProcessor> getLegendProcessor(Template template) {
        ArrayList processors = Lists.newArrayList();
        for (Processor processor : template.getProcessors()) {
            if (!(processor instanceof LegendProcessor)) continue;
            LegendProcessor legendProcessor = (LegendProcessor)processor;
            processors.add(legendProcessor);
        }
        return processors;
    }

    private static void setTableAttribute(JSONObject attributes, PJsonObject oldRequest, Template template) throws JSONException {
        TableProcessor tableProcessor = OldAPIRequestConverter.getTableProcessor(template);
        PJsonObject oldTablePage = (PJsonObject)OldAPIRequestConverter.getOldTablePage(oldRequest);
        if (tableProcessor == null) {
            if (oldTablePage == null) {
                return;
            }
            LOGGER.warn("The request json data has attribute information for creating the map but config does not have amap attribute.  Check that the request and the config.yaml are correct.");
            return;
        }
        if (oldTablePage == null) {
            LOGGER.warn("Configuration expects a table, but no table data is defined in the request");
            oldTablePage = new PJsonObject(oldRequest, new JSONObject(), "generated");
        }
        String tableAttributeName = "table";
        if (tableProcessor.getInputMapperBiMap().containsValue((Object)"table")) {
            tableAttributeName = (String)tableProcessor.getInputMapperBiMap().inverse().get((Object)"table");
        }
        JSONObject table = new JSONObject();
        attributes.put(tableAttributeName, (Object)table);
        List<String> columnKeys = OldAPIRequestConverter.getTableColumnKeys(oldTablePage);
        List<String> columnLabels = OldAPIRequestConverter.getTableColumnLabels(columnKeys, oldTablePage);
        List<JSONArray> tableData = OldAPIRequestConverter.getTableData(columnKeys, oldTablePage);
        table.put("columns", columnLabels);
        table.put("data", tableData);
    }

    private static TableProcessor getTableProcessor(Template template) {
        TableProcessor tableProcessor = null;
        for (Processor processor : template.getProcessors()) {
            if (!(processor instanceof TableProcessor)) continue;
            if (tableProcessor == null) {
                tableProcessor = (TableProcessor)processor;
                continue;
            }
            throw new UnsupportedOperationException("Template contains more than one table configuration. The legacy API supports only one table per template.");
        }
        return tableProcessor;
    }

    private static PObject getOldTablePage(PJsonObject oldRequest) {
        PArray pages = oldRequest.getArray("pages");
        PObject tablePage = null;
        for (int i = 0; i < pages.size(); ++i) {
            PObject page = pages.getObject(i);
            if (!OldAPIRequestConverter.isTablePage(page)) continue;
            if (tablePage == null) {
                tablePage = page;
                continue;
            }
            throw new UnsupportedOperationException("Request contains more than one page with a table. The legacy API supports only one table per report.");
        }
        return tablePage;
    }

    private static boolean isTablePage(PObject page) {
        if (page.has("table")) {
            PObject table = page.getObject("table");
            if (table.getArray("columns").size() == 1 && table.getArray("data").size() == 1) {
                String columnName = table.getArray("columns").getString(0);
                String value = table.getArray("data").getObject(0).getString(columnName);
                return !Strings.isNullOrEmpty((String)value);
            }
            return true;
        }
        return false;
    }

    private static List<String> getTableColumnKeys(PJsonObject oldTablePage) {
        PJsonObject table = oldTablePage.optJSONObject("table");
        LinkedList<String> columnKeys = new LinkedList<String>();
        if (table != null) {
            PArray columns = table.optArray("columns", new PJsonArray(table, new JSONArray(), "columns"));
            for (int i = 0; i < columns.size(); ++i) {
                columnKeys.add(columns.getString(i));
            }
        }
        return columnKeys;
    }

    private static List<String> getTableColumnLabels(List<String> columnKeys, PJsonObject oldTablePage) {
        LinkedList<String> columnLabels = new LinkedList<String>();
        for (String key : columnKeys) {
            if (oldTablePage.has(key)) {
                columnLabels.add(oldTablePage.getString(key));
                continue;
            }
            columnLabels.add("");
        }
        return columnLabels;
    }

    private static List<JSONArray> getTableData(List<String> columnKeys, PJsonObject oldTablePage) {
        PJsonObject table = oldTablePage.optJSONObject("table");
        LinkedList<JSONArray> tableData = new LinkedList<JSONArray>();
        if (table != null) {
            PArray oldTableRows = table.optArray("data", new PJsonArray(table, new JSONArray(), "data"));
            for (int i = 0; i < oldTableRows.size(); ++i) {
                PObject oldRow = oldTableRows.getObject(i);
                if (!oldRow.keys().hasNext()) continue;
                JSONArray row = new JSONArray();
                for (String key : columnKeys) {
                    row.put((Object)oldRow.getString(key));
                }
                tableData.add(row);
            }
        }
        return tableData;
    }
}

