/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.wrapper;

import org.mapfish.print.wrapper.json.PJsonArray;

public abstract class PElement {
    private final PElement parent;
    private final String contextName;

    protected PElement(PElement parent, String contextName) {
        this.parent = parent;
        this.contextName = contextName;
    }

    public final String getPath(String key) {
        StringBuilder result = new StringBuilder();
        this.addPathTo(result);
        result.append(".");
        result.append(PElement.getPathElement(key));
        return result.toString();
    }

    protected final String getContextName() {
        return this.contextName;
    }

    public final String getCurrentPath() {
        StringBuilder result = new StringBuilder();
        this.addPathTo(result);
        return result.toString();
    }

    protected final void addPathTo(StringBuilder result) {
        if (this.parent != null) {
            this.parent.addPathTo(result);
            if (!(this.parent instanceof PJsonArray)) {
                result.append(".");
            }
        }
        result.append(PElement.getPathElement(this.contextName));
    }

    private static String getPathElement(String val) {
        if (val == null) {
            return "";
        }
        if (val.contains(" ")) {
            return "'" + val + "'";
        }
        return val;
    }

    public final PElement getParent() {
        return this.parent;
    }
}

