/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map;

import javax.annotation.Nonnull;
import org.mapfish.print.map.DistanceUnit;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class Scale {
    private final double denominator;

    public Scale(double denominator) {
        this.denominator = denominator;
    }

    public double getDenominator() {
        return this.denominator;
    }

    public double toResolution(@Nonnull CoordinateReferenceSystem projection, double dpi) {
        double normScale = this.normalizeScale(this.denominator);
        double distancePerInch = DistanceUnit.fromProjection(projection).convertTo(normScale, DistanceUnit.IN);
        return 1.0 / (distancePerInch * dpi);
    }

    private double normalizeScale(double scale) {
        if (scale > 1.0) {
            return 1.0 / scale;
        }
        return scale;
    }

    public static Scale fromResolution(double resolution, @Nonnull CoordinateReferenceSystem projection, double dpi) {
        double resolutionInInches = DistanceUnit.fromProjection(projection).convertTo(resolution, DistanceUnit.IN);
        return new Scale(resolutionInInches * dpi);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scale scale = (Scale)o;
        return Double.compare(scale.denominator, this.denominator) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.denominator);
        int result = (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Scale{" + this.denominator + '}';
    }
}

