/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import org.mapfish.print.config.PDFConfig;
import org.mapfish.print.output.AbstractJasperReportOutputFormat;
import org.mapfish.print.output.OutputFormat;

public final class JasperReportPDFOutputFormat
extends AbstractJasperReportOutputFormat
implements OutputFormat {
    @Override
    public String getContentType() {
        return "application/pdf";
    }

    @Override
    public String getFileSuffix() {
        return "pdf";
    }

    @Override
    protected void doExport(OutputStream outputStream, AbstractJasperReportOutputFormat.Print print) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter(print.context);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print.print);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PDF_VERSION, (Object)JRPdfExporterParameter.PDF_VERSION_1_7);
        PDFConfig pdfConfig = print.values.getObject("pdfConfig", PDFConfig.class);
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_COMPRESSED, (Object)pdfConfig.isCompressed());
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)pdfConfig.getAuthor());
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_CREATOR, (Object)pdfConfig.getCreator());
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_SUBJECT, (Object)pdfConfig.getSubject());
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)pdfConfig.getTitle());
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_KEYWORDS, (Object)pdfConfig.getKeywordsAsString());
        exporter.exportReport();
    }
}

